package com.tandbergtv.cms.rules.ui.client.msooverride;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.google.gwt.user.client.ui.HasName;

public class UiMso implements IsSerializable, HasName {

	Integer id;
	String name;

	/**
	 * default contstructor: do not remove needed for GWT
	 */
	public UiMso() {
	}

	/**
	 * @param id The id of the MSO
	 * @param name The name of the MSO
	 */
	public UiMso(Integer id, String name) {
		this.id = id;
		this.name = name;
	}



	/**
	 * @return the id of the MSO
	 */
	public Integer getId() {
		return id;
	}

	/**
	 * @param id the id to set
	 */
	public void setId(Integer id) {
		this.id = id;
	}

	/**
	 * @return the name of the MSO
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}
	
	@Override
	public int hashCode() {
		return(name+id).hashCode();
	}
	
	@Override
	public boolean equals(Object obj) {
		if(obj != null && obj instanceof UiMso) {
			UiMso other = (UiMso) obj;
			return name.equals(other.name) && id.equals(other.id);
		}
		return false;
	}
}
