package com.tandbergtv.cms.rules.ui.client.normalization;

import java.util.List;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.TreeItem;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.TypedTreeCreator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UIDataType;

public class ActionDataTypeSpecificFieldSelector extends ActionFieldSelector {

	// String complaint values
	private static List<TreeItem> stringNonMatchedTreeItem;
	// Integer + String complaint values
	private static List<TreeItem> intNonMatchedTreeItem;
	// float + String complaint values
	private static List<TreeItem> floatNonMatchedTreeItem;
	// Boolean complaint values
	private static List<TreeItem> boolNonMatchedTreeItem;
	// Date complaint values
	private static List<TreeItem> dateNonMatchedTreeItem;
	// Time complaint values
	private static List<TreeItem> timeNonMatchedTreeItem;

	private UIDataType dataType;

	public static void clearCache() {
		stringNonMatchedTreeItem = null;
		intNonMatchedTreeItem = null;
		floatNonMatchedTreeItem = null;
		boolNonMatchedTreeItem = null;
		dateNonMatchedTreeItem = null;
		timeNonMatchedTreeItem = null;
	}

	public ActionDataTypeSpecificFieldSelector(
			SelectionHandler<IFieldTreeObject> selectHandler,
			UIDataType dataType, IMatchedItemProvider matchedItemProvider) {
		super(matchedItemProvider);
		this.dataType = dataType;
		addSelectionHandler(selectHandler);
	}

	private void initializeNonMatchedTree(UIDataType dataType) {
		if (dataType.equals(UIDataType.STRING)
				&& stringNonMatchedTreeItem == null) {
			stringNonMatchedTreeItem = TypedTreeCreator.getTreeItems(
					getCriteriaType(), getCriteriaMode(), UIDataType.STRING, true);
		} else if (dataType.equals(UIDataType.INTEGER)
				&& intNonMatchedTreeItem == null) {
			intNonMatchedTreeItem = TypedTreeCreator.getTreeItems(
					getCriteriaType(), getCriteriaMode(), UIDataType.INTEGER, true);
		} else if (dataType.equals(UIDataType.FLOAT)
				&& floatNonMatchedTreeItem == null) {
			floatNonMatchedTreeItem = TypedTreeCreator.getTreeItems(
					getCriteriaType(), getCriteriaMode(), UIDataType.FLOAT, true);
		} else if (dataType.equals(UIDataType.BOOLEAN)
				&& boolNonMatchedTreeItem == null) {
			boolNonMatchedTreeItem = TypedTreeCreator.getTreeItems(
					getCriteriaType(), getCriteriaMode(), UIDataType.BOOLEAN, true);
		} else if (dataType.equals(UIDataType.DATE)
				&& dateNonMatchedTreeItem == null) {
			dateNonMatchedTreeItem = TypedTreeCreator.getTreeItems(
					getCriteriaType(), getCriteriaMode(), UIDataType.DATE, true);
		} else if (dataType.equals(UIDataType.TIME)
				&& timeNonMatchedTreeItem == null) {
			timeNonMatchedTreeItem = TypedTreeCreator.getTreeItems(
					getCriteriaType(), getCriteriaMode(), UIDataType.TIME, true);
		}
	}

	@Override
	protected TreeItem getTreeItem(IFieldTreeObject treeObj) {
		return TypedTreeCreator.convertToTreeItem(treeObj, getCriteriaType(),getCriteriaMode(), dataType, true);
	}


	private List<TreeItem> getNonMatchedTree() {
		initializeNonMatchedTree(dataType);
		switch (dataType) {
		case STRING:
			return stringNonMatchedTreeItem;
		case TIME:
			return timeNonMatchedTreeItem;
		case INTEGER:
			return intNonMatchedTreeItem;
		case FLOAT:
			return floatNonMatchedTreeItem;
		case DATE:
			return dateNonMatchedTreeItem;
		case BOOLEAN:
			return boolNonMatchedTreeItem;
		default:
			return null;
		}
	}

	@Override
	public void onClick(ClickEvent event) {
		onClickHelper(event, getNonMatchedTree(), true);
	}

	public void setDataType(UIDataType dataType) {
		this.dataType = dataType;
	}

	public UIDataType getDataType() {
		return dataType;
	}

	@Override
	protected boolean isInvalidFieldSelection(IFieldTreeObject fieldTree) {
		return super.isInvalidFieldSelection(fieldTree) || fieldTree.getDataType().equals(UIDataType.COMPLEX);
	}

	@Override
	protected CriteriaType getCriteriaType() {
		return CriteriaType.ACTION_RHS;
	}

	@Override
	protected UiCriteriaMode getCriteriaMode() {
		return UiCriteriaMode.EPISODE;
	}
	
	protected TreeItem getMatchedItems() {
		TreeItem matchedItem = new TreeItem(titleConstants.matched());
		MatchedItemIterator iterator = getMatchedItemTreeObj();
		while(iterator.hasNext()) {
			TreeItem item = TypedTreeCreator.convertToTreeItem(iterator.next(), getCriteriaType(), getCriteriaMode(), dataType, true);
			if(item != null)
				matchedItem.addItem(item);
		}
		return matchedItem;
	}

}
