package com.tandbergtv.cms.rules.ui.client.normalization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.TitleConstants;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.ItemSelectableHandler;
import com.tandbergtv.cms.portal.ui.title.client.criteria.TreeCreator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.TreeSearcher;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.AssetFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.AssetTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IMIFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.LicenseTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.MatchedItemTreeObj;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.PMMTitleTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UIDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TreeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.PopupContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;

public abstract class ActionFieldSelector extends PopupContainer implements
		HasSelectionHandlers<IFieldTreeObject>, ClickHandler,
		SelectionHandler<TreeItem> {
	protected TreeWidget tree;
	private Tree fieldTree = new Tree();
	private Tree wholeTree = new Tree();
	private IFieldTreeObject treeObject;
	private VerticalPanel mainPanel = new VerticalPanel();
	private HorizontalPanel fieldPanel = new HorizontalPanel();
	private HorizontalPanel searchPanel = new HorizontalPanel();
	private HorizontalPanel buttonPanel = new HorizontalPanel();
	private HorizontalPanel bPanel = new HorizontalPanel();
	private HorizontalPanel expandPanel = new HorizontalPanel();
	private VerticalPanel leftContainer = new VerticalPanel();
	private VerticalPanel rightContainer = new VerticalPanel();
	private ScrollPanel assetScrollPanel = new ScrollPanel();
	private ScrollPanel fieldScrollPanel = new ScrollPanel();
	private Anchor expandBtn = new Anchor("Expand All");
	private Anchor collapseBtn = new Anchor("Collapse All");
	Button okButton = new Button("OK");
	Button cancelButton = new Button("Cancel");
	private TabPanel popupTabPanel = new TabPanel();
	protected TreeItem selectedItem;
	protected IFieldTreeObject selectedObject;
	
	private Timer timer;
	protected TitleConstants titleConstants = (TitleConstants) GWT
			.create(TitleConstants.class);

	private int currentPosition = 0;
	private TreeSearcher srchBox = new TreeSearcher(wholeTree, new TreeSearchHandler(), new ActionItemSelectableHandler());
	protected IMatchedItemProvider matchedItemProvider;

	private static TreeWidget lastActiveTree;
	
	public ActionFieldSelector(IMatchedItemProvider matchedItemProvider) {
		this.matchedItemProvider = matchedItemProvider;
	}
	
	public static void clearCache() {
		lastActiveTree = null;
	}

	/**
	 * Used for matched items to get the root of the selected field.
	 * 
	 * @return the root of the selected field if the selected field is a matched
	 *         item or null.
	 */
	public IFieldTreeObject getSelectedFieldParent() {
		IFieldTreeObject currSelected = getSelectedField();
		if (currSelected instanceof MatchedItemTreeObj)
			return ((MatchedItemTreeObj) currSelected).getParent();
		return null;
	}

	/**
	 * Returns the selected field.
	 * 
	 * @return the selected field.
	 */
	public IFieldTreeObject getSelectedField() {
		return selectedObject;
	}

	/**
	 * Returns true if the selected item is a matched item.
	 * 
	 * @return true if the selected item is a matched item.
	 */
	public boolean isMatchedItem() {
		return getSelectedField() instanceof MatchedItemTreeObj;
	}

	/**
	 * sets the field tree to the item passed.
	 * 
	 * @param treeObject
	 *            The tree object you want to be selected
	 * @throws InvalidFieldException
	 *             thrown if the treeObject isn't in the field selector
	 */
	public void setFieldItem(IFieldTreeObject treeObject) {
		selectedObject = treeObject;
	}

	protected void collapseTree() {
		for (int i = 0; i < tree.getItemCount(); i++) {
			collapseTreeItem(tree.getItem(i));
		}
	}

	protected void collapseTreeItem(TreeItem item) {
		if (item.getState()) {
			item.setState(false);
			for (int i = 0; i < item.getChildCount(); i++) {
				collapseTreeItem(item.getChild(i));
			}
		}
	}

	protected void initializeTree() {
		okButton.setWidth("50px");
		cancelButton.setWidth("100px");
		buttonPanel.setWidth("100%");
		addButtons();
		addCloseHandler();
		buttonPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);

		buttonPanel.add(bPanel);
	
		tree = new TreeWidget();
		assetScrollPanel.setWidget(tree);
		assetScrollPanel.setSize("300px", "250px");
		fieldScrollPanel.setWidget(fieldTree);
		fieldScrollPanel.setSize("300px", "250px");
		searchPanel.setWidth("100%");
		// fieldScrollPanel.setSize("100%", "100%");
		leftContainer.add(assetScrollPanel);
		expandPanel.setWidth("100%");
		expandPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
		expandPanel.add(expandBtn);
		expandPanel.add(collapseBtn);
		rightContainer.add(expandPanel);
		rightContainer.add(fieldScrollPanel);
		searchPanel.add(getControlWidget());
		fieldPanel.add(leftContainer);
		fieldPanel.add(rightContainer);
		setAutoHideEnabled(true);
		tree.addSelectionHandler(this);
		mainPanel.add(searchPanel);
		mainPanel.add(fieldPanel);
		mainPanel.add(buttonPanel);
	//
	//	popupTabPanel.add(new HTML("Most Common"), "Most Common");
		popupTabPanel.add(mainPanel, "All");
		popupTabPanel.selectTab(0);
		timer = new Timer() {
			public void run() {
				assetScrollPanel.setScrollPosition(currentPosition);
			}
		};
		addScrollHack();
		
		setWidget(popupTabPanel); // full tree view by default
	}
	
	protected boolean isInvalidFieldSelection(IFieldTreeObject treeObj) {
		return treeObj == null
				|| !treeObj.supportsCriteriaType(getCriteriaType(),
						getCriteriaMode());
	}

	/*
	 * this is to fix that bloody hack that moves the wheel back and forth
	 */
	private void addScrollHack() {
		tree.addMouseDownHandler(new MouseDownHandler() {
			@Override
			public void onMouseDown(MouseDownEvent event) {
				currentPosition = assetScrollPanel.getScrollPosition();
			}
		});

		tree.addMouseUpHandler(new MouseUpHandler() {
			@Override
			public void onMouseUp(MouseUpEvent event) {
				timer.schedule(5);
			}
		});
	}

	protected TreeItem findNonMatchedItem(String assetType, String xpath, UIFieldType fieldType, List<TreeItem> treeItems) {
		for (TreeItem item : treeItems) {
			TreeItem foundItem = findFieldItem(item, assetType, xpath, fieldType);
			if (foundItem != null)
				return foundItem;
		}
		return null;
	}

	private TreeItem findFieldItem(TreeItem root, String assetType, String xpath, UIFieldType fieldType) {
		// the first item is the root package for non-matched items
		IFieldTreeObject rootObj = (IFieldTreeObject) root.getUserObject();

		if (rootObj != null && rootObj.getFieldType().equals(fieldType)
				&& rootObj.getAssetType().equals(assetType)
				&& rootObj.getField().equals(xpath)) {
			return root;
		} else {
			for (int i = 0; i < root.getChildCount(); i++) {
				// TODO optimize this ugly crap
				TreeItem item = findFieldItem(root.getChild(i), assetType,
						xpath, fieldType);
				if (item != null)
					return item;
			}
		}
		return null;
	}
	
	protected TreeItem getMatchedItems() {
		TreeItem matchedItem = new TreeItem(titleConstants.matched());
		MatchedItemIterator iterator = getMatchedItemTreeObj();
		while(iterator.hasNext()) {
			matchedItem.addItem(TreeCreator.convertToTreeItem(iterator.next(), getCriteriaType(), getCriteriaMode()));
		}
		return matchedItem;
	}

	protected MatchedItemIterator getMatchedItemTreeObj() {
		return new MatchedItemIterator(matchedItemProvider.getVariables());
	}

	protected TreeItem findMatchedFieldItem(TreeItem matchedItem, MatchedItemTreeObj matchedObj) {
		String rootxpath = matchedObj.getParent().getField();
		String rootAssetPath = matchedObj.getParent().getAssetType();
		String assetType = matchedObj.getAssetType();
		String xpath = matchedObj.getField();
		if(!rootxpath.isEmpty() && !rootxpath.startsWith("/")) {
			rootAssetPath = rootxpath;
			rootxpath = "";
		}
			
		UIFieldType fieldType = matchedObj.getFieldType();
		for (int i = 0; i < matchedItem.getChildCount(); i++) {
			MatchedItemTreeObj treeObj = (MatchedItemTreeObj) matchedItem
					.getChild(i).getUserObject();
			String miField = treeObj.getField();
			String miAssetType = treeObj.getAssetType();
			if (miAssetType.equals(rootAssetPath) &&  miField.equals(rootxpath)) {
				TreeItem item = findFieldItem(matchedItem.getChild(i),
						assetType, xpath, fieldType);
				if (item != null)
					return item;
			}
		}
		return null;
	}
	
	protected abstract TreeItem getTreeItem(IFieldTreeObject treeObj);

	protected void onClickHelper(ClickEvent event, List<TreeItem> nonMatchedTreeItem, boolean nonMatchedAreShared) {
		TreeItem matchedItem = null;
		//if (tree == null) {
			initializeTree();
			matchedItem = getMatchedItems();
			addMatchedItemsToTrees(matchedItem);
			tree.addItem(matchedItem);
			TreeItem wholeTreeItem = getMatchedItems();
			this.wholeTree.addItem(wholeTreeItem);
			addNonMatchedItemsToTrees(nonMatchedTreeItem);
			

	//	} else {
			//re add the non matched tree items if necessary
	//		if(nonMatchedAreShared && lastActiveTree != tree) {
	//			addNonMatchedItemsToTrees(nonMatchedTreeItem);
	//		}
				
	//	}
			//CLEAN UP MATCHED ITEMS
//			matchedItem = tree.getItem(0);
//			int i = 0;
//			MatchedItemIterator matchedIterator = getMatchedItemTreeObj();
//			MatchedItemTreeObj currMatched = null;
//			if(matchedIterator.hasNext())
//				currMatched = matchedIterator.next();
//			while(currMatched != null && i < matchedItem.getChildCount()) {
//				TreeItem childItem = matchedItem.getChild(i);
//				MatchedItemTreeObj treeMatched = (MatchedItemTreeObj) childItem.getUserObject();
//				if(treeMatched.equals(currMatched)) {
//					i++;
//					if(matchedIterator.hasNext())
//						currMatched = matchedIterator.next();
//					else
//						currMatched = null;
//				} else {
//					childItem.remove();
//				}
//			} 
//			while(i < matchedItem.getChildCount()) {
//				matchedItem.getChild(i).remove();
//				i++;
//			}
//			while(currMatched != null) {
//				TreeItem childMatched = getTreeItem(currMatched);
//				if(childMatched != null)
//					matchedItem.addItem(childMatched);
//				if(matchedIterator.hasNext())
//					currMatched = matchedIterator.next();
//				else
//					currMatched = null;
//			
//		}

		srchBox.reset();
//		if(nonMatchedAreShared && lastActiveTree != tree)
//			collapseTree();
//		if(nonMatchedAreShared)
//			lastActiveTree = tree;
//
		final Widget widget = (Widget) event.getSource();
		setPopupPositionAndShow(new PopupPanel.PositionCallback() {
			public void setPosition(int offsetWidth, int offsetHeight) {
				setPopupPosition(widget.getAbsoluteLeft(), widget
						.getAbsoluteTop());
			}
		});
		if(selectedItem == null && selectedObject != null && selectedObject instanceof MatchedItemTreeObj) {
			selectedItem = findMatchedFieldItem(matchedItem, (MatchedItemTreeObj) selectedObject); 
		} else if(selectedItem == null && selectedObject != null) {
			String assetType = selectedObject.getAssetType();
			String xpath = selectedObject.getField();
			UIFieldType fieldType = selectedObject.getFieldType();
			selectedItem = findNonMatchedItem(assetType, xpath, fieldType, nonMatchedTreeItem);
		}

		if(selectedItem != null) {
			this.treeObject = (IFieldTreeObject) selectedItem.getUserObject();
			setSelectedItem(this.treeObject);
			
		}
	}

	private void addMatchedItemsToTrees(TreeItem matchedItem) {
		
		
		if(matchedItem.getChildCount()>0) {
			for(int i = 0; i<matchedItem.getChildCount(); i++ ) {
				TreeItem rootItem = matchedItem.getChild(i);
				IFieldTreeObject rootObj = (IFieldTreeObject) rootItem.getUserObject();
				if(rootObj != null) {
					//if complex type
					if(rootObj.getDataType().value().equalsIgnoreCase(UIDataType.COMPLEX.value()) && (rootItem.getChildCount() >0)) {
						rootItem.removeItems();
					}
					
				}
				else { //if package or series
					if(rootItem.getChildCount() >0) {
						for(int j = 0; j<rootItem.getChildCount(); j++ ) {
							TreeItem childItem = rootItem.getChild(j);
							IFieldTreeObject childObj = (IFieldTreeObject) childItem.getUserObject();
							if(childObj.getDataType().value().equalsIgnoreCase(UIDataType.COMPLEX.value())) {
								//remove children
								childItem.removeItems();
								
								
							}
						}
					}
				}
			}
		}
		
		
//		Iterator<TreeItem> iterator = tree.treeItemIterator();
//		while (iterator.hasNext()) {
//			TreeItem item = iterator.next();
//			IFieldTreeObject findObj = (IFieldTreeObject) item.getUserObject();
//			if(findObj != null) {
//				if(findObj instanceof MatchedItemTreeObj) {
//					if(((MatchedItemTreeObj) findObj).getUserObject() instanceof AssetFieldTreeObject) {
//						
//						if(findObj.getDataType().value().equalsIgnoreCase(UIDataType.COMPLEX.value())) {
//							List<IFieldTreeObject> fieldChildren = findObj.getChildren();
//							for(IFieldTreeObject simpleField: fieldChildren) {
//									item.remove();
//							}
//						}
//					}
//				}
//			}
//			}
//		
		//TreeItem matchedItem = new TreeItem(titleConstants.matched());
		
		//TreeItem child = new TreeItem(treeO.getSimpleDisplayName());
		//item.addItem(child);
		//child.setUserObject(treeO);
		//TreeItem matched = new TreeItem
//		if(item.getChildCount() >0) {
//			//root
//			TreeItem assetItem = item.getChild(0);
//			matchedItem.addItem(addAssetTreeItems(assetItem));
//			
//			}
//			
//		tree.addItem(matchedItem);
	//	IFieldTreeObject treeObj = (IFieldTreeObject) item.getUserObject();
	//	if(item)
		
	}

	private void setInvisible(TreeItem childItem) {
		for(int i = 0; i<childItem.getChildCount(); i++ ) {
			TreeItem item = childItem.getChild(i);
			item.setVisible(false);
		}
		
	}

	private void addNonMatchedItemsToTrees(List<TreeItem> nonMatchedTreeItem) {
		for (TreeItem item : nonMatchedTreeItem) {
			IFieldTreeObject treeObj = (IFieldTreeObject) item.getUserObject();
			if (treeObj instanceof AssetTreeObject) {
				// only assets
				tree.addItem(addAssetTreeItems(item));

			}else if (treeObj instanceof LicenseTreeObject) {
				tree.addItem(addLicenseRootOnly(item));
			} else {// add all other list items
				tree.addItem(item);
			}
			
		}
		for (TreeItem item : nonMatchedTreeItem) {
			IFieldTreeObject treeObj = (IFieldTreeObject) item.getUserObject();
			if (treeObj instanceof AssetTreeObject) {
				// only assets
				wholeTree.addItem(item);

			}
			else {
				wholeTree.addItem(addAssetTreeItems(item));
			}
		}
		
	}

	@Override
	public void onSelection(SelectionEvent<TreeItem> event) {
		TreeItem item = event.getSelectedItem();
		IFieldTreeObject treeObj = (IFieldTreeObject) item.getUserObject();

		// Matched is NULL plus Package, and maybe other stuff, don't support
		// actions
		if (!isInvalidFieldSelection(treeObj)) {
			selectedItem = item;
			selectedObject = (IFieldTreeObject) item.getUserObject();
			if(matchedTree(item)) {
				setFieldTree(item, null);
			}
			else {//field
				if(treeObj instanceof LicenseTreeObject) {
					TreeItem lItem = findLicenseRoot(tree);
					lItem.setSelected(true);
				}
			}
			selectedItem.setSelected(true);
			SelectionEvent.fire(this, (IFieldTreeObject) (IFieldTreeObject) item.getUserObject());
		}
		else if(matchedSpecialCase(treeObj)) {
			setFieldTree(item, null);
			item.setSelected(false);
		}
//		else if(treeObj instanceof MatchedItemTreeObj) {
//			//only for complex fields set fieldTree
//			//setFieldTree(item, null);
//			item.setSelected(true);
//			SelectionEvent.fire(this, (IFieldTreeObject) (IFieldTreeObject) item.getUserObject());
//		}
		else if (treeObj instanceof LicenseTreeObject && matchedTree(item)) {
			setFieldTree(item, null);
			item.setSelected(false);
			
		}
		else {
			
			item.setSelected(false);
			TreeItem lItem = findLicenseRoot(tree);
			lItem.setSelected(false);
		}
		
		
	}

	private boolean matchedSpecialCase(IFieldTreeObject treeObj) {
		if(treeObj instanceof AssetTreeObject) {
			if(treeObj.getAssetType().equalsIgnoreCase("PACKAGE") && treeObj.getField().isEmpty() ||
					(treeObj.getAssetType().equalsIgnoreCase("SERIES") && treeObj.getField().isEmpty())) {
				return true;
			}
		}
		else if(treeObj instanceof MatchedItemTreeObj) {
			
			if(((MatchedItemTreeObj) treeObj).getUserObject().getAssetType().equalsIgnoreCase("PACKAGE") && ((MatchedItemTreeObj) treeObj).getUserObject().getField().isEmpty() ||
					(((MatchedItemTreeObj) treeObj).getUserObject().getAssetType().equalsIgnoreCase("SERIES") && ((MatchedItemTreeObj) treeObj).getUserObject().getField().isEmpty())) {
				return true;
			}
		}
		return false;
	}

	@Override
	public HandlerRegistration addSelectionHandler(
			SelectionHandler<IFieldTreeObject> handler) {
		return addHandler(handler, SelectionEvent.getType());
	}
	
	protected abstract CriteriaType getCriteriaType();

	protected abstract UiCriteriaMode getCriteriaMode();
	
	protected class MatchedItemIterator {
		Iterator<IFieldTreeObject> variables;
		
		public MatchedItemIterator(Collection<IFieldTreeObject> variables) {
			this.variables = variables.iterator();
		}

		public boolean hasNext() {
			return variables.hasNext();
		}

		public MatchedItemTreeObj next() {
			IFieldTreeObject item = variables.next();
			if(item instanceof AssetTreeObject)
				item = ((AssetTreeObject) item).cloneWithoutChildAssetFields();
			return new MatchedItemTreeObj(item, item);
		}
	}
	
	private class TreeSearchHandler implements SelectionHandler<TreeItem> {

		@Override
		public void onSelection(SelectionEvent<TreeItem> event) {
			TreeItem item = event.getSelectedItem();
			IFieldTreeObject fieldTree = (IFieldTreeObject) item.getUserObject();
			// Matched is NULL plus Package, and maybe other stuff, don't support
			// actions
			// Matched is NULL plus Package, and maybe other stuff, don't support
			// actions
			if (isInvalidFieldSelection(fieldTree)) {
				item.setSelected(false);
				//if(selectedItem != null)
				//	selectedItem.setSelected(true);
				return;
			}
			
			setProperSelectedItem(item);
			srchBox.setFocus();
		}
	}
	
	private class ActionItemSelectableHandler implements ItemSelectableHandler {

		@Override
		public boolean isSelectable(TreeItem item) {
			Object usrObj = item.getUserObject();
			if(usrObj == null)
				return false;
			return !isInvalidFieldSelection((IFieldTreeObject) usrObj);
			
		}
		
	}
	private void addButtons() {
		// okButton.addStyleName("ebBtn ebBtn_color_blue margin-right10");
		// cancelButton.addStyleName("ebBtn margin-right10");
		bPanel.add(okButton);
		bPanel.add(cancelButton);
		okButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				
				hide(false);
			}
		});
		cancelButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				setSelectedItem(treeObject);
				hide(true);
			}

		});

	}
	protected void setSelectedItem(IFieldTreeObject treeObj) {
		TreeItem item = null;
		if (treeObj != null) {
			String assType = treeObj.getAssetType();
			String xpath = treeObj.getField();
			item = findItem(assType, xpath, wholeTree);
				if (item != null) {
					setProperSelectedItem(item);
				} else {
					// it is in the left tree
					item = findItem(assType, xpath, tree);
					tree.setSelectedItem(item, false);
					tree.ensureSelectedItemVisible();
					assetScrollPanel.ensureVisible(item);
				}
			}
		this.selectedObject = treeObj;
		this.selectedItem = item;
	}

	private Widget getControlWidget() {
		return srchBox;
	}
	private void addCloseHandler() {
		this.addCloseHandler(new CloseHandler<PopupPanel>() {
	      
	        public void onClose(CloseEvent<PopupPanel> event) { 
	        	
	        	if(event.isAutoClosed()) {
	        		setSelectedItem(treeObject);
	        	}
	        }
	    });
		
	}
	private TreeItem addAssetTreeItems(TreeItem rootItem) {
		IFieldTreeObject treeObj = (IFieldTreeObject) rootItem.getUserObject();
		TreeItem item = new TreeItem(treeObj.getSimpleDisplayName());
		item.setUserObject(treeObj);
		if (rootItem.getChildCount() > 0) {
			if (treeObj.getChildren() != null & !treeObj.getChildren().isEmpty()) {
				addTreeChildren(treeObj, item);
			}
		}
		return item;
	}
	private void addTreeChildren(IFieldTreeObject treeObj, TreeItem item) {
		// TODO Auto-generated method stub
		List<IFieldTreeObject> treeObjList = treeObj.getChildren();
		for (IFieldTreeObject treeO : treeObjList) {

			if (treeO instanceof AssetTreeObject || treeO instanceof LicenseTreeObject) {
				TreeItem child = new TreeItem(treeO.getSimpleDisplayName());
				item.addItem(child);
				child.setUserObject(treeO);
				if (treeO.getChildren() != null & !treeO.getChildren().isEmpty()) {
					addTreeChildren(treeO, child);
				}
			}

		}
	}
	private TreeItem addLicenseRootOnly(TreeItem rootItem) {
		IFieldTreeObject treeObj = (IFieldTreeObject) rootItem.getUserObject();
		TreeItem item = new TreeItem(treeObj.getSimpleDisplayName());
		item.setUserObject(treeObj);
		
		return item;
	}
	private void setFieldTree(TreeItem item, TreeItem selectedItem) {
		fieldTree = new Tree();
		fieldTree.addSelectionHandler(this);
		List<TreeItem> fieldRootItemList = new ArrayList<TreeItem>();
		IFieldTreeObject assetObj = (IFieldTreeObject) item.getUserObject();
		if (assetObj instanceof LicenseTreeObject) {
			// special case
			fieldRootItemList = findLicenseObjectChildren(assetObj.getDataType(), assetObj.getSimpleDisplayName());
		} else if (assetObj instanceof MatchedItemTreeObj) {
			fieldRootItemList = findMatchedItemChildren(assetObj);
		}else {
			String fAssetType = assetObj.getAssetType();
			String fXPath = assetObj.getField();
			fieldRootItemList = findChildren(fAssetType, fXPath);
		}

		for (TreeItem treeItem : fieldRootItemList) {
			IFieldTreeObject treeObj = (IFieldTreeObject) treeItem.getUserObject();
			TreeItem item2 = new TreeItem(treeObj.getSimpleDisplayName());
			item2.setUserObject(treeObj);
			fieldTree.addItem(item2);
			if (treeObj.getChildren() != null & !treeObj.getChildren().isEmpty()) {
				addFieldTreeFieldChildren(treeObj, item2);
			}

		}
		if (selectedItem != null) {
			IFieldTreeObject selectedObj = (IFieldTreeObject) selectedItem.getUserObject();
			TreeItem foundSelectedItem = null;
	
			foundSelectedItem = findItem(selectedObj.getAssetType(), selectedObj.getField(), fieldTree);
		
			if (foundSelectedItem != null) {
				fieldScrollPanel.setWidget(fieldTree);
				fieldTree.setSelectedItem(foundSelectedItem, false);
				fieldTree.ensureSelectedItemVisible();
				fieldScrollPanel.ensureVisible(foundSelectedItem);

			}
		} else {
			fieldScrollPanel.setWidget(fieldTree);
		}

		expandBtn.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				expandAll(fieldTree);

			}
		});
		collapseBtn.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				collapseAll(fieldTree);

			}
		});

	}

	
	protected void collapseAll(Tree tree) {
		for (int i = 0; i < tree.getItemCount(); i++) {
			TreeItem item = tree.getItem(i);
			if (item.getState() && !collapseHelper(item))
				item.setState(false, false);
		}
	}
	private boolean collapseHelper(TreeItem parent) {
		boolean result = false;
		for (int i = 0; i < parent.getChildCount(); i++) {
			TreeItem item = parent.getChild(i);
			boolean childResult = collapseHelper(item);
			if (item.getState() && !childResult) {
				item.setState(false, false);
			} else if (childResult || item.isSelected()) {
				result = true;
			}

		}
		return result;
	}
	protected void expandAll(Tree tree) {
		for (int i = 0; i < tree.getItemCount(); i++) {
			TreeItem item = tree.getItem(i);
			if (!item.getState() && !expandHelper(item))
				item.setState(true, false);
		}

	}
	private boolean expandHelper(TreeItem parent) {
		boolean result = false;
		for (int i = 0; i < parent.getChildCount(); i++) {
			TreeItem item = parent.getChild(i);
			boolean childResult = expandHelper(item);
			if (!item.getState() && !childResult) {
				item.setState(true, false);
			} else if (childResult || item.isSelected()) {
				result = true;
			}

		}
		return result;
	}
	private List<TreeItem> findChildren(String fAssetType, String fXPath) {
		List<TreeItem> itemList = new ArrayList<TreeItem>();
		TreeItem rootItem = null;
		Iterator<TreeItem> iterator = this.wholeTree.treeItemIterator();
		while (iterator.hasNext()) {
			TreeItem item = iterator.next();
			IFieldTreeObject findObj = (IFieldTreeObject) item.getUserObject();
			if(findObj instanceof AssetTreeObject) {
				if(findObj != null) {
					String assetType = findObj.getAssetType();
					String xpath = findObj.getField();
					if (assetType.equals(fAssetType) && xpath.equals(fXPath)) {
						rootItem = item;
						break;
					}
				}
			}
		}
		if (rootItem != null && rootItem.getChildCount() > 0) {
			for (int i = 0; i < rootItem.getChildCount(); i++) {
				TreeItem child = (rootItem.getChild(i));
				IFieldTreeObject findObj = (IFieldTreeObject) child.getUserObject();
				if (!(findObj instanceof AssetTreeObject)) {
					itemList.add(child);
				}
			}
		}
		return itemList;
	}
	
	private List<TreeItem> findMatchedItemChildren(IFieldTreeObject assetObj) {
		List<TreeItem> itemList = new ArrayList<TreeItem>();
		TreeItem rootItem = null;
		Iterator<TreeItem> iterator = this.wholeTree.treeItemIterator();
		while (iterator.hasNext()) {
			TreeItem item = iterator.next();
			IFieldTreeObject findObj = (IFieldTreeObject) item.getUserObject();
			if(findObj instanceof MatchedItemTreeObj) {
				IFieldTreeObject assetO = ((MatchedItemTreeObj) findObj).getUserObject();
				String assetType = assetO.getAssetType();
				String xpath = assetO.getField();
				if (assetType.equals(((MatchedItemTreeObj) assetObj).getUserObject().getAssetType()) && xpath.equals(((MatchedItemTreeObj) assetObj).getUserObject().getField())) {
					rootItem = item;
					break;
				}
			}
		}
		if (rootItem != null && rootItem.getChildCount() > 0) {
			for (int i = 0; i < rootItem.getChildCount(); i++) {
				TreeItem child = (rootItem.getChild(i));
				IFieldTreeObject findObj = (IFieldTreeObject) child.getUserObject();
				if (!(findObj instanceof AssetTreeObject)) {
					itemList.add(child);
				}
			}
		}
		return itemList;
	}

	private List<TreeItem> findLicenseObjectChildren(UIDataType rootDataType, String rootSimpleDisplayName) {
		List<TreeItem> itemList = new ArrayList<TreeItem>();
		TreeItem rootItem = null;
		Iterator<TreeItem> iterator = this.wholeTree.treeItemIterator();
		while (iterator.hasNext()) {
			TreeItem item = iterator.next();
			IFieldTreeObject findObj = (IFieldTreeObject) item.getUserObject();
			if(findObj != null) {
				UIDataType dataType = findObj.getDataType();
				String simpleDisplayName = findObj.getSimpleDisplayName();
				if (dataType.value().equalsIgnoreCase(rootDataType.value()) && simpleDisplayName.equalsIgnoreCase(rootSimpleDisplayName)) {
					rootItem = item;
					break;
				}
			}

		}
		// simply add all the children of the root
		if (rootItem != null) {
			if (rootItem.getChildCount() > 0) {

				for (int i = 0; i < rootItem.getChildCount(); i++) {
					TreeItem child = (rootItem.getChild(i));
					itemList.add(child);

				}
			}

		}
		return itemList;
	}
	private TreeItem findItem(String assetType, String xpath, Tree tree) {
		Iterator<TreeItem> iterator = tree.treeItemIterator();
		while (iterator.hasNext()) {
			TreeItem item = iterator.next();
			IFieldTreeObject findObj = (IFieldTreeObject) item.getUserObject();
			if(findObj != null) {
				String fAssetType = findObj.getAssetType();
				String fXPath = findObj.getField();
				if (assetType.equals(fAssetType) && xpath.equals(fXPath)) {
					return item;
				}
			}
		}
		return null;
	}
	private void addFieldTreeFieldChildren(IFieldTreeObject treeObj, TreeItem item) {
		// TODO Auto-generated method stub
		List<IFieldTreeObject> treeObjList = treeObj.getChildren();
		for (IFieldTreeObject treeO : treeObjList) {

			TreeItem child = new TreeItem(treeO.getSimpleDisplayName());

			item.addItem(child);
			if(treeObj instanceof MatchedItemTreeObj) {
				IMIFieldTreeObject mObj = new MatchedItemTreeObj(treeO, treeObj);
				child.setUserObject(mObj);
				if (treeO.getChildren() != null & !treeO.getChildren().isEmpty()) {
					addFieldTreeChildren(mObj, child);
				}
			}
			else {
				child.setUserObject(treeO);
				if (treeO.getChildren() != null & !treeO.getChildren().isEmpty()) {
					addFieldTreeChildren(treeO, child);
				}
			}
			
			
		}

	}
	private void addFieldTreeChildren(IFieldTreeObject treeObj, TreeItem item) {
		// TODO Auto-generated method stub
		
		List<IFieldTreeObject> treeObjList = treeObj.getChildren();
		for (IFieldTreeObject treeO : treeObjList) {
			TreeItem child = new TreeItem(treeO.getSimpleDisplayName());
			item.addItem(child);
			if(treeObj instanceof MatchedItemTreeObj) {
				IMIFieldTreeObject mObj = new MatchedItemTreeObj(treeO, treeObj);
				child.setUserObject(mObj);
				if (treeO.getChildren() != null & !treeO.getChildren().isEmpty()) {
					addFieldTreeChildren(mObj, child);
				}

			}
			else {
				child.setUserObject(treeO);
				if (treeO.getChildren() != null & !treeO.getChildren().isEmpty()) {
					addFieldTreeChildren(treeO, child);
				}

			}
			
		}
	}
	private boolean matchedFieldTree(TreeItem item) {

		IFieldTreeObject findObj = (IFieldTreeObject) item.getUserObject();
		String fAssetType = findObj.getAssetType();
		String fXPath = findObj.getField();
		TreeItem foundItem = findItem(fAssetType, fXPath, wholeTree);
		if (foundItem != null) {
			return true;
		}
		return false;

	}
	private boolean matchedTree(TreeItem item) {
		IFieldTreeObject findObj = (IFieldTreeObject) item.getUserObject();
		String fAssetType = findObj.getAssetType();
		String fXPath = findObj.getField();
		TreeItem foundItem = findItem(fAssetType, fXPath, tree);
		if (foundItem != null) {
			return true;
		}
		return false;
	}
	public void setProperSelectedItem(TreeItem item) {
		if (matchedLicense(item)) {

			TreeItem licenseRoot = findLicenseRoot(tree);
			tree.setSelectedItem(licenseRoot, false);
			tree.ensureSelectedItemVisible();
			setFieldTree(licenseRoot, item);
			SelectionEvent.fire(this, (IFieldTreeObject) (IFieldTreeObject) item.getUserObject());
			assetScrollPanel.ensureVisible(licenseRoot);
		
		}else
		if (matchedPMM(item)) {
			IFieldTreeObject assetObj = (IFieldTreeObject) item.getUserObject();
			TreeItem assetItem = findPMMItem(((PMMTitleTreeObject) assetObj).getField(), tree);
			tree.setSelectedItem(assetItem, false);
			tree.ensureSelectedItemVisible();
			setFieldTree(assetItem, null);
			SelectionEvent.fire(this, (IFieldTreeObject) (IFieldTreeObject) item.getUserObject());
			assetScrollPanel.ensureVisible(assetItem);
		}
		// find which tree it matches
		else if (matchedTree(item)) {

			IFieldTreeObject assetObj = (IFieldTreeObject) item.getUserObject();
			TreeItem assetItem = findItem(assetObj.getAssetType(), assetObj.getField(), tree);
			tree.setSelectedItem(assetItem, false);
			tree.ensureSelectedItemVisible();
			setFieldTree(assetItem, null);
			SelectionEvent.fire(this, (IFieldTreeObject) (IFieldTreeObject) item.getUserObject());
			assetScrollPanel.ensureVisible(assetItem);

		} else if (matchedFieldTree(item)) {
			// find asset of of matched field - highlight
			TreeItem assetItem = getAssetItem(item);
			tree.setSelectedItem(assetItem, false);
			tree.ensureSelectedItemVisible();

			// create fieldTree for that asset. highlight corresponding
			// item.
			setFieldTree(assetItem, item);
			SelectionEvent.fire(this, (IFieldTreeObject) (IFieldTreeObject) item.getUserObject());

		}

	}
	private boolean matchedLicense(TreeItem item) {
		IFieldTreeObject findObj = (IFieldTreeObject) item.getUserObject();
		if (findObj instanceof LicenseTreeObject) {
			return true;
		}
		return false;
	}
	public TreeItem findLicenseRoot(Tree tree) {
		Iterator<TreeItem> iterator = tree.treeItemIterator();
		while (iterator.hasNext()) {
			TreeItem item = iterator.next();

			IFieldTreeObject findObj = (IFieldTreeObject) item.getUserObject();
			if (findObj instanceof LicenseTreeObject) {

				return item;

			}

		}
		return null;
	}
	private boolean matchedPMM(TreeItem item) {
		IFieldTreeObject findObj = (IFieldTreeObject) item.getUserObject();
		if (findObj instanceof PMMTitleTreeObject) {
			return true;
		}
		return false;
	}
	private TreeItem getAssetItem(TreeItem fieldItem) {
		IFieldTreeObject fieldObj = (IFieldTreeObject) fieldItem.getUserObject();
		String assetType = fieldObj.getAssetType();
		// has to be asset object , not file
		IFieldTreeObject assetObj = getParentAsset(assetType);
		TreeItem assetItem = findItem(assetObj.getAssetType(), assetObj.getField(), tree);

		return assetItem;
	}
	private IFieldTreeObject getParentAsset(String assetType) {
		// if assetType is file, find the parent asset;
		if (assetType.toUpperCase().endsWith("/FILE")) {
			assetType = assetType.substring(0, (assetType.indexOf("/FILE")));
		}
		if (tree != null) {
			Iterator<TreeItem> iterator = tree.treeItemIterator();
			while (iterator.hasNext()) {
				TreeItem item = iterator.next();
				IFieldTreeObject findObj = (IFieldTreeObject) item.getUserObject();
				if(findObj != null) {
					if (assetType.equals(findObj.getAssetType())) {
						return findObj;
					}
				}
			}
		}
		return null;
	}
	private TreeItem findPMMItem(String path, Tree tree) {
		Iterator<TreeItem> iterator = tree.treeItemIterator();
		while (iterator.hasNext()) {
			TreeItem item = iterator.next();

			IFieldTreeObject findObj = (IFieldTreeObject) item.getUserObject();
			if (findObj instanceof PMMTitleTreeObject) {
				if (findObj.getField().equalsIgnoreCase(path)) {
					return item;
				}
			}

		}
		return null;
	}
}
