package com.tandbergtv.cms.rules.ui.client.normalization;

import java.util.Collection;
import java.util.List;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.TreeItem;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.TypedTreeCreator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.AssetTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.MatchedItemTreeObj;

public class ActionFieldTypeSpecificFieldSelector extends ActionFieldSelector {

	private String fieldType;

	public ActionFieldTypeSpecificFieldSelector(SelectionHandler<IFieldTreeObject> selectHandler,String fieldType, IMatchedItemProvider matchedItemProvider) {
		super(matchedItemProvider);
		this.fieldType = fieldType;
		addSelectionHandler(selectHandler);
	}

	@Override
	public void onClick(ClickEvent event) {
		onClickHelper(event, getNonMatchedTree(), false);
	}

	private List<TreeItem> getNonMatchedTree() {
		return TypedTreeCreator.getTreeItems(getCriteriaType(), getCriteriaMode(), fieldType);
	}

	@Override
	protected boolean isInvalidFieldSelection(IFieldTreeObject fieldTree) {
		return super.isInvalidFieldSelection(fieldTree)
				|| fieldTree.getComplexType() == null
				|| !fieldType.equals(fieldTree.getComplexType());
	}

	@Override
	protected CriteriaType getCriteriaType() {
		return CriteriaType.ACTION_RHS;
	}

	@Override
	protected UiCriteriaMode getCriteriaMode() {
		return UiCriteriaMode.EPISODE;
	}
	
	protected TreeItem getMatchedItems() {
		TreeItem matchedItem = new TreeItem(titleConstants.matched());
		MatchedItemIterator iterator = getMatchedItemTreeObj();
		while(iterator.hasNext()) {
			TreeItem item = TypedTreeCreator.convertToTreeItem(iterator.next(), getCriteriaType(), getCriteriaMode(), fieldType);
			if(item != null)
				matchedItem.addItem(item);
		}
		return matchedItem;
	}
	
	protected MatchedItemIterator getMatchedItemTreeObj() {
		return new FieldTypeMatchedItemIterator(matchedItemProvider.getVariables());
	}

	protected class FieldTypeMatchedItemIterator extends MatchedItemIterator {
		IFieldTreeObject next;
		
		public FieldTypeMatchedItemIterator(Collection<IFieldTreeObject> variables) {
			super(variables);
			setNext();
		}

		public boolean hasNext() {
			return next != null;
		}

		public MatchedItemTreeObj next() {
			IFieldTreeObject item = next;
			if(item instanceof AssetTreeObject)
				item = ((AssetTreeObject) item).cloneWithoutChildAssetFields();
			setNext();
			return new MatchedItemTreeObj(item, item);
		}
		
		private void setNext() {
			while(variables.hasNext()) {
				next = variables.next();
				if(next instanceof AssetTreeObject)
					return;
			}
			next = null;
		}
	}

	@Override
	protected TreeItem getTreeItem(IFieldTreeObject treeObj) {
		return TypedTreeCreator.convertToTreeItem(treeObj, getCriteriaType(),getCriteriaMode(), fieldType);
	}

}
