package com.tandbergtv.cms.rules.ui.client.normalization;

import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaListingPanel;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.UiRulesService;
import com.tandbergtv.cms.rules.ui.client.UiRulesServiceAsync;
import com.tandbergtv.cms.rules.ui.client.common.customrules.CustomRuleBox;
import com.tandbergtv.cms.rules.ui.client.common.events.RuleDeleteEvent;
import com.tandbergtv.cms.rules.ui.client.common.events.RuleDeleteHandler;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UiRule;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiCustomRule;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiCustomRuleParameter;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiCustomRuleTree;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class CustomNormalizationRule extends SimplePanel implements
		INormalizationRuleForm {
	private static UiCustomRuleTree customNormalizationRules = null;

	private VerticalPanel mainPanel = new VerticalPanel();
	private RulesConstants myConstants = (RulesConstants) GWT
			.create(RulesConstants.class);
	private VerticalContainer warningMessages = new VerticalContainer();
	private CustomRuleBox ruleBox;
	private TextBoxWidget indexWidget;
	private int index;

	private UiCustomRule rule;
	private static UiRulesServiceAsync rulesService = GWT
			.create(UiRulesService.class);

	public CustomNormalizationRule(int index, boolean reorderEnabled) {
		this(null, index, reorderEnabled);
	}

	public CustomNormalizationRule(UiCustomRule rule, int index,
			boolean reorderEnabled) {
		this.rule = rule;
		this.index = index;
		if (customNormalizationRules == null) {
			loadCustomValidationRules(reorderEnabled);
		} else {
			putTheUiTogether(reorderEnabled);
		}
	}

	private void loadCustomValidationRules(final boolean reorderEnabled) {
		try {
			rulesService.getCustomRules(Packages.NORMALIZATION.toString(),
					new NeptuneAsyncCallback<UiCustomRuleTree>() {

						@Override
						public void onNeptuneFailure(Throwable caught) {
							RulesComponent.getInstance().getCurrentTab()
									.setPanelInError(
											"Error loading custom rules");
						}

						@Override
						public void onNeptuneSuccess(UiCustomRuleTree result) {
							customNormalizationRules = result;
							putTheUiTogether(reorderEnabled);
						}

					});
		} catch (NeptuneException e) {
			RulesComponent.getInstance().getCurrentTab().setPanelInError(
					"Error loading custom rules");
		}
	}

	private void putTheUiTogether(boolean reorderEnabled) {
		setWidget(mainPanel);
		mainPanel.add(buildReorder());
		mainPanel.add(warningMessages);
		mainPanel.add(new LabelWidget(myConstants.validationActionLabel()));

		if (this.rule == null) {
			ruleBox = new CustomRuleBox(customNormalizationRules);
		} else {
			ruleBox = new CustomRuleBox(customNormalizationRules, rule);
		}
		mainPanel.add(ruleBox);

		// action selection row

		ButtonWidget delButton = deleteButton();

		mainPanel.add(delButton);

		// SET STYLES
		mainPanel
				.setStyleName(CriteriaListingPanel.CRITERIA_PANEL_CONTAINER_STYLE);
		setStyleName(CriteriaListingPanel.CRITERIA_PANEL_STYLE);
		enableReorder(reorderEnabled);
	}

	/**
	 * create a button to delete this rule
	 */
	private ButtonWidget deleteButton() {
		ButtonWidget button = new ButtonWidget(myConstants.delete(),
				new ClickHandler() {
					public void onClick(ClickEvent event) {
						fireEvent(new RuleDeleteEvent(CustomNormalizationRule.this));
					}
				});
		button.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		return button;
	}

	@Override
	public void enableReorder(boolean reorderEnabled) {
		// if the ruleEnabled is not true set read only
		indexWidget.setReadOnly(!reorderEnabled);
		String style = reorderEnabled ? "rule-order-editable"
				: "rule-order-noneditable";
		indexWidget.setStyleName(style);
	}

	@Override
	public int getIndex() {
		return index;
	}

	@Override
	public void setCurrentIndex(int index) {
		this.index = index;
		indexWidget.setText((index + 1) + "");
	}

	public HandlerRegistration addDeleteHandler(RuleDeleteHandler handler) {
		return addHandler(handler, RuleDeleteEvent.TYPE);
	}

	@Override
	public HandlerRegistration addReorderHandler(RuleReorderHandler handler) {
		return addHandler(handler, RuleReorderEvent.TYPE);
	}

	@Override
	public UiRule getRule() {
		String className = ruleBox.getClassName();
		List<UiCustomRuleParameter> params = ruleBox.getParameters();
		if(rule != null) {
			rule.setClassName(className);
			rule.setParameters(params);
			return rule;
		}
		return new UiCustomRule(className, params);
	}

	@Override
	public boolean validate() {
		return ruleBox.validate();
	}

	private Widget buildReorder() {
		SimpleContainer reorderContainer = new SimpleContainer();
		reorderContainer.setStyleName("rule-order-pos");

		// 4chars == MAX 999 rules
		indexWidget = new TextBoxWidget((index + 1) + "");
		indexWidget.setVisibleLength(4);
		indexWidget.setMaxLength(4);
		indexWidget.addChangeHandler(new ChangeHandler() {
			@Override
			public void onChange(ChangeEvent event) {
				String text = indexWidget.getText();
				int newIndex;
				try {
					newIndex = Integer.parseInt(text) - 1;
				} catch (NumberFormatException ex) {
					indexWidget.setText((index + 1) + "");
					return;
				}

				fireEvent(new RuleReorderEvent(CustomNormalizationRule.this,
						newIndex));
			}
		});

		reorderContainer.add(indexWidget);
		return reorderContainer;
	}
}
