package com.tandbergtv.cms.rules.ui.client.normalization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.tandbergtv.cms.portal.ui.title.client.NormalizationActionConstants;
import com.tandbergtv.cms.portal.ui.title.client.TitleMessages;
import com.tandbergtv.cms.portal.ui.title.client.criteria.TypedTreeCreator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.AssetTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UIDataType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.SingleValueWidget;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.common.RulesActionValueFactory;
import com.tandbergtv.cms.rules.ui.client.data.ActionParams;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.data.UIActionParam;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class NormalizationActionBox extends HorizontalContainer implements IFieldChangeChecker {
	private static final String ADD_ASSET_ACTION = "com.tandbergtv.marvin.actions.NormalizationActions.addAsset";

	public static final String COMPLEX = "complex";

	private RulesConstants myConstants = (RulesConstants) GWT
			.create(RulesConstants.class);
	private NormalizationActionConstants actionConstants = (NormalizationActionConstants) GWT.create(NormalizationActionConstants.class);

	/*
	 * this is a blank copy of the actions so that we don't have to go back to
	 * the server to retrieve the list for every action
	 */
	private static List<UIAction> actionsList;
	private ListBoxWidget<UIAction> actionsListBox;
	private SimplePanel fieldRhsContainer = new SimpleContainer();
	private SimplePanel value1Container = new SimpleContainer();
	private SimplePanel value2Container = new SimpleContainer();
	private SingleValueWidget value1;
	private SingleValueWidget value2;
	private Label value1Label;
	private Label value2Label;
	private NormalizationActionField fieldLhs;
	private NormalizationActionField fieldRhs;
	private NormalizationRule rule;
	private Button plusButton;
	private Button delButton;
	private IFieldTreeObject addAssetTracker;

	/**
	 * creates a blank ActionBox
	 * 
	 */
	public NormalizationActionBox(NormalizationRule rule) {
		this.rule = rule;
		putItTogether();
		addHandlers();
	}

	/**
	 * Creates an actionBox based on the uiaction provided.
	 * 
	 * @param uiaction
	 *            the uiaction you wish to have this actionbox modeled after.
	 */
	public NormalizationActionBox(UIAction uiaction, NormalizationRule rule) {
		this.rule = rule;
		putItTogether();

		String val1 = null;
		String val2 = null;
		String sectionType = "";
		String xpath = "";
		String rootxpath = "";
		
		String xpathRhs = null;
		String rootXpathRhs = null;
		String sectionTypeRhs = null;
		String forMatchedRhs = null;
		UIFieldType fieldType = UIFieldType.ASSET;
		String displayNameLhs = "";
		String displayNameRhs = "";
		String extendedDisplayNameLhs = "";
		String extendedDisplayNameRhs = "";
		UIDataType dataTypeLhs = null;
		UIDataType dataTypeRhs = null;
		String complexTypeRhs = null;
		String complexTypeLhs = null;

		// if it is for matched only than there will be no FORMATCHED flag but
		// is still for matched
		boolean forMatched = false;
		for(UIAction a : actionsList) {
			if(a.getAction().equals(uiaction.getAction())) {
				forMatched = a.isMatchOnly();
				break;
			}
		}

		if (uiaction.containsParam(ActionParams.VALUE)) {
			val1 = uiaction.getParam(ActionParams.VALUE).getValue();
		}

		if (uiaction.containsParam(ActionParams.VALUE2)) {
			val2 = uiaction.getParam(ActionParams.VALUE2).getValue();
		}

		if (uiaction.containsParam(ActionParams.SECTIONTYPE)) {
			sectionType = uiaction.getParam(ActionParams.SECTIONTYPE)
					.getValue();
		}

		if (uiaction.containsParam(ActionParams.XPATH)) {
			xpath = uiaction.getParam(ActionParams.XPATH).getValue();
			if(xpath == null)
				xpath = "";
		}

		if (uiaction.containsParam(ActionParams.ROOTXPATH)) {
			rootxpath = uiaction.getParam(ActionParams.ROOTXPATH).getValue();
		}

		if (uiaction.containsParam(ActionParams.FORMATCHED)) {
			forMatched = Boolean.valueOf(uiaction.getParam(ActionParams.FORMATCHED).getValue());
		}

		if (uiaction.containsParam(ActionParams.XPATHRHS)) {
			xpathRhs = uiaction.getParam(ActionParams.XPATHRHS).getValue();
		}

		if (uiaction.containsParam(ActionParams.SECTIONTYPERHS)) {
			sectionTypeRhs = uiaction.getParam(ActionParams.SECTIONTYPERHS).getValue();
		}

		if (uiaction.containsParam(ActionParams.ROOTXPATHRHS)) {
			rootXpathRhs = uiaction.getParam(ActionParams.ROOTXPATHRHS).getValue();
		}
		
		if (uiaction.containsParam(ActionParams.FORMATCHEDRHS)) {
			forMatchedRhs = uiaction.getParam(ActionParams.FORMATCHEDRHS).getValue();
		}
		if (uiaction.containsParam(ActionParams.FIELDTYPE)) {
			fieldType = UIFieldType.valueOf(uiaction.getParam(ActionParams.FIELDTYPE).getValue());
		}
		if (uiaction.containsParam(ActionParams.DATATYPELHS)) {
			dataTypeLhs = UIDataType.fromValue(uiaction.getParam(ActionParams.DATATYPELHS).getValue());
		}
		if (uiaction.containsParam(ActionParams.DATATYPERHS)) {
			dataTypeRhs = UIDataType.fromValue(uiaction.getParam(ActionParams.DATATYPERHS).getValue());
		}
		if (uiaction.containsParam(ActionParams.DISPLAYNAMELHS)) {
			displayNameLhs = uiaction.getParam(ActionParams.DISPLAYNAMELHS).getValue();
		}
		if (uiaction.containsParam(ActionParams.DISPLAYNAMERHS)) {
			displayNameRhs = uiaction.getParam(ActionParams.DISPLAYNAMERHS).getValue();
		}
		if (uiaction.containsParam(ActionParams.EXTENDEDDISPLAYNAMELHS)) {
			extendedDisplayNameLhs = uiaction.getParam(ActionParams.EXTENDEDDISPLAYNAMELHS).getValue();
		}
		if (uiaction.containsParam(ActionParams.EXTENDEDDISPLAYNAMERHS)) {
			extendedDisplayNameRhs = uiaction.getParam(ActionParams.EXTENDEDDISPLAYNAMERHS).getValue();
		}
		if (uiaction.containsParam(ActionParams.COMPLEXTYPELHS)) {
			complexTypeLhs = uiaction.getParam(ActionParams.COMPLEXTYPELHS).getValue();
		}
		if (uiaction.containsParam(ActionParams.COMPLEXTYPERHS)) {
			complexTypeRhs = uiaction.getParam(ActionParams.COMPLEXTYPERHS).getValue();
		}
		
		// Set the field
		
		if (displayNameLhs.isEmpty()) {
			showFieldNotFound(sectionType, xpath);
			return;
		} else {
			String rootSectionType = sectionType;
			if(forMatched && xpath.isEmpty() && uiaction.getAction().contains("addAsset")) {
				int lastSlash = sectionType.lastIndexOf("/");
				rootSectionType = sectionType.substring(0, lastSlash);
			}
			fieldLhs.setFieldItem(sectionType, xpath, rootSectionType, rootxpath, forMatched, fieldType, displayNameLhs, dataTypeLhs, complexTypeLhs, extendedDisplayNameLhs);
		}
		// actionsListBox.setSelectedItem(actionLookup.get(uiaction.getAction()));
		actionsListBox.setSelectedItem(uiaction);
		// reset the field with the value
		filterActions();

		//set value1 if necessary 
		if (this.value1 != null && val1 != null) {
			this.value1.setValue(val1);
			if(!val1.isEmpty() && this.value1.getValue().isEmpty()) {
				TitleMessages myMessages = (TitleMessages) GWT.create(TitleMessages.class);
				rule.addWarningMessage(myMessages.invalidValue(val1, sectionType+" "+xpath));
			}
		}

		//set value2 if necessary
		if (this.value2 != null && val2 != null) {
			this.value2.setValue(val2);
			if(!val2.isEmpty() && this.value2.getValue().isEmpty()) {
				TitleMessages myMessages = (TitleMessages) GWT.create(TitleMessages.class);
				rule.addWarningMessage(myMessages.invalidValue(val2, sectionTypeRhs+" "+xpathRhs));
			}
		}

		//set fieldRhs if necessary
		if(uiaction.containsParam(ActionParams.XPATHRHS) && xpathRhs != null) {
			boolean isMatched = Boolean.parseBoolean(forMatchedRhs);
			if(displayNameRhs.isEmpty()) {
				showFieldNotFound(sectionTypeRhs, xpathRhs);
			} else {
				fieldRhs.setFieldItem(sectionTypeRhs,xpathRhs, sectionTypeRhs, rootXpathRhs, isMatched, UIFieldType.ASSET, displayNameRhs, dataTypeRhs, complexTypeRhs, extendedDisplayNameRhs);
			}
		}
		
		if (uiaction.getAction().startsWith(ADD_ASSET_ACTION)) {
			IFieldTreeObject item = fieldLhs.getSelectedField();
			AssetTreeObject ato = new AssetTreeObject(item.getSimpleDisplayName(), "NEW/"+item.getAssetType(), item.getComplexType(), item.getExtendedDisplayName());
			rule.notifyChange(ato);
			addAssetTracker = ato;
		} 
		addHandlers();
	}
	
	private void showFieldNotFound(String assetType, String xpath) {
		TitleMessages myMessages = (TitleMessages) GWT
				.create(TitleMessages.class);
		rule.addWarningMessage(myMessages.invalidField(assetType + " "
						+ xpath));
	}

	/**
	 * creates the plus used to add a new action
	 */
	private void createPlus() {
		plusButton = new ButtonWidget("+");
		plusButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				rule.addActionAfter(NormalizationActionBox.this);
			}
		});
		plusButton.addStyleDependentName(StyleNames.ACTION_BUTTON_STYLE);
		add(plusButton);
	}

	/**
	 * creates the delete button used to delete this action
	 */
	private void createDelete() {
		delButton = new ButtonWidget("-");
		delButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				if(canChangeField()) {
					rule.removeAction(NormalizationActionBox.this);
					 if(addAssetTracker != null)
						rule.notifyRemoval(addAssetTracker);
				}
			}
		});
		delButton.addStyleDependentName(StyleNames.ACTION_BUTTON_STYLE);
		add(delButton);
	}

	public boolean validate() {
		boolean passes = true;

		// User must select a fieldisMatched
		if (fieldLhs.getSelectedField() == null) {
			this.fieldLhs.setErrorState();
			this.rule.addWarningMessage(myConstants
					.ruleValidationBlankFieldAction());
			passes = false;
		}
		// TODO remove this hack
		/*
		 * This is probably one of the worse hacks in this software
		 * product/solution. We need to refactor how the configuration for
		 * actions works. In the meantime I have to make the second value for
		 * normalization be not required for replace.
		 */
		boolean value1Passes = true;
		boolean value2Passes = true;

		//validate value 1
		if (actionsListBox.getSelectedItem().containsParam(
				ActionParams.VALUE))
			value1Passes = value1.validate();

		//validate value 2
		if (actionsListBox.getSelectedItem().getLabelKey().equals(
				"normalizationReplaceLabel"))
			value2Passes = value2.validate();
		else if (actionsListBox.getSelectedItem().containsParam(
				ActionParams.VALUE2))
			value2Passes = value2.validate();


		// User must have valid data in the value
		if (!value1Passes || !value2Passes) {
			passes = false;
			rule.addWarningMessage(myConstants.ruleValidationBlankAction());
		}

		//validate field RHS
		if (actionsListBox.getSelectedItem().containsParam(
				ActionParams.XPATHRHS) && fieldRhs.getSelectedField() == null) {
			this.fieldRhs.setErrorState();
			rule.addWarningMessage(myConstants
					.ruleValidationBlankFieldAction());
			passes = false;
		}

		return passes;
	}

	private void putItTogether() {
		fieldLhs = new NormalizationActionField(rule, rule.getActionLhsCriteriaType());
		
		actionsListBox = new ListBoxWidget<UIAction>();
		actionsListBox.addStyleName("small-txt");
		actionsListBox.addStyleName("norm-actions");
		for(UIAction action : actionsList) {
			String itemKey = actionConstants.getString(action.getLabelKey());
			actionsListBox.addItem(itemKey, action);
		}

		/*
		 * value.setVisibleLength(12); value2.setVisibleLength(12);
		 */

		value1Label = new LabelWidget();
		value1Label.setHorizontalAlignment(ALIGN_RIGHT);
		value2Label = new LabelWidget();
		value2Label.setHorizontalAlignment(ALIGN_RIGHT);

		add(fieldLhs);
		add(actionsListBox);
		add(fieldRhsContainer);
		add(value1Label);
		add(value1Container);
		add(value2Label);
		add(value2Container);

		createPlus();
		createDelete();
	}
	
	private void addHandlers() {
		fieldLhs.setFieldChangeChecker(this);
		fieldLhs.addSelectionHandler(new SelectionHandler<IFieldTreeObject>() {
			@Override
			public void onSelection(SelectionEvent<IFieldTreeObject> event) {
				filterActions();
				handleAddAsset();
			}
			
		});
		actionsListBox.addChangeHandler(new ChangeHandler() {

			@Override
			public void onChange(ChangeEvent event) {
				if(actionsListBox.getSelectedItem().getAction().startsWith(ADD_ASSET_ACTION) || canChangeField()) {
					resetLabels();
					resetValue();
					handleAddAsset();
				} else {
					for(int i = 0; i < actionsListBox.getItemCount(); i++)
						if(actionsListBox.getItem(i).getAction().startsWith(ADD_ASSET_ACTION)) {
							actionsListBox.setSelectedIndex(i);
							break;
						}
				}
			}

		});
	}
	
	private void handleAddAsset() {
		UIAction selectedItem = actionsListBox.getSelectedItem();
		IFieldTreeObject newItem = fieldLhs.getSelectedField();
		AssetTreeObject ato = new AssetTreeObject(newItem.getSimpleDisplayName(), "NEW/"+newItem.getAssetType(), newItem.getComplexType(), newItem.getExtendedDisplayName());
		ato.setChildren(newItem.getChildren());
		if (selectedItem != null
				&& selectedItem.getAction().startsWith(
						ADD_ASSET_ACTION)) {
			rule.notifyChange(ato);
			if(addAssetTracker != null && !addAssetTracker.equals(selectedItem))
				rule.notifyRemoval(addAssetTracker);
			addAssetTracker = ato;
		} else if(addAssetTracker != null) {
			rule.notifyRemoval(addAssetTracker);
			addAssetTracker = null;
		}
	}

	private void resetLabels() {
		UIAction action = actionsListBox.getSelectedItem();
		UIActionParam value1Param = action.getParam(ActionParams.VALUE);
		UIActionParam value2Param = action.getParam(ActionParams.VALUE2);

		if (value1Param != null && !value1Param.getLabelName().equals(""))
			value1Label.setText(myConstants.getString(value1Param
					.getLabelName()));
		else
			value1Label.setText("");
		if (value2Param != null && !value2Param.getLabelName().equals(""))
			value2Label.setText(myConstants.getString(value2Param
					.getLabelName()));
		else
			value2Label.setText("");
	}

	private void resetValue() {
		IFieldTreeObject treeObject = fieldLhs.getSelectedField();
		UIAction action = actionsListBox.getSelectedItem();
		//take care of value 1
		if (action.containsParam(ActionParams.VALUE)) {
			String strValue1 = value1 == null ? "" : value1.getValue();
			value1 = RulesActionValueFactory.getRHSWidget(treeObject, action, strValue1);
			value1Container.setWidget(value1);
		} else {
			value1Container.clear();
		}

		// take care of value 2
		if (action.containsParam(ActionParams.VALUE2)) {
			String strValue2 = value2 == null ? "" : value2.getValue();
			value2 = RulesActionValueFactory.getRHSWidget(treeObject, action,strValue2);
			value2Container.setWidget(value2);
		} else {
			value2Container.clear();
		}

		//take care of rhs field
		if (action.containsParam(ActionParams.XPATHRHS)) {
			UIDataType selectedType = treeObject == null ? UIDataType.STRING : treeObject.getDataType();
			UIDataType rhsDataType = action.getValueTypeMap().get(selectedType.getDataTypeName());
			if(fieldRhs != null && fieldRhs.getSelectedField() != null) {
				UIDataType currDataType = UIDataType.COMPLEX;
				if(fieldRhs.getSelector() instanceof ActionDataTypeSpecificFieldSelector)
					currDataType = ((ActionDataTypeSpecificFieldSelector)fieldRhs.getSelector()).getDataType();

				if(rhsDataType.equals(UIDataType.COMPLEX) || !currDataType.equals(rhsDataType)) {
					IFieldTreeObject field = fieldRhs.getSelectedField();
					fieldRhs = new NormalizationActionField(rhsDataType, treeObject.getComplexType(), rule);
					if (TypedTreeCreator.validDataType(currDataType, field
							.getDataType(), true))
						fieldRhs.setFieldItem(field);
				}
			} else {
				fieldRhs = new NormalizationActionField(rhsDataType, treeObject.getComplexType(), rule);
			}
			fieldRhsContainer.setWidget(fieldRhs);
		} else {
			fieldRhsContainer.clear();
		}
	}

	/*
	 * filters actions based on data type
	 */
	private void filterActions() {
		UIDataType selectedType = UIDataType.STRING;
		String selectedXpath = "";
		String selectedAssetType = "";
		UIFieldType fieldType = UIFieldType.ASSET;
		UIAction currItem = actionsListBox.getSelectedItem();
		boolean isMatchedRootNode = false; 
		boolean isMatched = false;

		IFieldTreeObject fieldLhsObj = fieldLhs.getSelectedField(); 
		if (fieldLhsObj != null) {
			selectedType = fieldLhsObj.getDataType();
			selectedXpath = fieldLhsObj.getField();
			selectedAssetType = fieldLhsObj.getAssetType();
			fieldType = fieldLhsObj.getFieldType();
			isMatched = fieldLhs.isMatchedItem();
			if(isMatched) {
				String field = fieldLhs.getSelectedField().getField();
				String assetParent = fieldLhs.getSelectedFieldParent().getAssetType();
				String asset = fieldLhs.getSelectedField().getAssetType();
				String fieldParent = fieldLhs.getSelectedFieldParent().getField();
				isMatchedRootNode = assetParent.equals(asset) && field.equals(fieldParent);
			}
		}
		String selectedTypeName = selectedType.value();
		actionsListBox.clear();

		boolean hasSelectedItem = false;

		// adds the actions to the action list box while trying to preserve the
		// currently selected item
		for (UIAction action : actionsList) {
			Map<String, UIDataType> map = action.getValueTypeMap();
			boolean containsKey = map.containsKey(selectedTypeName);
			boolean checkMatchedRootNodes = !(isMatchedRootNode && !action.getAllowMatchedRootNodes());
			if (containsKey && action.allowsField(fieldType, selectedAssetType, selectedXpath)
					&& (isMatched || !action.isMatchOnly()) && checkMatchedRootNodes) {
				String itemKey = actionConstants.getString(action.getLabelKey());
				actionsListBox.addItem(itemKey, action);
				if (currItem != null && currItem.equals(action))
					hasSelectedItem = true;
			}
		}

		// set selected item if we have one.
		if (hasSelectedItem) {
			actionsListBox.setSelectedItem(currItem);
		}

		resetValue();
		resetLabels();

	}

	/**
	 * Builds the UIAction object used when saving a RuleSet.
	 * 
	 * @return A UIAction that represents the contents of this
	 *         NormalizationActionBox.
	 */
	public UIAction getAction() {
		// get the Action from the action selection drop down
		UIAction result = actionsListBox.getSelectedItem().clone();

		IFieldTreeObject fieldObject = fieldLhs.getSelectedField();
		IFieldTreeObject currParent = fieldLhs.getSelectedFieldParent();

		// Go through all the parameters and set them.
		if (result.containsParam(ActionParams.VALUE)) {
			result.getParam(ActionParams.VALUE).setValue(value1.getValue());
		}

		if (result.containsParam(ActionParams.VALUE2)) {
			result.getParam(ActionParams.VALUE2).setValue(value2.getValue());
		}

		if (result.containsParam(ActionParams.SECTIONTYPE)) {
			result.getParam(ActionParams.SECTIONTYPE).setValue(fieldObject.getAssetType());
		}

		if (result.containsParam(ActionParams.XPATH)) {
			result.getParam(ActionParams.XPATH).setValue(fieldObject.getField());
		}

		if (result.containsParam(ActionParams.ROOTXPATH)) {
			result.getParam(ActionParams.ROOTXPATH).setValue(
					currParent == null ? null : currParent.getField());
		}

		if (result.containsParam(ActionParams.FORMATCHED)) {
			result.getParam(ActionParams.FORMATCHED).setValue(Boolean.toString(currParent != null));
		}

		if (result.containsParam(ActionParams.XPATHRHS)) {
			result.getParam(ActionParams.XPATHRHS).setValue(fieldRhs.getSelectedField().getField());
		}

		if (result.containsParam(ActionParams.SECTIONTYPERHS)) {
			result.getParam(ActionParams.SECTIONTYPERHS).setValue(fieldRhs.getSelectedField().getAssetType());
		}

		if (result.containsParam(ActionParams.ROOTXPATHRHS)) {
			IFieldTreeObject parent = fieldRhs.getSelectedFieldParent();
			result.getParam(ActionParams.ROOTXPATHRHS).setValue(
					parent == null ? null : parent.getField());
		}
		
		if (result.containsParam(ActionParams.FORMATCHEDRHS)) {
			Boolean isMatched = fieldRhs.isMatchedItem();
			result.getParam(ActionParams.FORMATCHEDRHS).setValue(isMatched.toString());
		}
		
		if (result.containsParam(ActionParams.FIELDTYPE)) {
			result.getParam(ActionParams.FIELDTYPE).setValue(
					fieldObject.getFieldType().toString());
		}
		return result;
	}

	/**
	 * It looks like we can remove the predicate row if we do not have a parent.
	 * Not exactly sure why tho
	 * 
	 * @param row
	 * @return
	 */
	public boolean canRemoveReferencesForField(IFieldTreeObject field) {
		IFieldTreeObject fieldObject = this.fieldLhs
				.getSelectedFieldParent();
		IFieldTreeObject fieldObjectRhs = null;
		
		if(actionsListBox.getSelectedItem().containsParam(ActionParams.XPATHRHS) && fieldRhs != null){
			fieldObjectRhs = fieldRhs.getSelectedFieldParent();
		}
		return (fieldObject == null || !fieldObject.equals(field))
				&& (fieldObjectRhs == null || !fieldObjectRhs.equals(field));
	}

	/**
	 * Sets the static action list.
	 * 
	 * @param actionsList
	 */
	public static void setActionsListCache(List<UIAction> cacheActionsList) {
		actionsList = new ArrayList<UIAction>();
		for (UIAction action : cacheActionsList) {
			actionsList.add(action);
		}
		Collections.sort(actionsList);
	}

	/**
	 * Returns true if the cached actions were loaded through
	 * setActionsListCache.
	 * 
	 * @return
	 */
	public static boolean cacheLoaded() {
		return actionsList != null;
	}

	public NormalizationRule getRule() {
		return this.rule;
	}

	@Override
	public boolean canChangeField() {
		String msg = myConstants.actionValidationRemoveActionReference();
		rule.removeWarningMessage(msg);
		if(addAssetTracker != null) {
			if(rule.actionHasReferencesForField(addAssetTracker)) {
				rule.addWarningMessage(msg);
				return false;
			}
		}
		return true;
	}
}
