package com.tandbergtv.cms.rules.ui.client.normalization;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.TextBox;
import com.tandbergtv.cms.portal.ui.title.client.TitleStyleNames;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTreeCreator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.MatchedItemTreeObj;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UIDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

public class NormalizationActionField extends SimpleContainer implements
		SelectionHandler<IFieldTreeObject>, HasSelectionHandlers<IFieldTreeObject> {

	private TextBox txtBox;
	private ActionFieldSelector selector;
	private IFieldChangeChecker changeChecker;

	public NormalizationActionField(IMatchedItemProvider matchedItemProvider, CriteriaType critType) {
		selector = new NormalizationActionFieldSelector(this, matchedItemProvider, critType);
		initializeTextBox();
	}
	
	public NormalizationActionField(UIDataType dataType, String complexType, IMatchedItemProvider matchedItemProvider) {
		if(dataType.equals(UIDataType.COMPLEX))
			selector = new ActionFieldTypeSpecificFieldSelector(this, complexType, matchedItemProvider);
		else
			selector = new ActionDataTypeSpecificFieldSelector(this, dataType, matchedItemProvider);
		initializeTextBox();
	}
	
	public void setFieldChangeChecker(IFieldChangeChecker changeChecker) {
		this.changeChecker = changeChecker;
	}
	
	private void initializeTextBox() {
		txtBox = new TextBoxWidget();
		txtBox.setReadOnly(true);
		txtBox.addStyleName("black-txt");
		txtBox.addStyleName("small-txt");
		txtBox.setVisibleLength(35);
		txtBox.addClickHandler(new FieldClickHandler());
		setWidget(txtBox);
	}

	@Override
	public void onSelection(SelectionEvent<IFieldTreeObject> event) {
		IFieldTreeObject fieldObject = event.getSelectedItem();
		txtBox.removeStyleName(TitleStyleNames.PINK_BOX_STYLE);
		txtBox.setValue(fieldObject.getFullDisplayName());
		txtBox.setTitle(fieldObject.getExtendedDisplayName());
	}

	@Override
	public HandlerRegistration addSelectionHandler(
			SelectionHandler<IFieldTreeObject> handler) {
		return selector.addSelectionHandler(handler);
	}

	public void setErrorState() {
		txtBox.addStyleName(TitleStyleNames.PINK_BOX_STYLE);
	}

	public IFieldTreeObject getSelectedFieldParent() {
		return selector.getSelectedFieldParent();
	}

	public IFieldTreeObject getSelectedField() {
		return selector.getSelectedField();
	}

	public boolean isMatchedItem() {
		return selector.isMatchedItem();
	}

	public void setFieldItem(String assetType, String xpath, String rootSectionType,
			String rootxpath, boolean forMatched, UIFieldType fieldType, String displayName, UIDataType dataType, String complexType, String extendedDisplayName) {
		UIDataType rootDataType = null;
		if(rootxpath != null && rootxpath.equals(xpath))
			rootDataType = dataType;
		IFieldTreeObject userObject = FieldTreeCreator.getFieldTreeObject(fieldType, assetType, xpath, displayName, dataType, complexType, extendedDisplayName);
		IFieldTreeObject selectedObject;
		if (forMatched) {
			IFieldTreeObject parent = FieldTreeCreator.getFieldTreeObject(fieldType, rootSectionType, rootxpath, displayName, rootDataType, complexType, extendedDisplayName);
			selectedObject = new MatchedItemTreeObj(userObject, parent);
		} else {
			selectedObject = userObject;
		}
		txtBox.setValue(selectedObject.getFullDisplayName());
		txtBox.setTitle(selectedObject.getExtendedDisplayName());
		selector.setFieldItem(selectedObject);
	}
	
	public ActionFieldSelector getSelector() {
		return selector;
	}

	public void setFieldItem(IFieldTreeObject field) {
		selector.setFieldItem(field);
	}
	
	private class FieldClickHandler implements ClickHandler {

		@Override
		public void onClick(ClickEvent event) {
			if(changeChecker == null || changeChecker.canChangeField())
				selector.onClick(event);
		}
		
	}

}
