package com.tandbergtv.cms.rules.ui.client.normalization;

import java.util.List;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.TreeItem;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.TreeCreator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;

public class NormalizationActionFieldSelector extends ActionFieldSelector {

	private static List<TreeItem> nonMatchedTreeItem;
	
	public static void clearCache() {
		ActionFieldSelector.clearCache();
		nonMatchedTreeItem = null;
	}

	private CriteriaType critType;

	public NormalizationActionFieldSelector(SelectionHandler<IFieldTreeObject> selectHandler, IMatchedItemProvider matchedItemProvider, CriteriaType critType) {
		super(matchedItemProvider);
		addSelectionHandler(selectHandler);
		this.critType = critType;
	}

	@Override
	public void onClick(ClickEvent event) {
		if (nonMatchedTreeItem == null || nonMatchedTreeItem.isEmpty()) {
			nonMatchedTreeItem = TreeCreator.getTreeItems(getCriteriaType(), getCriteriaMode());
		}
		onClickHelper(event, nonMatchedTreeItem, true);
	}

	@Override
	protected CriteriaType getCriteriaType() {
		return critType;
	}

	@Override
	protected UiCriteriaMode getCriteriaMode() {
		return UiCriteriaMode.EPISODE;
	}

	@Override
	protected TreeItem getTreeItem(IFieldTreeObject treeObj) {
		return TreeCreator.convertToTreeItem(treeObj, getCriteriaType(),getCriteriaMode());
	}

}
