package com.tandbergtv.cms.rules.ui.client.normalization;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.Validatable;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.UiRulesService;
import com.tandbergtv.cms.rules.ui.client.UiRulesServiceAsync;
import com.tandbergtv.cms.rules.ui.client.common.events.RuleDeleteEvent;
import com.tandbergtv.cms.rules.ui.client.common.events.RuleDeleteHandler;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UiRule;
import com.tandbergtv.cms.rules.ui.client.data.UiStandardRule;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiCustomRule;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * This class represents the panel witch is used to create normalization rules
 * within the NormalizationRuleSetPanel
 * 
 * @author dweiner
 * 
 */
public class NormalizationRulePanel extends VerticalPanel implements
		Validatable {
	private RulesConstants myConstants = (RulesConstants) GWT
			.create(RulesConstants.class);

	private VerticalPanel warningMessages = new VerticalPanel();
	private VerticalPanel rulesContainer = new VerticalPanel();
	private boolean reorderEnabled;
	private Button reorderButton;
	private static Boolean allowCustomRules;
	protected final UiRulesServiceAsync rulesService = GWT
			.create(UiRulesService.class);

	private boolean sourceIsMso;

	public NormalizationRulePanel(final List<UiRule> rules, boolean sourceIsMso) {
		super();
		if (allowCustomRules == null) {
			try {
				rulesService.customRulesExist(Packages.NORMALIZATION.toString(),
						new NeptuneAsyncCallback<Boolean>() {

							@Override
							public void onNeptuneFailure(Throwable caught) {
								allowCustomRules = false;
								buildUi(rules);
							}

							@Override
							public void onNeptuneSuccess(Boolean result) {
								allowCustomRules = result;
								buildUi(rules);
							}

						});
			} catch (NeptuneException e) {
				allowCustomRules = false;
				buildUi(rules);
			}
		} else {
			buildUi(rules);
		}
		this.sourceIsMso = sourceIsMso;
	}

	/**
	 * Returns the UI rules represnted by this panel.
	 * 
	 * @return the UI rules represnted by this panel.
	 */
	public List<UiRule> getRules() {
		List<UiRule> result = new ArrayList<UiRule>();
		for (Widget w : rulesContainer) {
			INormalizationRuleForm rule = (INormalizationRuleForm) w;
			UiRule newRule = rule.getRule();
			if (newRule != null)
				result.add(newRule);
		}
		return result;
	}

	private void buildUi(List<UiRule> uirules) {
		this.add(warningMessages);
		this.add(rulesContainer);
		this.add(buildButtons());

		for (UiRule rule : uirules) {
			if (rule instanceof UiStandardRule) {
				NormalizationRule widgRule = new NormalizationRule(
						(UiStandardRule) rule, rulesContainer.getWidgetCount(), reorderEnabled, sourceIsMso);
				widgRule.addDeleteHandler(buildRuleDelHander());
				widgRule.addReorderHandler(buildReorderHandler());
				rulesContainer.add(widgRule);
			} else if (rule instanceof UiCustomRule) {
				CustomNormalizationRule widgRule = new CustomNormalizationRule(
						(UiCustomRule) rule, rulesContainer.getWidgetCount(), reorderEnabled);
				widgRule.addDeleteHandler(buildRuleDelHander());
				widgRule.addReorderHandler(buildReorderHandler());
				rulesContainer.add(widgRule);
			}
		}
	}

	/**
	 * Builds the handler to remove a rule from the rule panel
	 * 
	 * @return
	 */
	private RuleDeleteHandler buildRuleDelHander() {
		return new RuleDeleteHandler() {

			@Override
			public void ruleDeleted(RuleDeleteEvent event) {
				INormalizationRuleForm rule = (INormalizationRuleForm) event
						.getRule();
				int ruleIndex = rule.getIndex();
				rulesContainer.remove((Widget) rule);
				if (ruleIndex < rulesContainer.getWidgetCount()) {
					for(int i = ruleIndex; i < rulesContainer.getWidgetCount(); i ++) {
						INormalizationRuleForm currRule = (INormalizationRuleForm) rulesContainer
								.getWidget(i);
						currRule.setCurrentIndex(i);
					}
				}
			}

		};
	}

	@Override
	public boolean validate() {
		boolean result = true;
		for (Widget w : rulesContainer) {
			INormalizationRuleForm rule = (INormalizationRuleForm) w;
			if (!rule.validate()) {
				result = false;
			}
		}
		return result;
	}

	private Widget buildButtons() {
		HorizontalPanel container = new HorizontalPanel();
		container.add(buildReorderButton());
		container.add(createButton(myConstants.createRuleButtonLabel()));
		if(allowCustomRules)
			container.add(addCustomButton());
		return container;
	}

	private Button buildReorderButton() {
		reorderEnabled = false;
		reorderButton = new Button(myConstants.enableReorder(),
				new ClickHandler() {
					public void onClick(ClickEvent event) {
						reorderEnabled = !reorderEnabled;
						String text = reorderEnabled ? myConstants
								.disableReorder() : myConstants.enableReorder();
						reorderButton.setText(text);
						for (Widget w : rulesContainer) {
							INormalizationRuleForm rule = (INormalizationRuleForm) w;
							rule.enableReorder(reorderEnabled);
						}
					}
				});
		reorderButton.addStyleDependentName(StyleNames.DO_BUTTON_STYLE);
		reorderButton.addStyleName("rule-createRuleButton");
		return reorderButton;
	}

	/*
	 * create a button to create new rules based on name
	 */
	private Button createButton(String buttonName) {
		Button button = new Button(buttonName, new ClickHandler() {
			public void onClick(ClickEvent event) {
				NormalizationRule panel = new NormalizationRule(rulesContainer.getWidgetCount(),
						reorderEnabled, sourceIsMso);
				panel.addDeleteHandler(buildRuleDelHander());
				panel.addReorderHandler(buildReorderHandler());
				rulesContainer.add(panel);
			}
		});
		button.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
		button.addStyleName("rule-createRuleButton");
		return button;
	}

	/*
	 * create a button to create new rules based on name
	 */
	private Button addCustomButton() {
		String buttonName = myConstants.addCustomRule();
		Button button = new Button(buttonName, new ClickHandler() {
			public void onClick(ClickEvent event) {
				CustomNormalizationRule vrule = new CustomNormalizationRule(
						rulesContainer.getWidgetCount(), reorderEnabled);
				vrule.addDeleteHandler(buildRuleDelHander());
				vrule.addReorderHandler(buildReorderHandler());
				rulesContainer.add(vrule);
			}
		});
		button.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
		button.addStyleName("rule-createRuleButton");
		return button;
	}

	private RuleReorderHandler buildReorderHandler() {
		return new RuleReorderHandler() {

			@Override
			public void reorder(RuleReorderEvent event) {
				INormalizationRuleForm rule = event.getRule();
				int newPos = event.getNewIndex();
				if (newPos == rule.getIndex())
					return;

				// Trim the new pos
				if (newPos < 0) {
					newPos = 0;
				} else if (newPos > rulesContainer.getWidgetCount() - 1) {
					newPos = rulesContainer.getWidgetCount() - 1;
				}

				int containerPos = newPos;
				if (newPos > rule.getIndex())
					containerPos++;
				rulesContainer.insert((Widget) rule, containerPos);

				// update indexes of affected rules
				int i = rule.getIndex() < newPos ? rule.getIndex() : newPos;

				while (i < rulesContainer.getWidgetCount()) {
					((INormalizationRuleForm)rulesContainer.getWidget(i)).setCurrentIndex(i);
					i++;
				}
			}

		};
	}

	public boolean isReorderEnabled() {
		return reorderEnabled;
	}

}
