package com.tandbergtv.cms.rules.ui.client.normalization;

import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldSelector;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.RulesUtils;
import com.tandbergtv.cms.rules.ui.client.UiActionService;
import com.tandbergtv.cms.rules.ui.client.UiActionServiceAsync;
import com.tandbergtv.cms.rules.ui.client.common.EventSelectPanel;
import com.tandbergtv.cms.rules.ui.client.common.Permissions;
import com.tandbergtv.cms.rules.ui.client.common.RuleNamePanel;
import com.tandbergtv.cms.rules.ui.client.common.RulePanel;
import com.tandbergtv.cms.rules.ui.client.common.SchedulePanel;
import com.tandbergtv.cms.rules.ui.client.common.TabItem;
import com.tandbergtv.cms.rules.ui.client.common.TabbedWizard;
import com.tandbergtv.cms.rules.ui.client.common.TitleFilterPanel;
import com.tandbergtv.cms.rules.ui.client.common.UiInvalidScheduleException;
import com.tandbergtv.cms.rules.ui.client.common.ValidatableVerticalPanel;
import com.tandbergtv.cms.rules.ui.client.common.WizardPane;
import com.tandbergtv.cms.rules.ui.client.common.site.SiteSelectionPanel;
import com.tandbergtv.cms.rules.ui.client.common.site.UiRuleSetsAssocWJobExpception;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.cms.rules.ui.client.data.UiRule;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.ErrorMessageBuilder;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.RuleServiceException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * This class represnts a RuleSet creation/editing page within the UI
 * @author dweiner
 *
 */
public class NormalizationRuleSetPanel extends RulePanel {

	private TabbedWizard tabbedWizard;
	private TitleFilterPanel panelTitleFilter;
	private NormalizationRulePanel normPanel;
	private ButtonWidget runButton;
	private RuleNamePanel ruleNamePanel;
	private EventSelectPanel panelEventSelect;
	private BusyIndicator busyIndicator = new BusyIndicator();
	private SiteSelectionPanel siteSelectionPanel;
	private SchedulePanel schedulePanel;
		
	public NormalizationRuleSetPanel() {
		super();
	}
	
	@Override
	protected void onUnload(){
		super.onUnload();
		busyIndicator.hide();
	}
	
	@Override
	protected void createPanel() {
		busyIndicator.center();
		if(!NormalizationActionBox.cacheLoaded())
			loadNormalizationActionsAsync();
		else
			populateUi();
	}
	
	private void populateUi() {
		setStyleName("rule-panel");
		
		resetMessagePanel();
		setHeaderLabel();
		
		ruleNamePanel = new RuleNamePanel(ruleSet.getName(), ruleSet.isEnabled());		
		panelEventSelect = new EventSelectPanel(ruleSet);
		panelTitleFilter = new TitleFilterPanel(ruleSet);
		normPanel = new NormalizationRulePanel(ruleSet.getRules(), false);
		schedulePanel = new SchedulePanel(ruleSet.getScheduleInfo());

		NeptuneSecurity security = RulesComponent.getInstance().getSecurity();

		boolean canCreateSchedule = security
				.isUserInRole(com.ericsson.cms.scheduling.ui.client.Permissions.CREATE);
		boolean canViewSchedule = security
				.isUserInRole(com.ericsson.cms.scheduling.ui.client.Permissions.VIEW);
		boolean canEditSchedule = security.isUserInRole(Permissions.MODIFY) && security
				.isUserInRole(com.ericsson.cms.scheduling.ui.client.Permissions.EDIT);
		boolean canDeleteSchedule = security.isUserInRole(Permissions.MODIFY) && security
				.isUserInRole(com.ericsson.cms.scheduling.ui.client.Permissions.DELETE);

		boolean isScheduleVisible = ((ruleSet.getScheduleInfo() == null) && canCreateSchedule)
				|| canViewSchedule || canEditSchedule || canDeleteSchedule;
		boolean isScheduleCheckBoxEnabled = ((ruleSet.getScheduleInfo() == null) && canCreateSchedule)
				|| ((ruleSet.getScheduleInfo() != null) && canDeleteSchedule);
		boolean isScheduleEnabled = ((ruleSet.getScheduleInfo() == null) && canCreateSchedule)
				|| canEditSchedule;

		schedulePanel.setScheduleEnabled(isScheduleEnabled);
		schedulePanel.setCheckBoxEnabled(isScheduleCheckBoxEnabled);

		// If there is a schedule associated with this rule set, but user 
		//	does not have permissions to view the schedule, 
		//	display an error message to the user. 
		
		if ((ruleSet.getScheduleInfo() != null) && !isScheduleVisible) {
			showErrorMessage(myConstants.msgScheduleButCannotShow());
		}
		
		WizardPane collapseEventSelect = new WizardPane(panelEventSelect,
				myConstants.wizardEventSelection(), isScheduleVisible ? true
						: false);
		WizardPane collapseSchedule = new WizardPane(schedulePanel, myConstants.wizardScheduleSelection(), true);
		
		ValidatableVerticalPanel eventScheduleContainer = new ValidatableVerticalPanel();
		eventScheduleContainer.add(collapseEventSelect);
		if (isScheduleVisible) {
			eventScheduleContainer.add(collapseSchedule);
		}
		
		TabItem whenToRunTabItem = new TabItem(myConstants.eventScheduleWizInstruct(), eventScheduleContainer);
		TabItem titleFilterTabItem = new TabItem(myConstants.wizFilterInstruct(), panelTitleFilter);
		TabItem normRuleTabItem = new TabItem(myConstants.normRuleInstruct(), normPanel);
		TabItem ruleNameTabItem = new TabItem(myConstants.ruleNameInstructions(), ruleNamePanel);
		
		if(RulesUtils.isFeatureAvailable(RulesUtils.FEATURE_NAME_SITES)) {
			if(ruleSet.isNew() && ruleSet.getSites().isEmpty()) {
				siteSelectionPanel = new SiteSelectionPanel();
			} else {
				siteSelectionPanel = new SiteSelectionPanel(ruleSet.getSites(), ruleSet.isRunOnGlobal());
			}
			TabItem siteSelectionTabItem = new TabItem(myConstants.siteSelectInstructions(), siteSelectionPanel);
			tabbedWizard = new TabbedWizard(siteSelectionTabItem, myConstants.sitesLabel(), "");
			tabbedWizard.addTab(whenToRunTabItem, myConstants.wizardEventSchedule());
		}
		else {
			tabbedWizard = new TabbedWizard(whenToRunTabItem, myConstants.wizardEventSchedule(), "");
		}
		
		tabbedWizard.addTab(titleFilterTabItem, myConstants.wizardTitleFilter());
		tabbedWizard.addTab(normRuleTabItem, myConstants.wizardNormalization());
		tabbedWizard.addTab(ruleNameTabItem, myConstants.wizardRuleName());
		
		tabbedWizard.addHeightOffsettingWidget(headerPanel);
		
		add(tabbedWizard);
		
		ButtonWidget saveButton = createSaveButton();
		saveButton.addClickHandler(getSaveHandler());
		saveButton.setVisible(false);
		
		ButtonWidget cancelButton = createCancelButton();
		cancelButton.addClickHandler(getDefaultCancelHandler());
		cancelButton.setVisible(false);
		
		
		tabbedWizard.addCommonBottomWidget(saveButton);
		
		if (security.isUserInRole(Permissions.MODIFY)
				|| (ruleSet.isNew() && security.isUserInRole(Permissions.CREATE))) {
			ButtonWidget runButton = createRunButton();
			runButton.setVisible(false);
			tabbedWizard.addCommonBottomWidget(runButton);
		}	
		
		tabbedWizard.addCommonBottomWidget(cancelButton);

		tabbedWizard.show(ruleSet.isNew());

		this.registerMessageListener(tabbedWizard);
		schedulePanel.registerMessageListener(tabbedWizard);
		
		FieldSelector.initialize(CriteriaType.RULE_CONDITION_LHS, UiCriteriaMode.EPISODE);
		FieldSelector.initialize(CriteriaType.SEARCH_CONDITION_LHS, UiCriteriaMode.EPISODE);
		busyIndicator.hide();
	}

	/**
	 * performs necessary async call to load cached data
	 */
	private void loadNormalizationActionsAsync() {
		UiActionServiceAsync actionService = GWT.create(UiActionService.class);
		actionService.getActions(Packages.NORMALIZATION,
				new NeptuneAsyncCallback<List<UIAction>>() {

					@Override
					public void onNeptuneFailure(Throwable caught) {
						busyIndicator.hide();
						Window.alert(caught == null ? "" : caught.getMessage());
					}

					@Override
					public void onNeptuneSuccess(List<UIAction> result) {
						NormalizationActionBox.setActionsListCache(result);
						populateUi();
					}
				});
	}

	/**
	 * Creates the button which is used to run the rule set against all existing
	 * titles.
	 * 
	 * @return The run against all titles button widget.
	 */
	protected ButtonWidget createRunButton() {
		runButton = new ButtonWidget(myConstants.normalizationManualExecution());
		runButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				resetMessagePanel();
				runButton.setEnabled(false);
				if(!tabbedWizard.validateAllItems()) {
					runButton.setEnabled(true);
					return;
				}
				UIRuleSet ruleset = buildRuleSet();
				List<UiRule> rules = ruleset.getRules();
				
				if(siteSelectionPanel.containsGlobalAndSite() && failsContractValidate(rules)) {
					showInfoMessage(myConstants.failsContractValidation());
					runButton.setEnabled(false);
					return;
				}

				if(Window.confirm(myConstants.normalizationManualExecutionAreYouSure())) {
					rulesService.saveAndRunRuleSet(ruleset, new NeptuneAsyncCallback<Integer>(){
						@Override
						public void onNeptuneFailure(Throwable caught) {
							runButton.setEnabled(true);
							if(caught instanceof RuleServiceException) {
								List<String> messages = 
									ErrorMessageBuilder.getErrorMessages((RuleServiceException) caught);
								showErrorMessages(messages);
										
							} else if (caught instanceof UiRuleSetsAssocWJobExpception) {
								handleSiteJobAssoc((UiRuleSetsAssocWJobExpception)caught);
							} else if (caught instanceof UiInvalidScheduleException) {
								UiInvalidScheduleException uise = (UiInvalidScheduleException) caught;
								List<String> messages = 
									ErrorMessageBuilder.getErrorMessages(uise);
								schedulePanel.clearWarningMessages();
								schedulePanel.addWarningMessages(messages);
							}  else {
								Window.alert(caught == null ? "" : caught.getMessage());
							}
						}
						@Override
						public void onNeptuneSuccess(Integer result) {
							runButton.setEnabled(true);
							History.back();
						}
					});
				} else {
					runButton.setEnabled(true);
				}
			}
		});
		runButton.addStyleDependentName(StyleNames.DO_BUTTON_STYLE);
		ruleNamePanel.getRuleEnabled().addClickHandler(
				createRuleEnabledClickHander());
		
		enableDisableRunButton();
		return runButton;
	}

	/**
	 * Creates a click handler for the Enable Rule check box
	 * in the Rule name panel.
	 * @return
	 */
	private ClickHandler createRuleEnabledClickHander() {
		return new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				runButton.setEnabled(ruleNamePanel.isEnabled());
			}
			
		};
	}
	
	/**
	 * Enable / Disable Run Button
	 * 
	 * The button can be enabled if the enabled checkbox in the 
	 * rule name panel is enabled.
	 */
	private void enableDisableRunButton() {
		runButton.setEnabled(ruleNamePanel.isEnabled());
	}

	/**
	 * A click handler that kicks of an asynchronous save.
	 * On success the user is returned to the rule listing page.
	 * 
	 * @return The click handler.
	 */
	private ClickHandler getSaveHandler() {
		return new ClickHandler() {
			public void onClick(ClickEvent event) {
				resetMessagePanel();
				if(!tabbedWizard.validateAllItems()) {
					return;
				}
				final ButtonWidget button = (ButtonWidget) event.getSource();
				UIRuleSet ruleset = buildRuleSet();
				
				List<UiRule> rules = ruleset.getRules();
				
				if(siteSelectionPanel.containsGlobalAndSite() && failsContractValidate(rules)) {
					showInfoMessage(myConstants.failsContractValidation());
					return;
				}

				button.setEnabled(false);
				rulesService.saveRuleSet(ruleset, new NeptuneAsyncCallback<Integer>(){
					@Override
					public void onNeptuneFailure(Throwable caught) {
						button.setEnabled(true);
						if(caught instanceof RuleServiceException) {
							List<String> messages = 
								ErrorMessageBuilder.getErrorMessages((RuleServiceException) caught);
							showErrorMessages(messages);
									
						} else if (caught instanceof UiRuleSetsAssocWJobExpception) {
							handleSiteJobAssoc((UiRuleSetsAssocWJobExpception)caught);
						} else if (caught instanceof UiInvalidScheduleException) {
							UiInvalidScheduleException uise = (UiInvalidScheduleException) caught;
							List<String> messages = 
								ErrorMessageBuilder.getErrorMessages(uise);
							schedulePanel.clearWarningMessages();
							schedulePanel.addWarningMessages(messages);
						} else {
							Window.alert(caught == null ? "" : caught.getMessage());
						}
					}

					@Override
					public void onNeptuneSuccess(Integer result) {
						resetMessagePanel();
						button.setEnabled(true);
						//Send back to ruleListingPanel
						History.back();
					}
				});
			}
		};
	}
	
	/**
	 * Builds a rule set the represents what is currently displayed on the page.
	 * 
	 * @return The rule set to be saved.
	 */
	private UIRuleSet buildRuleSet() {
		// create rule set from various panels
		UIRuleSet ruleset = new UIRuleSet();
		ruleset.setId(ruleSet.getId());
		ruleset.setEnabled(ruleNamePanel.isEnabled());
		ruleset.setName(ruleNamePanel.getRuleName());
		if(siteSelectionPanel != null) {
			ruleset.setRunOnGlobal(siteSelectionPanel.isRunOnGlobal());
			ruleset.setSites(siteSelectionPanel.getSites()); 
		}
		ruleset.setPackageId(Packages.NORMALIZATION);
		ruleset.setEvents(panelEventSelect.getEvents());
		boolean isSchedulerLicensed = RulesUtils.isSchedulerLicensed();
		if (isSchedulerLicensed) {
			ruleset.setScheduleInfo(schedulePanel.getScheduleInfo());
		}
		ruleset.setRules(normPanel.getRules());
		ruleset.setTitleFilter(panelTitleFilter.getTitleFilter());
		return ruleset;
	}

	private void setHeaderLabel() {
		String newRule = myConstants.newNormalizationRule();
		String oldRule = myConstants.normalizationRuleDetails() + " " + ruleSet.getName() ;
		String header = (ruleSet.getName().equals("")) ? newRule : oldRule;
		setHeaderLabel(header);
	}

}
