package com.tandbergtv.cms.rules.ui.client.prioritization;

import java.util.ArrayList;
import java.util.List;

import com.tandbergtv.cms.rules.ui.client.data.ActionParams;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.data.UIActionParam;
import com.tandbergtv.cms.rules.ui.client.data.UiRule;
import com.tandbergtv.cms.rules.ui.client.data.UiStandardRule;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * This is the ui component which represents a rule within
 * a prioritization rule set.  Currently a prioritization
 * rule set contains only one rule.
 * @author esakhat
 *
 */
public class PrioritizationRulePanel extends VerticalContainer  {
	
	private ListBoxWidget<UiProcessPriority> priorities = new ListBoxWidget<UiProcessPriority>();
	private UiRule rule;
	/*I go to the server once and get the blank copy of the action. I mostly
	 * do this for consistency sake.  Basically we can have only one action with one parameter for
	 * prioritization.
	 * Action: Set Priority
	 * Parameter: priority
	*/
	private static UIAction blankAction;

	public PrioritizationRulePanel(List<UiRule> rules) {
		if(rules != null && rules.size() == 1) {
			this.rule = rules.get(0);
		}
		putUiTogether();
	}
	
	private void putUiTogether() {
		priorities = new ListBoxWidget<UiProcessPriority>();
		for(UiProcessPriority  priority : UiProcessPriority.values()) {
			priorities.addItem(priority.name(), priority);
			if (UiProcessPriority.NORMAL.equals(priority)) {
				priorities.setSelectedItem(priority);
			}
		}
		
		if(rule != null && rule.getActions().size() == 1) {
			UIAction action = rule.getActions().get(0);
			if(action.containsParam(ActionParams.PRIORITY)) {
				UIActionParam param = action.getParam(ActionParams.PRIORITY);
				String priorityValue = param.getValue();
				
				for(UiProcessPriority priority : UiProcessPriority.values()) {
					if(priority.name().equals(priorityValue)) {
						priorities.setSelectedItem(priority);
						break;
					}
				}
			}
		}
		
		add(priorities);
	}

	public List<UiRule> getRules() {
		List<UiRule> result = new ArrayList<UiRule>();
		UiRule newRule = new UiStandardRule();
		newRule.setActions(getActions());
		if(rule != null)
			newRule.setId(rule.getId());
		result.add(newRule);
		return result;
	}
	
	private List<UIAction> getActions() {
		List<UIAction> result = new ArrayList<UIAction>();
		UIAction action = blankAction.clone();
		
		if(action.containsParam(ActionParams.PRIORITY)) {
			UIActionParam param = action.getParam(ActionParams.PRIORITY);
			param.setValue(priorities.getSelectedItem().name());
		}
		result.add(action);
		return result;
	}

	public static void setCachedBlankAction(UIAction blankAction) {
		PrioritizationRulePanel.blankAction = blankAction;
	}

	/**
	 * Returns true if the cached items are loaded. Specifically this is concerning
	 * the action.
	 * @return Returns true if the cached items are loaded.
	 */
	public static boolean cachedLoaded() {
		return blankAction != null;
	}

}
