package com.tandbergtv.cms.rules.ui.client.prioritization;

import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldSelector;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.rules.ui.client.RulesUtils;
import com.tandbergtv.cms.rules.ui.client.UiActionService;
import com.tandbergtv.cms.rules.ui.client.UiActionServiceAsync;
import com.tandbergtv.cms.rules.ui.client.common.RuleNamePanel;
import com.tandbergtv.cms.rules.ui.client.common.RulePanel;
import com.tandbergtv.cms.rules.ui.client.common.TabItem;
import com.tandbergtv.cms.rules.ui.client.common.TabbedWizard;
import com.tandbergtv.cms.rules.ui.client.common.TitleFilterPanel;
import com.tandbergtv.cms.rules.ui.client.common.site.SiteSelectionPanel;
import com.tandbergtv.cms.rules.ui.client.common.site.UiRuleSetsAssocWJobExpception;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.ErrorMessageBuilder;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.RuleServiceException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;

/**
 *  This is the prioritization rule set details page.
 * @author esakhat
 *
 */
public class PrioritizationRuleSetPanel extends RulePanel {

	private TabbedWizard tabbedWizard;
	private RuleNamePanel ruleNamePanel;
	private TitleFilterPanel panelTitleFilter;
	private PrioritizationRulePanel prioritizationPanel;
	private BusyIndicator busyIndicator = new BusyIndicator();
	private SiteSelectionPanel siteSelectionPanel;

	public PrioritizationRuleSetPanel() {
		super();
	}

	@Override
	protected void createPanel() {
		busyIndicator.center();
		if(!PrioritizationRulePanel.cachedLoaded()) {
			getAvailableActions();
		} else {
			populateUi();
		}
	}
	
	/**
	 * builds all the UI objects and adds them to the container.
	 */
	private void populateUi() {
		setStyleName("rule-panel");
		
		resetMessagePanel();
		setHeaderLabel();
		
		ruleNamePanel = new RuleNamePanel(ruleSet.getName(), ruleSet.isEnabled());
		panelTitleFilter = new TitleFilterPanel(ruleSet);
		prioritizationPanel = new PrioritizationRulePanel(ruleSet.getRules());
		
		TabItem titleFilterTabItem = new TabItem(myConstants.wizFilterInstruct(), panelTitleFilter);
		TabItem prioritizationRuleTabItem = new TabItem(myConstants.priorRuleInstruct(), prioritizationPanel);
		TabItem ruleNameTabItem = new TabItem(myConstants.ruleNameInstructions(), ruleNamePanel);

		if(RulesUtils.isFeatureAvailable(RulesUtils.FEATURE_NAME_SITES)) {
			if(ruleSet.isNew() && ruleSet.getSites().isEmpty()) {
				siteSelectionPanel = new SiteSelectionPanel();
			} else {
				siteSelectionPanel = new SiteSelectionPanel(ruleSet.getSites(), ruleSet.isRunOnGlobal());
			}
			TabItem siteSelectionTabItem = new TabItem(myConstants.siteSelectInstructions(), siteSelectionPanel);
			tabbedWizard = new TabbedWizard(siteSelectionTabItem, myConstants.sitesLabel(), "");
			tabbedWizard.addTab(titleFilterTabItem, myConstants.wizardTitleFilter());
		}
		else {
			tabbedWizard = new TabbedWizard(titleFilterTabItem, myConstants.wizardTitleFilter(), "");
		}

		tabbedWizard.addTab(prioritizationRuleTabItem, myConstants.wizardPrioritization());
		tabbedWizard.addTab(ruleNameTabItem, myConstants.wizardRuleName());
		
		tabbedWizard.addHeightOffsettingWidget(headerPanel);
		
		add(tabbedWizard);
		
		ButtonWidget saveButton = createSaveButton();
		saveButton.addClickHandler(getSaveHandler());
		saveButton.setVisible(false);
		
		ButtonWidget cancelButton = createCancelButton();
		cancelButton.addClickHandler(getDefaultCancelHandler());
		cancelButton.setVisible(false);
		
		
		tabbedWizard.addCommonBottomWidget(saveButton);
		tabbedWizard.addCommonBottomWidget(cancelButton);

		tabbedWizard.show(ruleSet.isNew());
		
		this.registerMessageListener(tabbedWizard);

		FieldSelector.getTree(CriteriaType.SEARCH_CONDITION_LHS, UiCriteriaMode.EPISODE);
		busyIndicator.hide();
	}

	private ClickHandler getSaveHandler() {
		return new ClickHandler() {
			public void onClick(ClickEvent event) {
				if(!tabbedWizard.validateAllItems())
					return;
				// create rule set from various panels
				final ButtonWidget button = (ButtonWidget) event.getSource();
				UIRuleSet ruleset = new UIRuleSet();
				ruleset.setId(ruleSet.getId());
				ruleset.setEnabled(ruleNamePanel.isEnabled());
				ruleset.setName(ruleNamePanel.getRuleName());
				if(siteSelectionPanel != null) {
					ruleset.setRunOnGlobal(siteSelectionPanel.isRunOnGlobal());
					ruleset.setSites(siteSelectionPanel.getSites()); 
				}
				ruleset.setPackageId(Packages.PRIORITIZATION);
				ruleset.setRules(prioritizationPanel.getRules());
				ruleset.setTitleFilter(panelTitleFilter.getTitleFilter());
				button.setEnabled(false);
				
				rulesService.saveRuleSet(ruleset, new NeptuneAsyncCallback<Integer>(){
					@Override
					public void onNeptuneFailure(Throwable caught) {
						button.setEnabled(true);
						if(caught instanceof RuleServiceException) {
							List<String> messages = 
								ErrorMessageBuilder.getErrorMessages((RuleServiceException) caught);
							showErrorMessages(messages);
									
						} else if (caught instanceof UiRuleSetsAssocWJobExpception) {
							handleSiteJobAssoc((UiRuleSetsAssocWJobExpception)caught);
						}  else {
							Window.alert(caught == null ? "" : caught.getMessage());
						}
					}
					@Override
					public void onNeptuneSuccess(Integer result) {
						//Send back to ruleListingPanel
						resetMessagePanel();
						button.setEnabled(true);
						History.back();
					}
				});
			}
		};
	}

	private void setHeaderLabel() {
		String newRule = myConstants.newPrioritizationRule();
		String oldRule = myConstants.prioritizationRuleDetails() + " " + ruleSet.getName();
		String headerString = (ruleSet.getName().equals(""))?  newRule : oldRule;
		setHeaderLabel(headerString);
	}
	
	/**
	 * ProcessingRulePanel has a couple of cached items
	 * that need to be loaded asynchronously. As each one completes
	 * it notifies me by calling this method.  I know when I done
	 * when ProcessingRulePanel.cachedLoaded() returns true. 
	 */
	private void notifyDoneWithAsync() {
		if (PrioritizationRulePanel.cachedLoaded()) {
			populateUi();
		}
	}
	
	/**
	 * Load the prioritization action from the server
	 */
	private void getAvailableActions() {
		UiActionServiceAsync actionService = GWT.create(UiActionService.class);
		actionService.getActions(Packages.PRIORITIZATION,
				new NeptuneAsyncCallback<List<UIAction>>() {

					@Override
					public void onNeptuneFailure(Throwable caught) {
						busyIndicator.hide();
						Window.alert(caught == null ? "" : caught
								.getMessage());
					}

					@Override
					public void onNeptuneSuccess(List<UIAction> result) {
						if(result != null && result.size() == 1) {
							PrioritizationRulePanel.setCachedBlankAction(result.get(0));
							notifyDoneWithAsync();
						} else {
							Window.alert("ERROR: There should only be one action available for Prioritization.");
							busyIndicator.hide();
						}
					}

				});
	}
		
	@Override
	protected void onUnload(){
		super.onUnload();
		//we always hide on unLoad
		busyIndicator.hide();
	}

}
