package com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.tandbergtv.cms.rules.ui.client.common.UiInvalidScheduleException;

public class ErrorMessageBuilder {
	
	private static RuleServiceErrorMessages messages = (RuleServiceErrorMessages) GWT
	.create(RuleServiceErrorMessages.class);
	
	public static List<String> getErrorMessages(UiInvalidScheduleException e) {
		List<String> result = new ArrayList<String>();
		for(String reasonCode : e.getReasons().keySet()) {
			if ("errInvalidSchedule".equals(reasonCode)) {
				result.add(messages.errInvalidSchedule());
			}
			else {
				result.add(messages.defaultErrorMessage());
			}
		}
		
		return result;
	}

	public static List<String> getErrorMessages(RuleServiceException e) {
		List<String> result = new ArrayList<String>();
		for(UIRuleServiceErrorMessage reason : e.getReason()) {
			result.add(getInternationalizedString(reason));
		}
		return result;
	}
	
	private static String getInternationalizedString(UIRuleServiceErrorMessage reason) {
		List<String> parameters = reason.getParameters();
		String errorCode = reason.getErrorCode();
		
		if(parameters == null)
			return messages.defaultErrorMessage();
			
		if(errorCode.equals("errJobIsSecheduledNeedSchedulable") && parameters.size() == 1) {
			return messages.errJobIsSecheduledNeedSchedulable(parameters.get(0));
		} else if(errorCode.equals("errJobIsSecheduledCantDelete") && parameters.size() == 2) {
			return messages.errJobIsSecheduledCantDelete(parameters.get(0), parameters.get(1));
		} else if(errorCode.equals("errScheduleDeleteNotPermitted") && parameters.size() == 1) {
			return messages.errScheduleDeleteNotPermitted(parameters.get(0));
		} else if(errorCode.equals("errScheduleModifyNotAuthorized") && parameters.size() == 1) {
			return messages.errScheduleModifyNotAuthorized(parameters.get(0));
		} else if(errorCode.equals("errSiteModifyNotAuthorized") && parameters.size() == 1) {
			return messages.errSiteModifyNotAuthorized(parameters.get(0));
		} else {
			return messages.defaultErrorMessage();
		}
	}
}
