package com.tandbergtv.cms.rules.ui.client.targeting;

import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldSelector;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.RulesUtils;
import com.tandbergtv.cms.rules.ui.client.common.RuleNamePanel;
import com.tandbergtv.cms.rules.ui.client.common.RulePanel;
import com.tandbergtv.cms.rules.ui.client.common.TabItem;
import com.tandbergtv.cms.rules.ui.client.common.TabbedWizard;
import com.tandbergtv.cms.rules.ui.client.common.TitleFilterPanel;
import com.tandbergtv.cms.rules.ui.client.common.site.SiteSelector;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.ErrorMessageBuilder;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.RuleServiceException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;

/**
 * This is the targeting rule set details page.
 * @author  skhattar
 */
public class TargetingRuleSetPanel extends RulePanel {

	private TabbedWizard tabbedWizard;
	private RuleNamePanel ruleNamePanel;
	private TitleFilterPanel panelTitleFilter;
	private RulesConstants myConstants = (RulesConstants) GWT
			.create(RulesConstants.class);
	private BusyIndicator busyIndicator = new BusyIndicator();
	private SiteSelector siteSelector;
	
	/**
	 * Constructor to create a standard Targeting Rule Panel
	 */
	public TargetingRuleSetPanel() {
		super();
	}
	
	@Override
	protected void onUnload() {
		super.onUnload();
		busyIndicator.hide();
	}

	@Override
	public void createPanel() {
		busyIndicator.center();
		populateUi();
	}
	
	/**
	 * builds all the UI objects and adds them to the container.
	 */
	private void populateUi() {
		setStyleName("rule-panel");

		resetMessagePanel();
		setHeaderLabel();
		
		ruleNamePanel = new RuleNamePanel(ruleSet.getName(), ruleSet.isEnabled());
		panelTitleFilter = new TitleFilterPanel(ruleSet);

		TabItem titleFilterTabItem = new TabItem(myConstants.wizFilterInstruct(), panelTitleFilter);
		TabItem ruleNameTabItem = new TabItem(myConstants.ruleNameInstructions(), ruleNamePanel);
		
		tabbedWizard = new TabbedWizard(titleFilterTabItem, myConstants.wizardTitleFilter(), "");
		if(RulesUtils.isFeatureAvailable(RulesUtils.FEATURE_NAME_SITES)) {
			if(ruleSet.isNew() && ruleSet.getSites().isEmpty()) {
				siteSelector = new SiteSelector();
			} else {
				siteSelector = new SiteSelector(ruleSet.getSites());
			}
			TabItem siteSelectorTabItem = new TabItem(myConstants.targetSiteSelectInstructions(), siteSelector);
			tabbedWizard.addTab(siteSelectorTabItem, myConstants.sitesLabel());
		}
		
		tabbedWizard.addTab(ruleNameTabItem, myConstants.wizardRuleName());
		
		tabbedWizard.addHeightOffsettingWidget(headerPanel);
		
		add(tabbedWizard);
		
		ButtonWidget saveButton = createSaveButton();
		saveButton.addClickHandler(getSaveHandler());
		saveButton.setVisible(false);
		
		ButtonWidget cancelButton = createCancelButton();
		cancelButton.addClickHandler(getDefaultCancelHandler());
		cancelButton.setVisible(false);
		
		tabbedWizard.addCommonBottomWidget(saveButton);
		tabbedWizard.addCommonBottomWidget(cancelButton);
		
		tabbedWizard.show(ruleSet.isNew());

		this.registerMessageListener(tabbedWizard);

		FieldSelector.getTree(CriteriaType.SEARCH_CONDITION_LHS, UiCriteriaMode.EPISODE);
		busyIndicator.hide();
	}
	
	private ClickHandler getSaveHandler() {
		return new ClickHandler() {
			public void onClick(ClickEvent event) {

				if(!tabbedWizard.validateAllItems())
					return;

				final ButtonWidget button = (ButtonWidget) event.getSource();
				button.setEnabled(false);
				
				// create rule set from various panels
				UIRuleSet ruleset = buildRuleSet();
				
				rulesService.saveRuleSet(ruleset, new NeptuneAsyncCallback<Integer>(){
					@Override
					public void onNeptuneFailure(Throwable caught) {
						button.setEnabled(true);
						if(caught instanceof RuleServiceException) {
							List<String> messages = 
								ErrorMessageBuilder.getErrorMessages((RuleServiceException) caught);
							showErrorMessages(messages);
									
						} else {
							Window.alert(caught == null ? "" : caught.getMessage());
						}
					}
					@Override
					public void onNeptuneSuccess(Integer result) {
						// go back to rules lisitng page
						resetMessagePanel();
						button.setEnabled(true);
						History.back();
					}
				});
			}
		};
	}

	/**
	 * Builds a rule set the represents what is currently displayed on the page.
	 * 
	 * @return The rule set to be saved.
	 */
	private UIRuleSet buildRuleSet() {
		// create rule set from various panels
		UIRuleSet ruleset = new UIRuleSet();
		ruleset.setId(ruleSet.getId());
		ruleset.setEnabled(ruleNamePanel.isEnabled());
		ruleset.setName(ruleNamePanel.getRuleName());
		if(siteSelector != null) {
			ruleset.setSites(siteSelector.getSelectedSites()); 
		}
		ruleset.setPackageId(Packages.TARGETING);
		ruleset.setTitleFilter(panelTitleFilter.getTitleFilter());
		return ruleset;
	}

	private void setHeaderLabel() {
		String newRule = myConstants.newTargetingRule();
		String ruleName = myConstants.targetingRuleDetails() + " "
				+ ruleSet.getName();
		String headerString = ruleSet.getName().isEmpty() ? newRule : ruleName;
		setHeaderLabel(headerString);
	}
}
