package com.tandbergtv.cms.rules.ui.client.validation;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.tandbergtv.cms.portal.ui.title.client.TitleStyleNames;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaListingPanel;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.UiRulesService;
import com.tandbergtv.cms.rules.ui.client.UiRulesServiceAsync;
import com.tandbergtv.cms.rules.ui.client.common.IRuleForm;
import com.tandbergtv.cms.rules.ui.client.common.customrules.CustomRuleBox;
import com.tandbergtv.cms.rules.ui.client.common.events.RuleDeleteEvent;
import com.tandbergtv.cms.rules.ui.client.common.events.RuleDeleteHandler;
import com.tandbergtv.cms.rules.ui.client.data.ActionParams;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.data.UIActionParam;
import com.tandbergtv.cms.rules.ui.client.data.UiRule;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiCustomRule;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiCustomRuleParameter;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiCustomRuleTree;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class CustomValidationRule extends SimplePanel implements IRuleForm {

	private static final String MESSAGE_STYLE = "big-txt-box";
	private static final String SMALL_TEXT = "small-txt";

	private VerticalPanel mainPanel = new VerticalPanel();
	private RulesConstants myConstants = (RulesConstants) GWT
			.create(RulesConstants.class);
	private VerticalContainer warningMessages = new VerticalContainer();
	private TextBoxWidget actionText = new TextBoxWidget();
	private UiCustomRule rule;
	private static UiRulesServiceAsync rulesService = GWT
			.create(UiRulesService.class);

	private static UiCustomRuleTree customValidationRules;

	private ListBoxWidget<UIAction> actionsList;
	private CustomRuleBox ruleBox;

	public CustomValidationRule() {
		this(null);
	}

	public CustomValidationRule(UiCustomRule rule) {
		this.rule = rule;
		if (customValidationRules == null) {
			loadCustomValidationRules();
		} else {
			putTheUiTogether();
		}
	}

	public void loadCustomValidationRules() {
		try {
			rulesService.getCustomRules(Packages.VALIDATION.toString(),
					new NeptuneAsyncCallback<UiCustomRuleTree>() {

						@Override
						public void onNeptuneFailure(Throwable caught) {
							RulesComponent.getInstance().getCurrentTab()
									.setPanelInError(
											"Error loading custom rules");
						}

						@Override
						public void onNeptuneSuccess(UiCustomRuleTree result) {
							customValidationRules = result;
							putTheUiTogether();
						}

					});
		} catch (NeptuneException e) {
			RulesComponent.getInstance().getCurrentTab().setPanelInError(
					"Error loading custom rules");
		}
	}

	/**
	 * UI externally depends on a rule and list of available actions before it
	 * can proceed. This does not occur until action async callback happens
	 * 
	 * @param rule
	 * 
	 * @param condition
	 *            the condition to be displayed. When null it is assumed this is
	 *            a new condition.
	 */
	private void putTheUiTogether() {
		setWidget(mainPanel);
		// populate action list box
		initializeActionDropDown();

		mainPanel.add(warningMessages);
		mainPanel.add(new LabelWidget(myConstants.validationActionLabel()));

		if (this.rule == null) {
			ruleBox = new CustomRuleBox(customValidationRules);
		} else {
			ruleBox = new CustomRuleBox(customValidationRules, rule);
			setActionSelected();
		}
		mainPanel.add(ruleBox);

		// action selection row
		HorizontalContainer messageRow = new HorizontalContainer();
		messageRow.add(new LabelWidget(myConstants.returnThis() + " "));
		messageRow.add(actionsList);
		actionsList.addStyleName(SMALL_TEXT);
		messageRow.add(new LabelWidget(myConstants.message() + " "));
		messageRow.add(actionText);
		actionText.addStyleName(MESSAGE_STYLE);
		actionText.addStyleName(SMALL_TEXT);

		ButtonWidget delButton = deleteButton();

		mainPanel.add(messageRow);
		mainPanel.add(delButton);

		// SET STYLES
		mainPanel
				.setStyleName(CriteriaListingPanel.CRITERIA_PANEL_CONTAINER_STYLE);
		setStyleName(CriteriaListingPanel.CRITERIA_PANEL_STYLE);
	}

	/**
	 * on loading a ruleset this is a helper to load the action. Must be called
	 * after populateUi because it depends on the actionsList being initialized.
	 * 
	 * @param action
	 * 
	 */
	private void setActionSelected() {
		if (rule.getActions().size() == 1) {
			UIAction action = rule.getActions().get(0);
			UIActionParam param = action.getParam(ActionParams.MESSAGE);
			actionText.setText(param.getValue());
			actionsList.setSelectedItem(action);
		} else {
			String msg = "Unexpected error: validation can only have 1 action.";
			RulesComponent.getInstance().getCurrentTab().setPanelInError(msg);
		}
	}

	/**
	 * Initializes the action drop down using the action cache
	 */
	private void initializeActionDropDown() {
		actionsList = new ListBoxWidget<UIAction>();
		for (UIAction action : ValidationRule.getCachedActions()) {
			String label = myConstants.getString(action.getLabelKey());
			actionsList.addItem(label, action);
		}
	}

	/**
	 * create a button to delete this rule
	 */
	private ButtonWidget deleteButton() {
		ButtonWidget button = new ButtonWidget(myConstants.delete(),
				new ClickHandler() {
					public void onClick(ClickEvent event) {
						fireEvent(new RuleDeleteEvent(CustomValidationRule.this));
					}
				});
		button.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		return button;
	}

	@Override
	public HandlerRegistration addDeleteHandler(RuleDeleteHandler handler) {
		return addHandler(handler, RuleDeleteEvent.TYPE);
	}

	@Override
	public UiRule getRule() {
		UIAction action = actionsList.getSelectedItem().clone();

		if (action.containsParam(ActionParams.MESSAGE)) {
			UIActionParam param = action.getParam(ActionParams.MESSAGE);
			param.setValue(actionText.getText());
		}

		List<UIAction> actions = new ArrayList<UIAction>();
		actions.add(action);

		String className = ruleBox.getClassName();
		List<UiCustomRuleParameter> params = ruleBox.getParameters();
		if (rule != null) {
			rule.setClassName(className);
			rule.setParameters(params);
			rule.setActions(actions);
			return rule;
		} else {
			return new UiCustomRule(actions, className, params);
		}
	}

	@Override
	public boolean validate() {
		boolean result = ruleBox.validate();
		if (actionText.getText().isEmpty()) {
			actionText.addStyleName(TitleStyleNames.PINK_BOX_STYLE);
			actionText.addChangeHandler(new ChangeHandler() {

				@Override
				public void onChange(ChangeEvent event) {
					if (actionText.getText().equals("")) {
						actionText.addStyleName(TitleStyleNames.PINK_BOX_STYLE);
					} else {
						actionText.removeStyleName(TitleStyleNames.PINK_BOX_STYLE);
					}
				}

			});
			result = false;
		}
		return result;
	}
}
