package com.tandbergtv.cms.rules.ui.client.validation;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.criteria.Validatable;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.UiRulesService;
import com.tandbergtv.cms.rules.ui.client.UiRulesServiceAsync;
import com.tandbergtv.cms.rules.ui.client.common.IRuleForm;
import com.tandbergtv.cms.rules.ui.client.common.events.RuleDeleteEvent;
import com.tandbergtv.cms.rules.ui.client.common.events.RuleDeleteHandler;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.cms.rules.ui.client.data.UiRule;
import com.tandbergtv.cms.rules.ui.client.data.UiStandardRule;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiCustomRule;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class ValidationRulePanel extends VerticalContainer implements
		Validatable {

	private List<IRuleForm> validationPanels = new ArrayList<IRuleForm>();
	private VerticalPanel rulesContainer;
	private RulesConstants myConstants = (RulesConstants) GWT
			.create(RulesConstants.class);
	protected static Boolean allowCustomRules;
	protected final UiRulesServiceAsync rulesService = GWT
			.create(UiRulesService.class);
	private UiCriteriaMode critMode = UiCriteriaMode.EPISODE;

	/**
	 * 
	 * @param ruleSet
	 * @param specification
	 */
	public ValidationRulePanel(final UIRuleSet ruleSet) {
		// add criteria list and new rule button to generate new rules
		// create our shrub when we get it from the DB
		rulesContainer = new VerticalPanel();
		if(!ruleSet.isNew()) {
			critMode = ruleSet.getTitleFilter().getCriteriaMode();
		}
		if (allowCustomRules == null) {
			try {
				rulesService.customRulesExist(
						Packages.VALIDATION.toString(),
						new NeptuneAsyncCallback<Boolean>() {

							@Override
							public void onNeptuneFailure(Throwable caught) {
								// DON'T REALLY CARE ABOUT ERRORS. SHOULD NEVER
								// HAPPEN.
								allowCustomRules = false;
								populateUi(ruleSet);
							}

							@Override
							public void onNeptuneSuccess(Boolean result) {
								allowCustomRules = result;
								populateUi(ruleSet);
							}

						});
			} catch (NeptuneException e) {
				// DON'T REALLY CARE ABOUT ERRORS. SHOULD NEVER HAPPEN.
				allowCustomRules = false;
				populateUi(ruleSet);
			}
		} else {
			populateUi(ruleSet);
		}
	}

	private RuleDeleteHandler getRuleDeleteHandler() {
		return new RuleDeleteHandler() {

			@Override
			public void ruleDeleted(RuleDeleteEvent event) {
				validationPanels.remove(event.getRule());
				rulesContainer.remove((Widget) event.getRule());
			}

		};

	}

	/*
	 * adds widgets from each panel list along with a label
	 */
	private void populateUi(UIRuleSet ruleSet) {

		for (UiRule rule : ruleSet.getRules()) {
			if (rule instanceof UiStandardRule) {
				ValidationRule vrule = new ValidationRule(critMode, (UiStandardRule) rule);
				vrule.addDeleteHandler(getRuleDeleteHandler());
				validationPanels.add(vrule);
				rulesContainer.add(vrule);
			} else if (rule instanceof UiCustomRule) {
				CustomValidationRule cvrule = new CustomValidationRule(
						(UiCustomRule) rule);
				cvrule.addDeleteHandler(getRuleDeleteHandler());
				validationPanels.add(cvrule);
				rulesContainer.add(cvrule);
			}
		}

		add(rulesContainer);

		HorizontalPanel buttonPanel = new HorizontalPanel();
		buttonPanel.add(createButton());
		if(allowCustomRules)
			buttonPanel.add(addCustomButton());
		add(buttonPanel);
	}

	/*
	 * create a button to create new rules based on name
	 */
	private ButtonWidget addCustomButton() {
		String buttonName = myConstants.addCustomRule();
		ButtonWidget button = new ButtonWidget(buttonName, new ClickHandler() {
			public void onClick(ClickEvent event) {
				CustomValidationRule vrule = new CustomValidationRule();
				vrule.addDeleteHandler(getRuleDeleteHandler());
				validationPanels.add(vrule);
				rulesContainer.add(vrule);
			}
		});
		button.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
		button.addStyleName("rule-createRuleButton");
		return button;
	}

	/*
	 * create a button to create new rules based on name
	 */
	private ButtonWidget createButton() {
		String buttonName = myConstants.createRuleButtonLabel();
		ButtonWidget button = new ButtonWidget(buttonName, new ClickHandler() {
			public void onClick(ClickEvent event) {
				ValidationRule vrule = new ValidationRule(critMode);
				vrule.addDeleteHandler(getRuleDeleteHandler());
				validationPanels.add(vrule);
				rulesContainer.add(vrule);
			}
		});
		button.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
		button.addStyleName("rule-createRuleButton");
		return button;
	}

	public List<UiRule> getRules() {
		List<UiRule> result = new ArrayList<UiRule>();

		for (IRuleForm panel : validationPanels) {
			result.add(panel.getRule());
		}
		return result;
	}

	public boolean validate() {
		boolean result = true;
		for (IRuleForm panel : validationPanels) {
			if (!panel.validate()) {
				result = false;
			}
		}
		return result;
	}

	public UiCriteriaMode getCriteriaMode() {
		return critMode;
	}

	public void setCriteriaMode(UiCriteriaMode critMode) {
		this.critMode = critMode;
	}
}
