package com.tandbergtv.cms.rules.ui.client.validation;

import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldSelector;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.RulesUtils;
import com.tandbergtv.cms.rules.ui.client.UiActionService;
import com.tandbergtv.cms.rules.ui.client.UiActionServiceAsync;
import com.tandbergtv.cms.rules.ui.client.common.RuleNamePanel;
import com.tandbergtv.cms.rules.ui.client.common.RulePanel;
import com.tandbergtv.cms.rules.ui.client.common.TabItem;
import com.tandbergtv.cms.rules.ui.client.common.TabbedWizard;
import com.tandbergtv.cms.rules.ui.client.common.TitleFilterPanel;
import com.tandbergtv.cms.rules.ui.client.common.site.SiteSelectionPanel;
import com.tandbergtv.cms.rules.ui.client.common.site.UiRuleSetsAssocWJobExpception;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.cms.rules.ui.client.data.UiRule;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.ErrorMessageBuilder;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.RuleServiceException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;

/**
 * This is the validation rule set details page.
 * @author rchu
 *
 */
public class ValidationRuleSetPanel extends RulePanel {

	private TabbedWizard tabbedWizard;
	private RuleNamePanel ruleNamePanel;
	private TitleFilterPanel panelTitleFilter;
	private ValidationRulePanel panelValidation;
	private RulesConstants myConstants = (RulesConstants) GWT
			.create(RulesConstants.class);
	private BusyIndicator busyIndicator = new BusyIndicator();
	private SiteSelectionPanel siteSelectionPanel;

	/**
	 * Constructor to create a standard Validation Rule Panel
	 */
	public ValidationRuleSetPanel() {
		super();
	}
	
	@Override
	protected void onUnload() {
		super.onUnload();
		busyIndicator.hide();
	}

	@Override
	public void createPanel() {
		busyIndicator.center();
		/* before we can populate ui make sure we load asynchronous data first.
		 * if it is not already loaded*/
		if(!ValidationRule.cacheLoaded())
			getActionLookupAsync();
		else
			populateUi();
	}
	
	/**
	 * builds all the UI objects and adds them to the container.
	 * @param contentClasses 
	 */
	private void populateUi() {
		setStyleName("rule-panel");

		resetMessagePanel();
		setHeaderLabel();
		
		ruleNamePanel = new RuleNamePanel(ruleSet.getName(), ruleSet.isEnabled());
		panelValidation = new ValidationRulePanel(ruleSet);
		panelTitleFilter = new TitleFilterPanel(new SelectionHandler<UiCriteriaMode>() {
			@Override
			public void onSelection(SelectionEvent<UiCriteriaMode> event) {
				panelValidation.setCriteriaMode(event.getSelectedItem());
			}
		}, ruleSet);
		
		TabItem titleFilterTabItem = new TabItem(myConstants.wizFilterInstruct(), panelTitleFilter);
		TabItem validationTabItem = new TabItem(myConstants.validationCriteriaInstructions(), panelValidation);
		TabItem ruleNameTabItem = new TabItem(myConstants.ruleNameInstructions(), ruleNamePanel);

		if(RulesUtils.isFeatureAvailable(RulesUtils.FEATURE_NAME_SITES)) {
			if(ruleSet.isNew() && ruleSet.getSites().isEmpty()) {
				siteSelectionPanel = new SiteSelectionPanel();
			} else {
				siteSelectionPanel = new SiteSelectionPanel(ruleSet.getSites(), ruleSet.isRunOnGlobal());
			}
			TabItem siteSelectionTabItem = new TabItem(myConstants.siteSelectInstructions(), siteSelectionPanel);
			tabbedWizard = new TabbedWizard(siteSelectionTabItem, myConstants.sitesLabel(), "");
			tabbedWizard.addTab(titleFilterTabItem, myConstants.wizardTitleFilter());
		}
		else {
			tabbedWizard = new TabbedWizard(panelTitleFilter, myConstants.wizardTitleFilter(), "");
		}
		
		tabbedWizard.addTab(validationTabItem, myConstants.wizardValidationCriteria());
		tabbedWizard.addTab(ruleNameTabItem, myConstants.wizardRuleName());
		
		tabbedWizard.addHeightOffsettingWidget(headerPanel);
		
		add(tabbedWizard);

		ButtonWidget saveButton = createSaveButton();
		saveButton.addClickHandler(getSaveHandler());
		saveButton.setVisible(false);
		
		ButtonWidget cancelButton = createCancelButton();
		cancelButton.addClickHandler(getDefaultCancelHandler());
		cancelButton.setVisible(false);
		
		
		tabbedWizard.addCommonBottomWidget(saveButton);

		tabbedWizard.addCommonBottomWidget(cancelButton);

		tabbedWizard.show(ruleSet.isNew());

		this.registerMessageListener(tabbedWizard);
		
		if (ruleSet.isNew()
				|| ruleSet.getTitleFilter().getCriteriaMode()
						.equals(UiCriteriaMode.EPISODE)) {
			FieldSelector.initialize(CriteriaType.RULE_CONDITION_LHS,
					UiCriteriaMode.EPISODE);
			FieldSelector.initialize(CriteriaType.SEARCH_CONDITION_LHS,
					UiCriteriaMode.EPISODE);
		} else {
			FieldSelector.initialize(CriteriaType.RULE_CONDITION_LHS,
					UiCriteriaMode.SERIES);
			FieldSelector.initialize(CriteriaType.SEARCH_CONDITION_LHS,
					UiCriteriaMode.SERIES);
		}
		busyIndicator.hide();
	}
	
	/**
	 * Get the actions for this panel and put the UI together once complete
	 * since it is dependent on it.
	 */
	private void getActionLookupAsync() {
		UiActionServiceAsync actionService = GWT.create(UiActionService.class);
		actionService.getActions(Packages.VALIDATION,
				new NeptuneAsyncCallback<List<UIAction>>() {

					@Override
					public void onNeptuneFailure(Throwable caught) {
						Window.alert(caught == null ? "" : caught.getMessage());
					}

					@Override
					public void onNeptuneSuccess(List<UIAction> result) {
						ValidationRule.setCachedActions(result);
						populateUi();
					}
				});
	}

	private ClickHandler getSaveHandler() {
		return new ClickHandler() {
			public void onClick(ClickEvent event) {

				resetMessagePanel();
				if(!tabbedWizard.validateAllItems())
					return;

				List<UiRule> rules = panelValidation.getRules();
				
				if(siteSelectionPanel.containsGlobalAndSite() && failsContractValidate(rules)) {
					showInfoMessage(myConstants.failsContractValidation());
					return;
				}

				final ButtonWidget button = (ButtonWidget) event.getSource();
				// create rule set from various panels
				UIRuleSet ruleset = new UIRuleSet();
				ruleset.setId(ruleSet.getId());
				ruleset.setEnabled(ruleNamePanel.isEnabled());
				ruleset.setName(ruleNamePanel.getRuleName());
				if(siteSelectionPanel != null) {
					ruleset.setRunOnGlobal(siteSelectionPanel.isRunOnGlobal());
					ruleset.setSites(siteSelectionPanel.getSites()); 
				}
				ruleset.setPackageId(Packages.VALIDATION);
				ruleset.setTitleFilter(panelTitleFilter.getTitleFilter());
				ruleset.setRules(rules);
				
				button.setEnabled(false);
				
				rulesService.saveRuleSet(ruleset, new NeptuneAsyncCallback<Integer>(){
					@Override
					public void onNeptuneFailure(Throwable caught) {
						button.setEnabled(true);
						if(caught instanceof RuleServiceException) {
							List<String> messages = 
								ErrorMessageBuilder.getErrorMessages((RuleServiceException) caught);
							showErrorMessages(messages);
									
						} else if (caught instanceof UiRuleSetsAssocWJobExpception) {
							handleSiteJobAssoc((UiRuleSetsAssocWJobExpception)caught);
						}  else {
							Window.alert(caught == null ? "" : caught.getMessage());
						}
					}
					@Override
					public void onNeptuneSuccess(Integer result) {
						// go back to rules lisitng page
						resetMessagePanel();
						button.setEnabled(true);
						History.back();
					}
				});
			}
		};
	}

	private void setHeaderLabel() {
		String newRule = myConstants.newValidationRule();
		String ruleName = myConstants.validationRuleDetails() + " "
				+ ruleSet.getName();
		String headerString = ruleSet.getName().isEmpty() ? newRule : ruleName;
		setHeaderLabel(headerString);
	}
}
