package com.ericsson.cms.scheduling.ui.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class ExecutionsList extends Composite {
	private static final String TAB_CONTAINER_STYLE = "scheduler-tabContainer";

	private VerticalContainer mainPanel;
	private Map<String, String> info;
	private NeptuneSecurity security;
	private MessageArea messageArea = new MessageArea();
	private TabContainer tabContainer = new TabContainer();
	private List<ISchedulerTab> tabs = new ArrayList<ISchedulerTab>();
	
	public ExecutionsList(Map<String, String> info, NeptuneSecurity security) {
		this.info = info;
		this.security = security;
		mainPanel = new VerticalContainer();
		mainPanel.setSize("100%", "100%");
		initWidget(mainPanel);
		setWidgets();
	}
	
	public void setWidgets() {
		mainPanel.clear();
		mainPanel.add(new HeaderPanel("Past and Future Executions"));
		messageArea.reset();
		mainPanel.add(messageArea);
		tabContainer.addSelectionHandler(new SelectionHandler<Integer>() {
			@Override
			public void onSelection(SelectionEvent<Integer> event) {
				//TODO notify only the two tabs that got selected and unselected
				for(int i=0; i<tabs.size(); ++i) {
					tabs.get(i).setSelected(i == event.getSelectedItem());
				}
			}});
		tabContainer.addStyleName(TAB_CONTAINER_STYLE);
		tabContainer.clear();
		mainPanel.add(tabContainer);
		FutureExecutionsList futureExecutionsList = new FutureExecutionsList(info, security);
		futureExecutionsList.setMessageArea(messageArea);
		tabContainer.add(futureExecutionsList, "Next " + info.get("scheduler.executions.numHours") + " Hours");
		tabs.add(futureExecutionsList);
		PastExecutionsList pastExecutionsList = new PastExecutionsList(info);
		pastExecutionsList.setMessageArea(messageArea);
		tabContainer.add(pastExecutionsList, "Past " + info.get("scheduler.executions.numHours") + " Hours");
		tabs.add(pastExecutionsList);
		tabContainer.selectTab(0);
	}

	public void showFutureExecutions() {
		tabContainer.selectTab(0);
	}
	
	public void showPastExecutions() {
		tabContainer.selectTab(1);
	}
}
