package com.ericsson.cms.scheduling.ui.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.ericsson.cms.scheduling.ui.client.common.SchedulingConstants;
import com.ericsson.cms.scheduling.ui.client.portlet.upcomingjobs.UpcomingJobsPortlet;
import com.ericsson.cms.scheduling.ui.client.portlet.upcomingjobs.UpcomingJobsPortletConfig;
import com.google.gwt.core.client.GWT;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.application.Service;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import com.tandbergtv.neptune.widgettoolkit.client.component.Component;
import com.tandbergtv.neptune.widgettoolkit.client.component.ComponentBase;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventListenerRegistry;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventSink;
import com.tandbergtv.neptune.widgettoolkit.client.menu.GroupMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;

public class SchedulerComponent extends ComponentBase {

	private SchedulerView viewPanelFactory = new SchedulerView();
	private SchedulerExecutions executionsPanelFactory = new SchedulerExecutions();
	private SchedulingConstants constants = GWT.create(SchedulingConstants.class);
	
	@Override
	public String getDisplayName() {
		return "Scheduler";
	}

	@Override
	public String getName() {
		return constants.componentName();
	}

	@Override
	public void init(EventListenerRegistry eventListenerRegistry,
			EventSink eventSink, ServiceLoader serviceLoader,
			Map<String, String> info) {
		super.init(eventListenerRegistry, eventSink, serviceLoader, info);
		this.info = info;
	}

	@Override
	public List<PortletFactory> listPortlets(NeptuneSecurity security) {
		List<PortletFactory> portletFactories = new ArrayList<PortletFactory>();
		if (ClientAuthorizationManager.isAuthorized(Permissions.VIEW)) {
			// Upcoming Jobs Portlet
			UpcomingJobsPortletConfig ujConfig = new UpcomingJobsPortletConfig();
			ujConfig.setRefreshRateSecs(getRefreshRate(info));
			ujConfig.setRecordCount(getUpcomingJobsPortletRecordCount(info));
			Portlet ujPortlet = new UpcomingJobsPortlet(security, ujConfig);
			portletFactories.add(new SchedulerPortletFactory(ujPortlet, this));
		}
		return portletFactories;
	}

	@Override
	public <E extends Service> List<E> listServices(Class<E> clazz,
			NeptuneSecurity security) {
		return null;
	}

	@Override
	public List<MenuItemBase> listTabs(final NeptuneSecurity security) {
		List<MenuItemBase> tabs = new ArrayList<MenuItemBase>();

		/* Always add the group menu item */
		List<MenuItemBase> childMenuItems = new ArrayList<MenuItemBase>();
		GroupMenuItem rootMenuItem = new GroupMenuItem("Scheduler", childMenuItems);
		tabs.add(rootMenuItem);

		if (security.isUserInRole(Permissions.VIEW)) {
			viewPanelFactory.setSecurity(security);
			WidgetMenuItem viewMenuItem = new WidgetMenuItem("View", viewPanelFactory, viewPanelFactory.getAnchorChangeListener());
			childMenuItems.add(viewMenuItem);
			
			executionsPanelFactory.setInfo(info);
			executionsPanelFactory.setSecurity(security);
			WidgetMenuItem executionsMenuItem = new WidgetMenuItem("Executions", executionsPanelFactory, executionsPanelFactory.getAnchorChangeListener());
			childMenuItems.add(executionsMenuItem);
		}
		
		return tabs;
	}
	
	/**
	 * Get refresh rate from a config map
	 * @param info
	 * @return
	 */
	private int getRefreshRate(Map<String, String> info) {
		// Default value (1 min)
		int refreshRateSecs = 60;

		// Try getting refresh rate from a config file. If it is more than 1 min update default value.
		try {
			refreshRateSecs = Integer.parseInt(info.get("scheduler.portlets.upcomingjobs.refreshRate").trim());
		} 
		catch(Exception e) {
		}
		
		return refreshRateSecs;
	}

	/**
	 * Get record count for activity portlet from a config map
	 * @param info
	 * @return
	 */
	private int getUpcomingJobsPortletRecordCount(Map<String, String> info) {
		// Default value
		int recordCount = 10;

		// Try getting record count from a config file.
		try {
			recordCount = Integer.parseInt(info.get("scheduler.portlets.upcomingjobs.recordCount").trim());
		} 
		catch(Exception e) {
		}
		
		return recordCount;
	}
	
	/*
	 * Portlet Factory that maintains the single portlet instance created
	 */
	private static final class SchedulerPortletFactory implements PortletFactory {
		private final Portlet portlet;
		private final SchedulerComponent schedulerComponent;

		public SchedulerPortletFactory(Portlet portlet, SchedulerComponent schedulerComponent) {
			this.portlet = portlet;
			this.schedulerComponent = schedulerComponent;
		}

		@Override
		public Portlet getInstance() {
			return this.portlet;
		}

		@Override
		public void release(Portlet widget) {
		}

		@Override
		public Component getComponent() {
			return schedulerComponent;
		}
	}

}
