/**
 * File Name	:	SchedulerExecutions.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Aug 24, 2012 6:50:53 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.scheduling.ui.client;

import java.util.Map;

import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.WidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class SchedulerExecutions implements WidgetFactory {

	private NeptuneSecurity security;
	private Map<String, String> info;
	private SimpleContainer basePanel;
	
	/**
	 * 
	 */
	public SchedulerExecutions() {
		basePanel = new SimpleContainer();
		basePanel.setStyleName("scheduler-basePanel");
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.neptune.widgettoolkit.client.application.TypedWidgetFactory#getInstance()
	 */
	@Override
	public Widget getInstance() {
		return basePanel;
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.neptune.widgettoolkit.client.application.TypedWidgetFactory#release(com.google.gwt.user.client.ui.Widget)
	 */
	@Override
	public void release(Widget widget) {
		basePanel.clear();
	}

	/**
	 * @return the security
	 */
	public NeptuneSecurity getSecurity() {
		return security;
	}

	/**
	 * @param security the security to set
	 */
	public void setSecurity(NeptuneSecurity security) {
		this.security = security;
	}

	/**
	 * @return the info
	 */
	public Map<String, String> getInfo() {
		return info;
	}

	/**
	 * @param info the info to set
	 */
	public void setInfo(Map<String, String> info) {
		this.info = info;
	}

	public AnchorChangeListener getAnchorChangeListener() {
		return new AnchorChangeListener() {
			@Override
			public void anchorChanged(String anchor) {
				respondToAnchor(anchor);
			}
		};
	}

	private void respondToAnchor(String anchor) {
		ExecutionsList executionsList = new ExecutionsList(info, security);
		basePanel.setWidget(executionsList);
		if(anchor == null || anchor.trim().length() == 0) {
			executionsList.showFutureExecutions();
		}
		else if (anchor.startsWith("Past")) {
			executionsList.showPastExecutions();
		}
	}
}
