package com.ericsson.cms.scheduling.ui.client;

import java.util.Map;

import com.ericsson.cms.scheduling.ui.client.common.Common;
import com.ericsson.cms.scheduling.ui.client.detailsPage.ScheduleDetailsWidget;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.WidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

public class SchedulerView implements WidgetFactory {
	private static final String ANCHOR_ID_PREFIX = "?id=";
	private static final String ANCHOR_CREATE = "Create";
	private static final String ANCHOR_PARAM_ASSOCIATIONTYPE = "associationType";
	private static final String ANCHOR_PARAM_ASSOCIATIONID = "associationId";

	private NeptuneSecurity security;
	private SimpleContainer basePanel;
	
	public SchedulerView() {
		basePanel = new SimpleContainer();
		basePanel.setStyleName("scheduler-basePanel");
	}
	
	public void setSecurity(NeptuneSecurity security) {
		this.security = security;
	}

	@Override
	public Widget getInstance() {
		return basePanel;
	}

	@Override
	public void release(Widget widget) {
		basePanel.clear();
	}

	public AnchorChangeListener getAnchorChangeListener() {
		return new AnchorChangeListener() {
			@Override
			public void anchorChanged(String anchor) {
				respondToAnchor(anchor);
			}
		};
	}

	private void respondToAnchor(String anchor) {
		if(anchor == null || anchor.trim().length() == 0) {
			basePanel.setWidget(new SchedulesListWidget(security));
		} else if(anchor.startsWith(ANCHOR_ID_PREFIX)) {	//view or edit a schedule
			String idStr = anchor.substring(ANCHOR_ID_PREFIX.length());
			long id;
			try {
				id = Long.parseLong(idStr);
			} catch(Exception e) {
				Window.alert("Invalid id.");
				return;
			}
			basePanel.setWidget(new ScheduleDetailsWidget(id, security));
		} else if(anchor.startsWith(ANCHOR_CREATE)) {		//create a schedule
			String paramsStr = anchor.substring(ANCHOR_CREATE.length());
			String associationType = null;
			Long associationId = null;
			if(!Common.isBlank(paramsStr)) {
				try {
					paramsStr = paramsStr.trim();
					//ignore beginning '?' character
					paramsStr = paramsStr.substring(1);
					Map<String, String> params = Common.getParams(paramsStr);
					associationType = params.get(ANCHOR_PARAM_ASSOCIATIONTYPE);
					associationId = Long.parseLong(params.get(ANCHOR_PARAM_ASSOCIATIONID));
				} catch(Exception e) {
					Window.alert("Invalid URL");
					return;
				}
			}
			basePanel.setWidget(new ScheduleDetailsWidget(associationType, associationId, security));
		} else {
			Window.alert("Invalid URL");
		}
	}
}
