/**
 * File Name	:	SchedulesListUtils.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Jun 17, 2011 2:38:21 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.scheduling.ui.client;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class SchedulesListUtils {

	private static final int PIXELS_PER_CHARACTER = 9;
	private static final String ELIIPSIS_SUFFIX = "...";
	
	/**
	 * 
	 */
	public SchedulesListUtils() {
		super();
	}

	/**
	 * 
	 * @param associationDescription
	 * @param associationDescriptionCellWidth
	 * @return
	 */
	public static String getTruncatedAssociationDescription(
			String associationDescription, int associationDescriptionCellWidth) {
		String truncatedAssociationDescription = associationDescription;
		if ((associationDescription != null) && !associationDescription.trim().isEmpty()) {
			int associationDescriptionLength = associationDescription.trim().length();
			int numCharacters = associationDescriptionCellWidth / PIXELS_PER_CHARACTER;
			if ((associationDescriptionLength > 0)
					&& (numCharacters <= associationDescriptionLength)) {
				truncatedAssociationDescription = associationDescription.trim()
						.substring(0, numCharacters);
				truncatedAssociationDescription += ELIIPSIS_SUFFIX;
			}
		}
		return truncatedAssociationDescription;
	}
}
