package com.ericsson.cms.scheduling.ui.client.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import com.ericsson.cms.scheduling.ui.client.Action;
import com.ericsson.cms.scheduling.ui.client.IUISchedulerClient;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

public class Common {
	public static final String STYLE_SECTION_HEADING = "scheduler-sectionHeading";
	public static final String STYLE_REQUIRED = "scheduler-requiredMarker";
	public static final String STYLE_DISCLOSURE_CONTAINER = "scheduler-disclosureContainer";
	
	public static SchedulingConstants constants = GWT.create(SchedulingConstants.class);

	public static Widget getRequiredFieldName(String associatedWith) {
		HorizontalContainer container = new HorizontalContainer();
		LabelWidget requiredMarker = new LabelWidget("*");
		requiredMarker.setStyleName(STYLE_REQUIRED);
		container.add(requiredMarker);
		container.setCellWidth(requiredMarker, "10");
		container.add(new LabelWidget(associatedWith));
		return container;
	}
	
	public static String getFailureMessageSuffix(Throwable caught) {
		return " | " + constants.reason() + ": " + (caught!= null ? caught.getLocalizedMessage() : "");
	}

	public static boolean isBlank(String str) {
		return (str == null || str.trim().isEmpty());
	}
	
	public static Map<String, String> getParams(String anchor) {
		Map<String, String> paramsMap = new HashMap<String, String>();
		String[] paramsArray = anchor.split("&");
		for(String param : paramsArray) {
			String[] nameValueArray = param.split("=");
			paramsMap.put(nameValueArray[0], nameValueArray[1]);
		}
		return paramsMap;
	}

	public static boolean isUserAuthorized(String associatedEntityType, Action action) {
		IUISchedulerClient client = getUIClient(associatedEntityType);
		//no implementation == no objection
		if(client == null)
			return true;
		return client.isUserAuthorized(action);
	}
	
	public static IUISchedulerClient getUIClient(String associatedEntity) {
		Collection<IUISchedulerClient> clients = NeptuneApplication.getApplication().getServiceLoader().loadServices(IUISchedulerClient.class);
		if(clients != null) {
			for(IUISchedulerClient client : clients) {
				if(client.getName().equals(associatedEntity)) {
					return client;
				}
			}
		}
		return null;
	}
}
