/**
 * File Name	:	SchedulingConstants.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Feb 15, 2011 2:36:30 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.scheduling.ui.client.common;

import com.google.gwt.i18n.client.ConstantsWithLookup;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public interface SchedulingConstants extends ConstantsWithLookup {
	
	public static final int MAX_LENGTH_JOB_NAME = 300;
	public static final int MAX_VISIBLE_LENGTH_JOB_NAME = 50;
	
	String componentName();

	String onLabel();
	String atLabel();
	String everyLabel();
	String daysAtLabel();
	String everyLabel2();
	String weeksAtLabel();
	String daysLabel();
	String startDateLabel();
	String endDateLabel();
	String startDateRequiredFormat();
	String endDateRequiredFormat();
	String startDateCannotBeInThePast();
	String endDateCannotBeInThePast();
	String endDateBeforeStartDate();
	String startDateNotRequired();
	String endDateNotRequired();
	String scheduleTypeRequired();
	String timeRequiredFormat();
	String dateRequired();
	String dateRequiredFormat();
	String dateTimeRequiredFuture();
	String numDaysRequired();
	String numDaysRequiredInteger();
	String numDaysRequiredInteger2();
	String numDaysExceededMax();
	String numWeeksRequired();
	String numWeeksRequiredInteger();
	String numWeeksExceededMax();
	String metadataFieldRequired();
	
	@DefaultIntValue(MAX_LENGTH_JOB_NAME)
	int maxLengthJobName();
	@DefaultIntValue(MAX_VISIBLE_LENGTH_JOB_NAME)
	int maxVisibleLengthJobName();
	
	String jobNameIsRequired();
	String jobNameCannotBeLonger();
	String jobNameIsAlredayInUse();
	
	String noScheduleSelected();
	
	String headingCreate();
	String headingEdit();
	String headingView();
	String name();
	String association();
	String associatedWith();
	String scheduleInformation();
	String associatedWithTitles();
	String yes();
	String no();
	String scheduleRule();
	String startDate();
	String endDate();
	String executeWorkOrder();
	String priority();
	String template();
	String jobParameters();
	
	String reason();

	String priorityLowest();
	String priorityLow();
	String priorityNormal();
	String priorityHigh();
	String priorityHighest();
	String priorityAssignByRules();

	String columnLabelActive();
	String columnLabelId();
	String columnLabelName();
	String columnLabelAssociation();
	String columnLabelTemplateName();
	String columnLabelJobScheduleRule();

	String buttonLabelCreate();
	String buttonLabelSave();
	String buttonLabelCancel();
	String buttonLabelDelete();
	String buttonLabelActivate();
	String buttonLabelInactivate();
	String buttonLabelRunNow();
	String buttonLabelDissociate();

	String columnLabelEnabled();
	String columnLabelExecutionTime();

	String buttonLabelEnable();
	String buttonLabelDisable();
	
	String errInvalidSchedule();
	String errDefault();

	String confirmMultipleDelete();
	
	String staleRecordsLegend();

}
