package com.ericsson.cms.scheduling.ui.client.data;

import java.util.Date;

import com.google.gwt.user.client.rpc.IsSerializable;

public class UIExecutionRecord implements IsSerializable {
	private Long jobId;
	private String jobName;
	private String associatedEntityType;
	private String association;
	private Date executionTime;
	private String executionTimeString;
	private boolean enabled;
	/*
	 * This flag is applicable only for past execution record.
	 * Extending this class for Past and Future separately would be ideal.
	 * Because, this is the only property that is different and it is UI code,
	 *  I took this time-saving approach.
	 */
	private boolean stale;
	private Long woJobId;
	private String historyToken;

	/**
	 * @return the jobId
	 */
	public Long getJobId() {
		return jobId;
	}
	/**
	 * @param jobId the jobId to set
	 */
	public void setJobId(Long jobId) {
		this.jobId = jobId;
	}
	/**
	 * @return the jobName
	 */
	public String getJobName() {
		return jobName;
	}
	/**
	 * @param jobName the jobName to set
	 */
	public void setJobName(String jobName) {
		this.jobName = jobName;
	}
	/**
	 * @return the associatedEntityType
	 */
	public String getAssociatedEntityType() {
		return associatedEntityType;
	}
	/**
	 * @param associatedEntityType the associatedEntityType to set
	 */
	public void setAssociatedEntityType(String associatedEntityType) {
		this.associatedEntityType = associatedEntityType;
	}
	/**
	 * @return the executionTime
	 */
	public Date getExecutionTime() {
		return executionTime;
	}
	/**
	 * @param executionTime the executionTime to set
	 */
	public void setExecutionTime(Date executionTime) {
		this.executionTime = executionTime;
	}
	/**
	 * @return the executionTimeString
	 */
	public String getExecutionTimeString() {
		return executionTimeString;
	}
	/**
	 * @return the association
	 */
	public String getAssociation() {
		return association;
	}
	/**
	 * @param association the association to set
	 */
	public void setAssociation(String association) {
		this.association = association;
	}
	/**
	 * @param executionTimeString the executionTimeString to set
	 */
	public void setExecutionTimeString(String executionTimeString) {
		this.executionTimeString = executionTimeString;
	}
	/**
	 * @return the enabled
	 */
	public boolean isEnabled() {
		return enabled;
	}
	/**
	 * @param enabled the enabled to set
	 */
	public void setEnabled(boolean enabled) {
		this.enabled = enabled;
	}
	
	/**
	 * @return the stale
	 */
	public boolean isStale() {
		return stale;
	}
	/**
	 * @param stale the stale to set
	 */
	public void setStale(boolean stale) {
		this.stale = stale;
	}
	/**
	 * @return the woJobId
	 */
	public Long getWoJobId() {
		return woJobId;
	}
	
	/**
	 * @param woJobId the woJobId to set
	 */
	public void setWoJobId(Long woJobId) {
		this.woJobId = woJobId;
	}
		
	/**
	 * @return the historyToken
	 */
	public String getHistoryToken() {
		return historyToken;
	}
	/**
	 * @param historyToken the historyToken to set
	 */
	public void setHistoryToken(String historyToken) {
		this.historyToken = historyToken;
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((executionTime == null) ? 0 : executionTime.hashCode());
		result = prime * result + ((jobId == null) ? 0 : jobId.hashCode());
		return result;
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (!(obj instanceof UIExecutionRecord))
			return false;
		UIExecutionRecord other = (UIExecutionRecord) obj;
		if (executionTime == null) {
			if (other.executionTime != null)
				return false;
		} else if (!executionTime.equals(other.executionTime))
			return false;
		if (jobId == null) {
			if (other.jobId != null)
				return false;
		} else if (!jobId.equals(other.jobId))
			return false;
		return true;
	}
}
