package com.ericsson.cms.scheduling.ui.client.detailsPage;

import java.util.List;

import com.ericsson.cms.scheduling.ui.client.common.Common;
import com.ericsson.cms.scheduling.ui.client.common.SchedulingConstants;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleInfo;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleType;
import com.ericsson.cms.scheduling.ui.client.data.UiMetadataTree;
import com.ericsson.cms.scheduling.ui.client.service.IUISchedulerService;
import com.ericsson.cms.scheduling.ui.client.service.IUISchedulerServiceAsync;
import com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidget2;
import com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetConfig;
import com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetFactory;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.RadioButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.MultiTaskBusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class ScheduleInfoWidget extends Composite {
	public static interface ValueChangeListener {
		void valueChanged(boolean associatedWithTitles);
	}
	
	private IUISchedulerServiceAsync service = GWT.create(IUISchedulerService.class);
	private SchedulingConstants constants = GWT.create(SchedulingConstants.class);

	private UiMetadataTree ruleMetadataTree;
	private ValueChangeListener listener;
	
	private MultiTaskBusyIndicator busyIndicator = new MultiTaskBusyIndicator();
	
	private RadioButtonWidget yesRadioButton, noRadioButton;
	private SimpleContainer schedulingWidgetContainer;
	private SchedulingWidget2 schedulingWidget;

	public ScheduleInfoWidget(String entityType, final ScheduleInfo scheduleInfo) {
		DisclosureContainer disclosurePanel = new RoundedDisclosureContainer(constants.scheduleInformation(),true);
		disclosurePanel.addStyleName(Common.STYLE_DISCLOSURE_CONTAINER);
		
		VerticalContainer sectionContainer = new VerticalContainer();
		disclosurePanel.add(sectionContainer);
		
		HorizontalContainer associateWithTitlesPanel = new HorizontalContainer();
		associateWithTitlesPanel.add(Common.getRequiredFieldName(constants.associatedWithTitles()));
		
		LabelWidget spacerWidget = new LabelWidget();
		associateWithTitlesPanel.add(spacerWidget);
		associateWithTitlesPanel.setCellWidth(spacerWidget, "10");
		
		yesRadioButton = new RadioButtonWidget("associateWithTitles");
		yesRadioButton.setText(constants.yes());
		yesRadioButton.addValueChangeHandler(new ValueChangeHandler<Boolean>() {
			@Override
			public void onValueChange(ValueChangeEvent<Boolean> event) {
				if(yesRadioButton.getValue()) {
					updateSchedulingWidget(true, null);
					if(listener != null)
						listener.valueChanged(true);
				}
			}
		});
		associateWithTitlesPanel.add(yesRadioButton);
		
		spacerWidget = new LabelWidget();
		associateWithTitlesPanel.add(spacerWidget);
		associateWithTitlesPanel.setCellWidth(spacerWidget, "10");
		
		noRadioButton = new RadioButtonWidget("associateWithTitles");
		noRadioButton.setText(constants.no());
		noRadioButton.addValueChangeHandler(new ValueChangeHandler<Boolean>() {
			@Override
			public void onValueChange(ValueChangeEvent<Boolean> event) {
				if(noRadioButton.getValue()) {
					updateSchedulingWidget(false, null);
					if(listener != null)
						listener.valueChanged(false);
				}
			}
		});
		associateWithTitlesPanel.add(noRadioButton);
		
		sectionContainer.add(associateWithTitlesPanel);
		
		sectionContainer.add(Common.getRequiredFieldName(constants.scheduleRule()));
		
		schedulingWidgetContainer = new SimpleContainer();
		sectionContainer.add(schedulingWidgetContainer);
		
		loadMetadataTree(entityType, new Command() {
			@Override
			public void execute() {
				if(scheduleInfo == null) {
					yesRadioButton.setValue(true);
					updateSchedulingWidget(true, null);
				} else {
					ScheduleType type = scheduleInfo.getScheduleType();
					if(type == ScheduleType.N_DAYS_FROM_METADATA) {
						yesRadioButton.setValue(true);
						updateSchedulingWidget(true, scheduleInfo);
					} else {
						noRadioButton.setValue(true);
						updateSchedulingWidget(false, scheduleInfo);
					}
				}
			}
		});
		
		initWidget(disclosurePanel);
	}
	
	private void loadMetadataTree(final String entityType, final Command command) {
		busyIndicator.center();
		service.getRuleMetadataTree(entityType, new NeptuneAsyncCallback<UiMetadataTree>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				busyIndicator.hide();
				Window.alert("Failed to get rule metadata tree for entity type:" + entityType
						+ Common.getFailureMessageSuffix(caught));
			}

			@Override
			public void onNeptuneSuccess(UiMetadataTree result) {
				ruleMetadataTree = result;
				command.execute();
				busyIndicator.hide();
			}
		});
	}
	
	private void updateSchedulingWidget(boolean associatedWithTitles, ScheduleInfo scheduleInfo) {
		SchedulingWidgetConfig widgetConfig = new SchedulingWidgetConfig();
		widgetConfig.setShowOnDateRow(!associatedWithTitles);
		widgetConfig.setShowEveryNDaysRow(!associatedWithTitles);
		widgetConfig.setShowOnDayEveryNWeeksRow(!associatedWithTitles);
		widgetConfig.setShowNDaysFromMetadataRow(associatedWithTitles);
		schedulingWidget = SchedulingWidgetFactory.create2(widgetConfig);
		schedulingWidget.setScheduleInfo(scheduleInfo);
		schedulingWidget.setMetadataTree(ruleMetadataTree);
		schedulingWidgetContainer.setWidget(schedulingWidget);
	}
	
	public void setValueChangeListener(ValueChangeListener listener) {
		this.listener = listener;
	}

	public void setEntityType(String entityType) {
		loadMetadataTree(entityType, new Command() {
			@Override
			public void execute() {
				updateSchedulingWidget(yesRadioButton.getValue(), null);
			}
		});
	}
	
	public List<String> validate() {
		return schedulingWidget.validate();
	}
	
	public ScheduleInfo getScheduleInfo() {
		return schedulingWidget.getScheduleInfo();
	}
	
	@Override
	protected void onUnload() {
		super.onUnload();
		busyIndicator.hide();
	}
}
