/**
 * File Name	:	UpcomingJobsPortlet.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Mar 30, 2011 5:39:43 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.scheduling.ui.client.portlet.upcomingjobs;

import java.util.List;

import com.ericsson.cms.scheduling.ui.client.Permissions;
import com.ericsson.cms.scheduling.ui.client.data.UIExecutionRecord;
import com.ericsson.cms.scheduling.ui.client.portlet.PortletConstants;
import com.ericsson.cms.scheduling.ui.client.service.IUISchedulerService;
import com.ericsson.cms.scheduling.ui.client.service.IUISchedulerServiceAsync;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Timer;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachHandler;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class UpcomingJobsPortlet extends Portlet {
	private UpcomingJobsPortletConfig config;
	private NeptuneSecurity security;
	private PortletConstants constants;
	private Timer refreshTimer;
	
	private IUISchedulerServiceAsync service;
	
	private FlexTableContainer table;

	public UpcomingJobsPortlet(NeptuneSecurity security,
			UpcomingJobsPortletConfig config) {
		super("UPCOMINGJOBS");
		this.security = security;
		this.config = config;
		
		service = GWT.create(IUISchedulerService.class);
		constants = GWT.create(PortletConstants.class);
		
		setTitle(constants.ujPortletHeader());
		setDisplayName(constants.ujPortletHeader());
		table = new FlexTableContainer();
		table.setCellSpacing(0);
		table.setStyleName("portletTable");
		add(table);
		
		this.refreshTimer = new Timer() {
			@Override
			public void run() {
				reload();
			}
		};

		EventHandler handler = new EventHandler();
		addDocumentAttachHandler(handler);
		addDocumentDetachHandler(handler);
	}

	private void reload() {
		service.getNextNFutureExecutions(config.getRecordCount(), new NeptuneAsyncCallback<List<UIExecutionRecord>>() {

			@Override
			public void onNeptuneFailure(Throwable caught) {
				// Clear table
				table.removeAllRows();
			}

			@Override
			public void onNeptuneSuccess(List<UIExecutionRecord> result) {
				// Clear table
				table.removeAllRows();
				
				if ((result != null) && (!result.isEmpty())) {
					// Create table header
					createTableHeader(table);
					for(int row = 0; row < result.size(); row++) {
						UIExecutionRecord uiExecutionRecord = result.get(row);
						// Table header has row=0. Use row+1.
						createTableRecord(table, row+1, uiExecutionRecord);
					}
				}
				update();
			}
			
		});
	}
	
	private void createTableHeader(FlexTableContainer table) {
		int row = 0;
		int col = 0;

		// Job Name
		table.setWidget(row, col, new LabelWidget(constants.jobName()));
		table.getCellFormatter().setStyleName(row, col, "portlet-tableHeader");

		++col;
		
		// Job Kickoff time
		table.setWidget(row, col, new LabelWidget(constants.jobKickOffTime()));
		table.getCellFormatter().setStyleName(row, col, "portlet-tableHeader");
		
	}
	
	private void createTableRecord(FlexTableContainer table, int row, UIExecutionRecord uiExecutionRecord) {
		int colIndex = 0;

		// Job Name
		String jobName = uiExecutionRecord.getJobName();
		if ((uiExecutionRecord.getHistoryToken() != null) && (security.isUserInRole(Permissions.VIEW))) {
			table.setWidget(row, colIndex, new HyperlinkWidget(jobName,
					uiExecutionRecord.getHistoryToken()));
		} else {
			table.setWidget(row, colIndex, new LabelWidget(jobName));
		}
		table.getCellFormatter().setStyleName(row, colIndex,
				"portlet-table-text");
		
		++colIndex;

		// Job Kickoff Time
		table.setWidget(row, colIndex, new LabelWidget(uiExecutionRecord.getExecutionTimeString()));
		table.getCellFormatter().setStyleName(row, colIndex, "portlet-table-text");
	}
	
	/*
	 * Event Handling
	 */
	private final class EventHandler implements DocumentAttachHandler, DocumentDetachHandler {
		@Override
		public void onAttach(DocumentAttachEvent event) {
			refreshTimer.scheduleRepeating(config.getRefreshRateSecs() * 1000);
			reload();
		}

		@Override
		public void onDetach(DocumentDetachEvent event) {
			refreshTimer.cancel();
		}
	}
	
}
