package com.ericsson.cms.scheduling.ui.client.service;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.ericsson.cms.scheduling.ui.client.data.SchedulesListRow;
import com.ericsson.cms.scheduling.ui.client.data.UIExecutionRecord;
import com.ericsson.cms.scheduling.ui.client.data.UITemplateVariable;
import com.ericsson.cms.scheduling.ui.client.data.UIWOJob;
import com.ericsson.cms.scheduling.ui.client.data.UiMetadataTree;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

@RemoteServiceRelativePath("service/scheduler/IUISchedulerService")
public interface IUISchedulerService extends RemoteService {
	UIWOJob getWOJob(long id);

	UIWOJob getWOJobByJobId(long jobId) throws NeptuneException;

	List<SchedulesListRow> getAllJobs();

	List<UIWOJob> getSchedulesByAssociatedEntity(String entityType, long entityId);
	
	Map<String, String> getAllEntityTypes();

	Map<Long, String> getEntitiesOfType(String entityType) throws NeptuneException;

	List<String> getTemplates(boolean associatedWithTitles);

	List<UITemplateVariable> getStartVariablesForTemplate(String templateName, boolean associatedWithTitles);
	
	UiMetadataTree getRuleMetadataTree(String entityType);
	
	UiMetadataTree getWOMappingMetadataTree(String entityType, boolean associatedWithTitles);
	
	UIWOJob save(UIWOJob woJob) throws NeptuneException;
	
	void delete(Set<Long> woJobIds);
	
	void dissociate(Set<Long> woJobIds, long entityId);
	
	void setActive(Set<Long> woJobIds, boolean active);

	void runNow(Set<Long> jobIds);
	
	List<UIExecutionRecord> getPastExecutions();

	List<UIExecutionRecord> getFutureExecutions();
	
	List<UIExecutionRecord> getNextNFutureExecutions(int count);
	
	void setFutureExecutionsEnabled(Set<UIExecutionRecord> executions, boolean enabled);
	
	/**
	 * Check if the currently logged in user is associated with SELF Partner.
	 * 
	 * @return
	 */
	boolean isSelfPartnerAssociated();
	
	/**
	 * Check if a job with given <code>jobName</code> already exists.
	 * 
	 * @return
	 */
	boolean isJobNameAlreadyUsed(String jobName);
}
