package com.ericsson.cms.scheduling.ui.client.service;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.ericsson.cms.scheduling.ui.client.data.SchedulesListRow;
import com.ericsson.cms.scheduling.ui.client.data.UIExecutionRecord;
import com.ericsson.cms.scheduling.ui.client.data.UITemplateVariable;
import com.ericsson.cms.scheduling.ui.client.data.UIWOJob;
import com.ericsson.cms.scheduling.ui.client.data.UiMetadataTree;
import com.google.gwt.user.client.rpc.AsyncCallback;

public interface IUISchedulerServiceAsync {
	void getWOJob(long id, AsyncCallback<UIWOJob> callback);
	void getWOJobByJobId(long jobId, AsyncCallback<UIWOJob> callback);
	void getAllJobs(AsyncCallback<List<SchedulesListRow>> callback);
	void getSchedulesByAssociatedEntity(String entityType, long entityId, AsyncCallback<List<UIWOJob>> callback);
	void getAllEntityTypes(AsyncCallback<Map<String, String>> callback);
	void getEntitiesOfType(String entityType, AsyncCallback<Map<Long, String>> callback);
	void getTemplates(boolean associatedWithTitles, AsyncCallback<List<String>> callback);
	void getStartVariablesForTemplate(String templateName, boolean associatedWithTitles,
			AsyncCallback<List<UITemplateVariable>> callback);
	void getRuleMetadataTree(String entityType, AsyncCallback<UiMetadataTree> callback);
	void getWOMappingMetadataTree(String entityType, boolean associatedWithTitles,
			AsyncCallback<UiMetadataTree> callback);
	void save(UIWOJob woJob, AsyncCallback<UIWOJob> callback);
	void delete(Set<Long> woJobIds, AsyncCallback<Void> callback);
	void dissociate(Set<Long> woJobIds, long entityId, AsyncCallback<Void> callback);
	void setActive(Set<Long> woJobIds, boolean active, AsyncCallback<Void> callback);
	void runNow(Set<Long> jobIds, AsyncCallback<Void> callback);
	void getPastExecutions(AsyncCallback<List<UIExecutionRecord>> callback);
	void getFutureExecutions(AsyncCallback<List<UIExecutionRecord>> callback);
	void getNextNFutureExecutions(int count, AsyncCallback<List<UIExecutionRecord>> callback);
	void setFutureExecutionsEnabled(Set<UIExecutionRecord> executions, boolean enabled, AsyncCallback<Void> callback);
	void isSelfPartnerAssociated(AsyncCallback<Boolean> callback);
	void isJobNameAlreadyUsed(String jobName, AsyncCallback<Boolean> callback);
}
