/**
 * File Name	:	EveryNDaysRow.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Feb 8, 2011 7:28:01 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.scheduling.ui.client.widgets;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.scheduling.ui.client.common.SchedulingConstants;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleInfo;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class EveryNDaysRow extends SchedulingWidgetRow {

	/**
	 * If you change this, also update the SchedulingConstants.numDaysRequiredInteger constant. 
	 */
	private static final int MIN_N_DAYS = 1;
	/**
	 * If you change this, also update the SchedulingConstants.numDaysExceededMax constant. 
	 * 11574 days is based on the largest number that can be stored in Quartz's column 
	 * QRTZ_SIMPLE_TRIGGERS.REPEAT_INTERVAL which is of type Number(12, 0). 
	 *  
	 */
	private static final int MAX_N_DAYS = 11574;
	
	Label everyLabel;
	TextBox nDaysBox;
	Label daysAtLabel;
	TimeEntryWidget timeEntryWidget;

	static SchedulingConstants schedulingConstants = (SchedulingConstants) GWT.create(SchedulingConstants.class);

	public EveryNDaysRow() {
		super();
		
		Label everyLabel = new Label(schedulingConstants.everyLabel());
		this.add(everyLabel);
		nDaysBox = new TextBox();
		nDaysBox.setVisibleLength(4);
		this.add(nDaysBox);
		daysAtLabel = new Label(schedulingConstants.daysAtLabel());
		this.add(daysAtLabel);
		timeEntryWidget = new TimeEntryWidget();
		this.add(timeEntryWidget);

	}
	
	/* (non-Javadoc)
	 * @see com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetRow#getScheduleType()
	 */
	@Override
	public ScheduleType getScheduleType() {
		return ScheduleType.EVERY_N_DAYS;
	}

	@Override
	public ScheduleInfo getScheduleInfo() {
		ScheduleInfo scheduleInfo = new ScheduleInfo();
		
		scheduleInfo.setScheduleType(getScheduleType());
		scheduleInfo.setnDays(Integer.parseInt(nDaysBox.getText()));
		scheduleInfo.setSpecificTime(timeEntryWidget.getTime());
		
		return scheduleInfo;
	}
	
	@Override
	public void setScheduleInfo(ScheduleInfo scheduleInfo) {
		nDaysBox.setText(String.valueOf(scheduleInfo.getnDays()));
		timeEntryWidget.setTime(scheduleInfo.getSpecificTime());
	}

	/* (non-Javadoc)
	 * @see com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetRow#reset()
	 */
	@Override
	public void reset() {
		super.reset();
		
		nDaysBox.setText(null);
		timeEntryWidget.reset();
	}

	@Override
	public List<String> validate() {
		List<String> validationMessages = new ArrayList<String>();
		
		String nDaysBoxText = nDaysBox.getText();
		if ((nDaysBoxText == null) || (nDaysBoxText.isEmpty())) {
			validationMessages.add(schedulingConstants.numDaysRequired());
		}
		else {
			try {
				int numDays = Integer.parseInt(nDaysBoxText);
				if (numDays < MIN_N_DAYS) {
					validationMessages.add(schedulingConstants.numDaysRequiredInteger());					
				}
				if (numDays > MAX_N_DAYS) {
					validationMessages.add(schedulingConstants.numDaysExceededMax());					
				}
			} catch (NumberFormatException e) {
				validationMessages.add(schedulingConstants.numDaysRequiredInteger());
			}
		}
		
		validationMessages.addAll(timeEntryWidget.validate());
		
		return validationMessages;
	}

	/* (non-Javadoc)
	 * @see com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetRow#setEnabled(boolean)
	 */
	@Override
	public void setEnabled(boolean enabled) {
		super.setEnabled(enabled);
		
		nDaysBox.setEnabled(enabled);
		timeEntryWidget.setEnabled(enabled);
	}

	public static String getScheduleInfoString(ScheduleInfo scheduleInfo) {
		String scheduleInfoString = "";
		
		if (scheduleInfo != null) {
			scheduleInfoString = schedulingConstants.everyLabel();
			scheduleInfoString += " ";
			scheduleInfoString += scheduleInfo.getnDays();
			scheduleInfoString += " ";
			scheduleInfoString += schedulingConstants.daysAtLabel();
			scheduleInfoString += " ";
			scheduleInfoString += scheduleInfo.getSpecificTime();
		}
		
		return scheduleInfoString;
	}

}
