/**
 * File Name	:	MetadatFieldWidget.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Feb 17, 2011 12:55:08 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.scheduling.ui.client.widgets;

import com.ericsson.cms.scheduling.ui.client.data.UiMetadataTree;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class MetadataFieldWidget extends HorizontalContainer {

	private static final String FULL_DISPLAY_NAME_PREFIX = "$";
	private static final String FULL_NAME_PREFIX = "$";

	String value;
	TextBoxWidget textBox = new TextBoxWidget();
	UiMetadataTree metadataTree;
	MetadataSelector metadataSelector;
	boolean editable = false;
	
	/**
	 * 
	 */
	public MetadataFieldWidget() {
		super();

		add(textBox);
		textBox.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				String selectedFullDispalyName = null;
				String text = textBox.getText();
				if (text.startsWith(FULL_DISPLAY_NAME_PREFIX)) {
					selectedFullDispalyName = text
							.substring(FULL_DISPLAY_NAME_PREFIX.length());
				}
				metadataSelector = new MetadataSelector(metadataTree, !editable, selectedFullDispalyName);
				metadataSelector.addSelectionHandler(getSelectionHandler());
				int x = textBox.getAbsoluteLeft();
				int y = textBox.getAbsoluteTop();
				if (editable) {
					y = textBox.getAbsoluteTop() + textBox.getOffsetHeight();
				}
				metadataSelector.show(x, y);
				if (editable) {
					textBox.selectAll();
					textBox.setFocus(true);
				}
			}
			
			private SelectionHandler<UiMetadataTree> getSelectionHandler() {
				return new SelectionHandler<UiMetadataTree>() {

					@Override
					public void onSelection(SelectionEvent<UiMetadataTree> event) {
						UiMetadataTree metadataNode = event.getSelectedItem();
						textBox.setText(FULL_DISPLAY_NAME_PREFIX
								+ metadataNode.getFullDisplayName());
						value = FULL_NAME_PREFIX + metadataNode.getFullName();
					}
					
				};
			}
		});

	}
	
	public MetadataFieldWidget(UiMetadataTree tree) {
		this();
		
		setMetadataTree(tree);
	}


	/**
	 * @param length
	 * @see com.google.gwt.user.client.ui.TextBox#setVisibleLength(int)
	 */
	public void setVisibleLength(int length) {
		textBox.setVisibleLength(length);
	}

	/**
	 * @return
	 * @see com.google.gwt.user.client.ui.TextBoxBase#getText()
	 */
	public String getText() {
		return textBox.getText();
	}

	/**
	 * @param text
	 * @see com.google.gwt.user.client.ui.TextBoxBase#setText(java.lang.String)
	 */
	public void setText(String text) {
		textBox.setText(text);
	}

	/**
	 * @return the metadataTree
	 */
	public UiMetadataTree getMetadataTree() {
		return metadataTree;
	}

	/**
	 * @param metadataTree the metadataTree to set
	 */
	public void setMetadataTree(UiMetadataTree tree) {
		this.metadataTree = tree;
		resolveTextBox(this.value);
	}
	
	public void setEditable(boolean editable) {
		this.editable = editable;
	}

	/**
	 * @return the value
	 */
	public String getValue() {
		String text = textBox.getText();
		if ((text != null) && (text.startsWith(FULL_DISPLAY_NAME_PREFIX))) {
			return value;
		}
		else {
			return text;
		}
	}

	/**
	 * @param value the value to set
	 */
	public void setValue(String value) {
		this.value = value;
		resolveTextBox(value);
	}
	
	/**
	 * 
	 * @param enabled
	 */
	public void setEnabled(boolean enabled) {
		textBox.setEnabled(enabled);
	}

	private void resolveTextBox(String value) {
		String text = value;
		if ((value != null) && (value.startsWith(FULL_NAME_PREFIX))) {
			text = resolveDisplayName();
		}
		setText(text);
	}
	
	private String resolveDisplayName() {
		String fullDisplayName = null;
		
		if ((metadataTree != null) && (value != null)) {
			String fullName = value;
			if (fullName.startsWith(FULL_NAME_PREFIX)) {
				fullName = fullName
						.substring(FULL_NAME_PREFIX.length());
			}
			UiMetadataTree foundNode = findNodeByFullName(fullName);
			if (foundNode != null) {
				fullDisplayName = foundNode.getFullDisplayName();
			}
		}
		
		if (fullDisplayName != null) {
			fullDisplayName = FULL_DISPLAY_NAME_PREFIX + fullDisplayName;
		}
		
		return fullDisplayName;
	}
	
	private UiMetadataTree findNodeByFullName(String fullName) {
		UiMetadataTree foundNode = null;

		foundNode = findNodeByFullName(metadataTree, fullName);
		
		return foundNode;
	}
	
	private UiMetadataTree findNodeByFullName(UiMetadataTree uiMetadataTree, String fullName) {
		UiMetadataTree foundNode = null;
		if (uiMetadataTree != null) {
			for (UiMetadataTree node : uiMetadataTree.getChildren()) {
				if (fullName.equals(node.getFullName())) {
					foundNode = node;
					break;
				}
				foundNode = findNodeByFullName(node, fullName);
				if (foundNode != null) {
					break;
				}
			}
		}
		
		return foundNode;
	}

}
