/**
 * File Name	:	MetadataSelector.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Feb 22, 2011 4:48:46 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.scheduling.ui.client.widgets;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.scheduling.ui.client.data.UiMetadataTree;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TreeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.PopupContainer;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class MetadataSelector extends PopupContainer implements HasSelectionHandlers<UiMetadataTree> {
	private static final int BOX_HEIGHT_INT = 200;

	private ScrollPanel scrollPanel = new ScrollPanel();
	private Tree tree;

	private int currentPosition = 0;
	private Timer timer;
	private List<HandlerRegistration> currentHackHandlers = new ArrayList<HandlerRegistration>();

	public MetadataSelector(UiMetadataTree metadataTree, boolean modal) {
		super(true, modal);
		
		timer = new Timer() {
			public void run() {
				scrollPanel.setScrollPosition(currentPosition);
			}
		};

		buildTree(metadataTree);
		tree.addSelectionHandler(new SelectionHandler<TreeItem>() {

			@Override
			public void onSelection(SelectionEvent<TreeItem> event) {
				TreeItem treeItem = event.getSelectedItem();
				if (treeItem.getUserObject() != null) {
					UiMetadataTree metadataTree = (UiMetadataTree) treeItem.getUserObject();
					List<UiMetadataTree> childrenUiMetadataTree = metadataTree.getChildren();
					if ((childrenUiMetadataTree == null) || (childrenUiMetadataTree.size() < 1)) {
						SelectionEvent
								.fire(MetadataSelector.this, metadataTree);
						hide();
					}
				}
			}
			
		});
		scrollPanel.setSize("250px", "200px");
		scrollPanel.setWidget(tree);
		addScrollHack(tree);
		setWidget(scrollPanel);
	}
	
	public MetadataSelector(UiMetadataTree metadataTree, boolean modal, String fullDisplayName) {
		this(metadataTree, modal);
		if ((fullDisplayName != null) && !(fullDisplayName.isEmpty())) {
			setSelectedItem(fullDisplayName);
		}
	}
	
	public void setSelectedItem(String fullDisplayName) {
		for (int i=0; i<tree.getItemCount(); i++) {
			TreeItem item = tree.getItem(i);
			boolean itemSelected = setSelectedItem(fullDisplayName, item);
			if (itemSelected) {
				break;
			}
		}
	}
	
	public boolean setSelectedItem(String fullDisplayName, TreeItem item) {
		boolean itemSelected = false;
		if (item.getUserObject() != null) {
			UiMetadataTree metadataTree = (UiMetadataTree) item.getUserObject();
			String mtFullDisplayName = metadataTree.getFullDisplayName();
			if ((fullDisplayName != null) && (fullDisplayName.equals(mtFullDisplayName))) {
				itemSelected = true;
				tree.setSelectedItem(item);
				tree.ensureSelectedItemVisible();
			}
		}
		if (!itemSelected) {
			for (int i=0; i<item.getChildCount(); i++) {
				TreeItem childItem = item.getChild(i);
				itemSelected = setSelectedItem(fullDisplayName, childItem);
				if (itemSelected) {
					break;
				}
			}
		}
			
		return itemSelected;
	}
	
	private void buildTree(UiMetadataTree metadataTree) {
		tree = new TreeWidget();
		if (metadataTree != null) {
			if (metadataTree.getName().isEmpty()) {
				for (UiMetadataTree node : metadataTree.getChildren()) {
					TreeItem item = new TreeItem(node.getDisplayName());
					item.setUserObject(node);
					addNodes(item, node.getChildren());
					tree.addItem(item);
				}
			} else {
				TreeItem item = new TreeItem(metadataTree.getDisplayName());
				item.setUserObject(metadataTree);
				addNodes(item, metadataTree.getChildren());
				tree.addItem(item);
			}
		}
	}
	
	private void addNodes(TreeItem item, List<UiMetadataTree> nodes) {
		for (UiMetadataTree node : nodes) {
			TreeItem childItem = new TreeItem(node.getDisplayName());
			childItem.setUserObject(node);
			addNodes(childItem, node.getChildren());
			item.addItem(childItem);
		}
	}
	
	public void show(final int x, final int y) {
		setPopupPositionAndShow(new PopupPanel.PositionCallback() {
			public void setPosition(int offsetWidth, int offsetHeight) {
				int height = Window.getClientHeight();
				int yOffset = 0;
				if (y + BOX_HEIGHT_INT > height)
					yOffset = BOX_HEIGHT_INT + 30;
				setPopupPosition(x, y - yOffset);
			}
		});
	}

	@Override
	public HandlerRegistration addSelectionHandler(
			SelectionHandler<UiMetadataTree> handler) {
		return addHandler(handler, SelectionEvent.getType());
	}
	
	/*
	 * this is to fix that bloody hack that moves the wheel back and forth
	 */
	private void addScrollHack(Tree currentTree) {
		for (HandlerRegistration r : currentHackHandlers) {
			r.removeHandler();
		}
		currentHackHandlers.clear();

		currentHackHandlers.add(currentTree
				.addMouseDownHandler(new MouseDownHandler() {
					@Override
					public void onMouseDown(MouseDownEvent event) {
						currentPosition = scrollPanel.getScrollPosition();
					}
				}));

		currentHackHandlers.add(currentTree
				.addMouseUpHandler(new MouseUpHandler() {
					@Override
					public void onMouseUp(MouseUpEvent event) {
						timer.schedule(5);
					}
				}));
	}

}
