/**
 * File Name	:	NDaysFromMetadataRow.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Feb 17, 2011 12:43:50 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.scheduling.ui.client.widgets;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.scheduling.ui.client.common.SchedulingConstants;
import com.ericsson.cms.scheduling.ui.client.data.BeforeAfter;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleInfo;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleType;
import com.ericsson.cms.scheduling.ui.client.data.UiMetadataTree;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class NDaysFromMetadataRow extends SchedulingWidgetRow {

	/**
	 * If you change this, also update the SchedulingConstants.numDaysRequiredInteger2 constant. 
	 */
	private static final int MIN_N_DAYS = 0;

	TextBox nDaysBox;
	Label daysLabel;
	ListBoxWidget<BeforeAfter> beforeAfterOption;
	MetadataFieldWidget metadataFieldWidget;
	Label atLabel;
	TimeEntryWidget timeEntryWidget;

	static SchedulingConstants schedulingConstants = (SchedulingConstants) GWT.create(SchedulingConstants.class);

	public NDaysFromMetadataRow() {
		super();

		nDaysBox = new TextBox();
		nDaysBox.setVisibleLength(4);
		this.add(nDaysBox);
		daysLabel = new Label(schedulingConstants.daysLabel());
		this.add(daysLabel);
		beforeAfterOption = new ListBoxWidget<BeforeAfter>();
		beforeAfterOption.setVisibleItemCount(1);
		for (BeforeAfter beforeAfter : BeforeAfter.values()) {
			beforeAfterOption.addItem(beforeAfter.toString(), beforeAfter);
		}
		this.add(beforeAfterOption);
		metadataFieldWidget = new MetadataFieldWidget();
		metadataFieldWidget.setVisibleLength(50);
		this.add(metadataFieldWidget);
		atLabel = new Label(schedulingConstants.atLabel());
		this.add(atLabel);
		timeEntryWidget = new TimeEntryWidget();
		this.add(timeEntryWidget);		
	}

	/* (non-Javadoc)
	 * @see com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetRow#getScheduleType()
	 */
	@Override
	public ScheduleType getScheduleType() {
		return ScheduleType.N_DAYS_FROM_METADATA;
	}


	/* (non-Javadoc)
	 * @see com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetRow#getScheduleInfo()
	 */
	@Override
	public ScheduleInfo getScheduleInfo() {
		ScheduleInfo scheduleInfo = new ScheduleInfo();
		
		scheduleInfo.setScheduleType(getScheduleType());
		scheduleInfo.setnDays(Integer.parseInt(nDaysBox.getText()));
		scheduleInfo.setBeforeAfter(beforeAfterOption.getSelectedItem());
		scheduleInfo.setMetadataField(metadataFieldWidget.getValue());
		scheduleInfo.setSpecificTime(timeEntryWidget.getTime());

		return scheduleInfo;
	}

	/* (non-Javadoc)
	 * @see com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetRow#setScheduleInfo(com.ericsson.cms.scheduling.ui.client.data.ScheduleInfo)
	 */
	@Override
	public void setScheduleInfo(ScheduleInfo scheduleInfo) {
		nDaysBox.setText(String.valueOf(scheduleInfo.getnDays()));
		beforeAfterOption.setSelectedItem(scheduleInfo.getBeforeAfter());
		metadataFieldWidget.setValue(scheduleInfo.getMetadataField());
		timeEntryWidget.setTime(scheduleInfo.getSpecificTime());
	}

	/* (non-Javadoc)
	 * @see com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetRow#reset()
	 */
	@Override
	public void reset() {
		super.reset();
		
		nDaysBox.setText(null);
		beforeAfterOption.setSelectedItem(BeforeAfter.before);
		metadataFieldWidget.setValue(null);
		metadataFieldWidget.setText(null);
		timeEntryWidget.reset();
	}

	/* (non-Javadoc)
	 * @see com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetRow#validate()
	 */
	@Override
	public List<String> validate() {
		List<String> validationMessages = new ArrayList<String>();
		
		String nDaysBoxText = nDaysBox.getText();
		if ((nDaysBoxText == null) || (nDaysBoxText.isEmpty())) {
			validationMessages.add(schedulingConstants.numDaysRequired());
		}
		else {
			try {
				int numDays = Integer.parseInt(nDaysBoxText);
				if (numDays < MIN_N_DAYS) {
					validationMessages.add(schedulingConstants.numDaysRequiredInteger2());					
				}
			} catch (NumberFormatException e) {
				validationMessages.add(schedulingConstants.numDaysRequiredInteger2());
			}
		}
		
		String mfwValue = metadataFieldWidget.getValue();
		if ((mfwValue == null) || (mfwValue.isEmpty())) {
			validationMessages.add(schedulingConstants.metadataFieldRequired());
		}
		
		validationMessages.addAll(timeEntryWidget.validate());
		
		return validationMessages;
	}

	/* (non-Javadoc)
	 * @see com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetRow#setMetadataTree(com.ericsson.cms.scheduling.ui.client.data.UiMetadataTree)
	 */
	@Override
	public void setMetadataTree(UiMetadataTree metadataTree) {
		if (metadataFieldWidget != null) {
			metadataFieldWidget.setMetadataTree(metadataTree);
		}
	}

	/* (non-Javadoc)
	 * @see com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetRow#setEnabled(boolean)
	 */
	@Override
	public void setEnabled(boolean enabled) {
		super.setEnabled(enabled);
		
		nDaysBox.setEnabled(enabled);
		beforeAfterOption.setEnabled(enabled);
		metadataFieldWidget.setEnabled(enabled);
		timeEntryWidget.setEnabled(enabled);
	}

	public static String getScheduleInfoString(ScheduleInfo scheduleInfo) {
		String scheduleInfoString = "";
		
		if (scheduleInfo != null) {
			scheduleInfoString += scheduleInfo.getnDays();
			scheduleInfoString += " ";
			scheduleInfoString += schedulingConstants.daysLabel();
			scheduleInfoString += " ";
			scheduleInfoString += scheduleInfo.getBeforeAfter();
			scheduleInfoString += " ";
			scheduleInfoString += scheduleInfo.getMetadataField();
			scheduleInfoString += " ";
			scheduleInfoString += schedulingConstants.atLabel();
			scheduleInfoString += " ";
			scheduleInfoString += scheduleInfo.getSpecificTime();
		}
		
		return scheduleInfoString;
	}
}
