/**
 * File Name	:	OnDateRow.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Feb 8, 2011 6:56:01 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.scheduling.ui.client.widgets;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.scheduling.ui.client.common.SchedulingConstants;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleInfo;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.datepicker.client.DateBox;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.DateBoxWidget;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class OnDateRow extends SchedulingWidgetRow {

	private static final String PATTERN_DATE_FORMAT = "yyyy-MM-dd";

	Label onLabel;
	DateBox dateBox;
	Label atLabel;
	TimeEntryWidget timeEntryWidget;
	
	static SchedulingConstants schedulingConstants = (SchedulingConstants) GWT.create(SchedulingConstants.class);

	public OnDateRow() {
		super();
				
		onLabel = new Label(schedulingConstants.onLabel());
		this.add(onLabel);
		dateBox = new DateBoxWidget();
		dateBox.getTextBox().setVisibleLength(12);
		dateBox.getTextBox().setHeight("20px");
		DateBox.DefaultFormat fmt = new DateBox.DefaultFormat(DateTimeFormat.getFormat("yyyy-MM-dd"));
		dateBox.setFormat(fmt);
		this.add(dateBox);
		atLabel = new Label(schedulingConstants.atLabel());
		this.add(atLabel);
		timeEntryWidget = new TimeEntryWidget();
		this.add(timeEntryWidget);
	}
	
	/* (non-Javadoc)
	 * @see com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetRow#getScheduleType()
	 */
	@Override
	public ScheduleType getScheduleType() {
		return ScheduleType.ON_DATE;
	}

	@Override
	public ScheduleInfo getScheduleInfo() {
		ScheduleInfo scheduleInfo = new ScheduleInfo();
		
		scheduleInfo.setScheduleType(getScheduleType());
		scheduleInfo.setSpecificDate(dateBox.getTextBox().getText());
		scheduleInfo.setSpecificTime(timeEntryWidget.getTime());
		
		return scheduleInfo;
	}
	
	@Override
	public void setScheduleInfo(ScheduleInfo scheduleInfo) {
		dateBox.getTextBox().setText(scheduleInfo.getSpecificDate());
		timeEntryWidget.setTime(scheduleInfo.getSpecificTime());
	}

	
	/* (non-Javadoc)
	 * @see com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetRow#reset()
	 */
	@Override
	public void reset() {
		super.reset();
		dateBox.getTextBox().setText(null);
		timeEntryWidget.reset();
	}

	@Override
	public List<String> validate() {
		List<String> validationMessages = new ArrayList<String>();
		
		String strDate = dateBox.getTextBox().getText();
		if ((strDate == null) || (strDate.isEmpty())) {
			validationMessages.add(schedulingConstants.dateRequired());
		}
		else {
			try {
				DateTimeFormat fmt = DateTimeFormat.getFormat(PATTERN_DATE_FORMAT);
				fmt.parse(strDate);
			} catch (IllegalArgumentException e) {
				validationMessages.add(schedulingConstants.dateRequiredFormat());
			}
			
		}
		
		validationMessages.addAll(timeEntryWidget.validate());
		
		return validationMessages;
	}

	/* (non-Javadoc)
	 * @see com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetRow#setEnabled(boolean)
	 */
	@Override
	public void setEnabled(boolean enabled) {
		super.setEnabled(enabled);

		dateBox.setEnabled(enabled);
		timeEntryWidget.setEnabled(enabled);
	}

	public static String getScheduleInfoString(ScheduleInfo scheduleInfo) {
		String scheduleInfoString = "";
		
		if (scheduleInfo != null) {
			scheduleInfoString = schedulingConstants.onLabel();
			scheduleInfoString += " ";
			scheduleInfoString += scheduleInfo.getSpecificDate();
			scheduleInfoString += " ";
			scheduleInfoString += schedulingConstants.atLabel();
			scheduleInfoString += " ";
			scheduleInfoString += scheduleInfo.getSpecificTime();
		}
		
		return scheduleInfoString;
	}
}
