/**
 * File Name	:	OnDayEveryNWeeksRow.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Feb 8, 2011 7:59:16 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.scheduling.ui.client.widgets;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.scheduling.ui.client.common.SchedulingConstants;
import com.ericsson.cms.scheduling.ui.client.data.DayOfWeek;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleInfo;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class OnDayEveryNWeeksRow extends SchedulingWidgetRow {

	/**
	 * If you change this, also update the SchedulingConstants.numWeeksRequiredInteger constant. 
	 */
	private static final int MIN_N_WEEKS = 1;
	/**
	 * If you change this, also update the SchedulingConstants.numWeeksExceededMax constant. 
	 */
	private static final int MAX_N_WEEKS = 1653;

	Label onLabel;
	ListBoxWidget<DayOfWeek> dayOption;
	Label everyLabel;
	TextBox nWeeksBox;
	TimeEntryWidget timeEntryWidget;
	
	static SchedulingConstants schedulingConstants = (SchedulingConstants) GWT.create(SchedulingConstants.class);

	public OnDayEveryNWeeksRow() {
		super();
		
		onLabel = new Label(schedulingConstants.onLabel());
		this.add(onLabel);
		dayOption = new ListBoxWidget<DayOfWeek>();
		dayOption.setVisibleItemCount(1);
		for (DayOfWeek dayOfWeek : DayOfWeek.values()) {
			dayOption.addItem(dayOfWeek.toString(), dayOfWeek);
		}
		this.add(dayOption);
		everyLabel = new Label(schedulingConstants.everyLabel2());
		this.add(everyLabel);
		nWeeksBox = new TextBox();
		nWeeksBox.setVisibleLength(4);
		this.add(nWeeksBox);
		Label weeksAtLabel = new Label(schedulingConstants.weeksAtLabel());
		this.add(weeksAtLabel);
		timeEntryWidget = new TimeEntryWidget();
		this.add(timeEntryWidget);

	}
	
	/* (non-Javadoc)
	 * @see com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetRow#getScheduleType()
	 */
	@Override
	public ScheduleType getScheduleType() {
		return ScheduleType.ON_DAY_EVERY_N_WEEKS;
	}

	@Override
	public ScheduleInfo getScheduleInfo() {
		ScheduleInfo scheduleInfo = new ScheduleInfo();
		
		scheduleInfo.setScheduleType(getScheduleType());
		scheduleInfo.setDayOfWeek(dayOption.getSelectedItem());
		scheduleInfo.setnWeeks(Integer.parseInt(nWeeksBox.getText()));
		scheduleInfo.setSpecificTime(timeEntryWidget.getTime());

		return scheduleInfo;
	}
	
	@Override
	public void setScheduleInfo(ScheduleInfo scheduleInfo) {
		dayOption.setSelectedItem(scheduleInfo.getDayOfWeek());
		nWeeksBox.setText(String.valueOf(scheduleInfo.getnWeeks()));
		timeEntryWidget.setTime(scheduleInfo.getSpecificTime());
	}

	/* (non-Javadoc)
	 * @see com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetRow#reset()
	 */
	@Override
	public void reset() {
		super.reset();
		
		dayOption.setSelectedItem(DayOfWeek.MONDAY);
		nWeeksBox.setText(null);
		timeEntryWidget.reset();
	}

	@Override
	public List<String> validate() {
		List<String> validationMessages = new ArrayList<String>();
		
		String nWeeksBoxText = nWeeksBox.getText();
		if ((nWeeksBoxText == null) || (nWeeksBoxText.isEmpty())) {
			validationMessages.add(schedulingConstants.numWeeksRequired());
		}
		else {
			try {
				int numWeeks = Integer.parseInt(nWeeksBoxText);
				if (numWeeks < MIN_N_WEEKS) {
					validationMessages.add(schedulingConstants.numWeeksRequiredInteger());					
				}
				if (numWeeks > MAX_N_WEEKS) {
					validationMessages.add(schedulingConstants.numWeeksExceededMax());					
				}
			} catch (NumberFormatException e) {
				validationMessages.add(schedulingConstants.numWeeksRequiredInteger());
			}
		}
		
		validationMessages.addAll(timeEntryWidget.validate());
		
		return validationMessages;
	}

	/* (non-Javadoc)
	 * @see com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetRow#setEnabled(boolean)
	 */
	@Override
	public void setEnabled(boolean enabled) {
		super.setEnabled(enabled);
		
		dayOption.setEnabled(enabled);
		nWeeksBox.setEnabled(enabled);
		timeEntryWidget.setEnabled(enabled);
	}

	public static String getScheduleInfoString(ScheduleInfo scheduleInfo) {
		String scheduleInfoString = "";
		
		if (scheduleInfo != null) {
			scheduleInfoString = schedulingConstants.onLabel();
			scheduleInfoString += " ";
			scheduleInfoString += scheduleInfo.getDayOfWeek();
			scheduleInfoString += " ";
			scheduleInfoString += schedulingConstants.everyLabel2();
			scheduleInfoString += " ";
			scheduleInfoString += scheduleInfo.getnWeeks();
			scheduleInfoString += " ";
			scheduleInfoString += schedulingConstants.weeksAtLabel();
			scheduleInfoString += " ";
			scheduleInfoString += scheduleInfo.getSpecificTime();
		}
		
		return scheduleInfoString;
	}

}
