/**
 * File Name	:	SchedulingWidget.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Feb 8, 2011 4:11:58 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.scheduling.ui.client.widgets;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.scheduling.ui.client.common.SchedulingConstants;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleInfo;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleType;
import com.ericsson.cms.scheduling.ui.client.data.UiMetadataTree;
import com.google.gwt.core.client.GWT;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class SchedulingWidget extends VerticalContainer {
	private SchedulingWidgetConfig widgetConfig;
	SchedulingWidgetRow onDateRow;
	SchedulingWidgetRow everyNDaysRow;
	SchedulingWidgetRow onDayEveryNWeeksRow;
	SchedulingWidgetRow nDaysFromMetadataRow;
	boolean isEnabled = true;
	
	SchedulingConstants schedulingConstants = (SchedulingConstants) GWT.create(SchedulingConstants.class);

	public SchedulingWidget(SchedulingWidgetConfig widgetConfig) {
		this.widgetConfig = widgetConfig;
		onDateRow = new OnDateRow();
		everyNDaysRow = new EveryNDaysRow();
		onDayEveryNWeeksRow = new OnDayEveryNWeeksRow();
		nDaysFromMetadataRow = new NDaysFromMetadataRow();
		
		if (widgetConfig != null) {
			if (widgetConfig.isShowOnDateRow()) {
				add(onDateRow);
			}
			if (widgetConfig.isShowEveryNDaysRow()) {
				add(everyNDaysRow);
			}
			if (widgetConfig.isShowOnDayEveryNWeeksRow()) {
				add(onDayEveryNWeeksRow);
			}
			if (widgetConfig.isShowNDaysFromMetadataRow()) {
				add(nDaysFromMetadataRow);
			}
		}

		this.setStyleName("scheduling-widget");
	}
	
	public ScheduleType getScheduleType() {
		ScheduleType scheduleType = null;
		 
		SchedulingWidgetRow selectedSchedulingWidgetRow = getSelectedSchedulingWidgetRow();
		if (selectedSchedulingWidgetRow != null) {
			scheduleType = selectedSchedulingWidgetRow.getScheduleType();
		}
		
		return scheduleType;
	}
	
	public ScheduleInfo getScheduleInfo() {
		ScheduleInfo scheduleInfo = null;

		SchedulingWidgetRow selectedSchedulingWidgetRow = getSelectedSchedulingWidgetRow();
		scheduleInfo = selectedSchedulingWidgetRow.getScheduleInfo();

		return scheduleInfo;
	}
	
	public void setScheduleInfo(ScheduleInfo scheduleInfo) {
		reset();
		if (scheduleInfo != null) {
			ScheduleType scheduleType = scheduleInfo.getScheduleType();
			SchedulingWidgetRow targetRow = null;
			switch (scheduleType) {
			case ON_DATE:
				targetRow = onDateRow;
				break;
			case EVERY_N_DAYS:
				targetRow = everyNDaysRow;
				break;
			case ON_DAY_EVERY_N_WEEKS:
				targetRow = onDayEveryNWeeksRow;
				break;
			case N_DAYS_FROM_METADATA:
				targetRow = nDaysFromMetadataRow;
				break;
			}
			if (targetRow != null) {
				onDateRow.setChecked(false);
				everyNDaysRow.setChecked(false);
				onDayEveryNWeeksRow.setChecked(false);
				nDaysFromMetadataRow.setChecked(false);
				
				targetRow.setChecked(true);
				targetRow.setScheduleInfo(scheduleInfo);
			}
		}

	}
	
	public static String getScheduleInfoString(ScheduleInfo scheduleInfo) {
		String scheduleInfoString = "";
		
		if (scheduleInfo != null) {
			ScheduleType scheduleType = scheduleInfo.getScheduleType();
			switch (scheduleType) {
			case ON_DATE:
				scheduleInfoString = OnDateRow.getScheduleInfoString(scheduleInfo);
				break;
			case EVERY_N_DAYS:
				scheduleInfoString = EveryNDaysRow.getScheduleInfoString(scheduleInfo);
				break;
			case ON_DAY_EVERY_N_WEEKS:
				scheduleInfoString = OnDayEveryNWeeksRow.getScheduleInfoString(scheduleInfo);
				break;
			case N_DAYS_FROM_METADATA:
				scheduleInfoString = NDaysFromMetadataRow.getScheduleInfoString(scheduleInfo);
				break;
			}
		}
		
		return scheduleInfoString;
	}

	public void reset() {
		if (widgetConfig.isShowOnDateRow()) {
			onDateRow.setChecked(true);
		}
		else if (widgetConfig.isShowEveryNDaysRow()) {
			everyNDaysRow.setChecked(true);
		}
		else if (widgetConfig.isShowOnDayEveryNWeeksRow()) {
			onDayEveryNWeeksRow.setChecked(true);
		}
		else if (widgetConfig.isShowNDaysFromMetadataRow()) {
			nDaysFromMetadataRow.setChecked(true);
		}

		onDateRow.reset();
		everyNDaysRow.reset();
		onDayEveryNWeeksRow.reset();
		nDaysFromMetadataRow.reset();
	}
	
	public List<String> validate() {
		List<String> validationMessages = new ArrayList<String>();
		
		SchedulingWidgetRow selectedSchedulingWidgetRow = getSelectedSchedulingWidgetRow();
		if (selectedSchedulingWidgetRow == null) {
			validationMessages.add(schedulingConstants.scheduleTypeRequired());
		}
		else {
			validationMessages.addAll(selectedSchedulingWidgetRow.validate());
		}
		
		return validationMessages;
	}
	
	public void setMetadataTree(UiMetadataTree metadataTree) {
		if (nDaysFromMetadataRow != null) {
			nDaysFromMetadataRow.setMetadataTree(metadataTree);
		}
	}

	public SchedulingWidgetRow getSelectedSchedulingWidgetRow() {
		SchedulingWidgetRow selectedSchedulingWidgetRow = null;
		
		if (onDateRow.isChecked()) {
			selectedSchedulingWidgetRow = onDateRow;
		}
		else if (everyNDaysRow.isChecked()) {
			selectedSchedulingWidgetRow = everyNDaysRow;
		}
		else if (onDayEveryNWeeksRow.isChecked()) {
			selectedSchedulingWidgetRow = onDayEveryNWeeksRow;
		}
		else if (nDaysFromMetadataRow.isChecked()) {
			selectedSchedulingWidgetRow = nDaysFromMetadataRow;
		}
		
		return selectedSchedulingWidgetRow;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isEnabled() {
		return isEnabled;
	}
	
	/**
	 * 
	 * @param enabled
	 */
	public void setEnabled(boolean enabled) {
		isEnabled = enabled;
		onDateRow.setEnabled(enabled);
		everyNDaysRow.setEnabled(enabled);
		onDayEveryNWeeksRow.setEnabled(enabled);
		nDaysFromMetadataRow.setEnabled(enabled);
	}
}
