/**
 * File Name	:	SchedulingWidget2.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Mar 7, 2011 3:29:04 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.scheduling.ui.client.widgets;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ericsson.cms.scheduling.ui.client.common.SchedulingConstants;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleInfo;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleType;
import com.ericsson.cms.scheduling.ui.client.data.UiMetadataTree;
import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.datepicker.client.DateBox;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.DateBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * Same as {@link SchedulingWidget} except has additional start date 
 * and end date selection.
 * 
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class SchedulingWidget2 extends VerticalContainer {
	
	private static final String PATTERN_DATE_FORMAT = "yyyy-MM-dd";
	private static final DateTimeFormat DATE_FORMAT = DateTimeFormat.getFormat(PATTERN_DATE_FORMAT);
	
	FormContainer formContainer;
	LabelWidget startDateLabel;
	DateBox startDateBox;
	LabelWidget endDateLabel;
	DateBox endDateBox;
	SchedulingWidget schedulingWidget;
	boolean isEnabled = true;
	
	SchedulingConstants schedulingConstants = (SchedulingConstants) GWT.create(SchedulingConstants.class);

	public SchedulingWidget2(SchedulingWidgetConfig widgetConfig) {
		startDateLabel = new LabelWidget(schedulingConstants.startDateLabel());
		startDateBox = newDateBoxInstance();
		
		endDateLabel = new LabelWidget(schedulingConstants.endDateLabel());
		endDateBox = newDateBoxInstance();
		
		formContainer = new FormContainer(HorizontalContainer.ALIGN_LEFT);
		formContainer.addRow(startDateLabel, startDateBox);
		formContainer.addRow(endDateLabel, endDateBox);
		this.add(formContainer);
		
		schedulingWidget = new SchedulingWidget(widgetConfig);
		this.add(schedulingWidget);
	}

	/**
	 * @return
	 * @see com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidget#getScheduleInfo()
	 */
	public ScheduleInfo getScheduleInfo() {
		ScheduleInfo scheduleInfo = null;

		scheduleInfo = schedulingWidget.getScheduleInfo();
		ScheduleType scheduleType = schedulingWidget.getScheduleType();
		
		if (!ScheduleType.ON_DATE.equals(scheduleType)) {
			String strStartDate = startDateBox.getTextBox().getText();
			scheduleInfo.setStrStartDate(strStartDate);
			
			String strEndDate = endDateBox.getTextBox().getText();
			scheduleInfo.setStrEndDate(strEndDate);			
		}
		return scheduleInfo;
	}

	/**
	 * @param scheduleInfo
	 * @see com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidget#setScheduleInfo(com.ericsson.cms.scheduling.ui.client.data.ScheduleInfo)
	 */
	public void setScheduleInfo(ScheduleInfo scheduleInfo) {
		reset();
		
		schedulingWidget.setScheduleInfo(scheduleInfo);
		
		if (scheduleInfo != null) {
			String strStartDate = scheduleInfo.getStrStartDate();
			if (strStartDate != null) {
				startDateBox.getTextBox().setText(strStartDate);
			}
			
			String strEndDate = scheduleInfo.getStrEndDate();
			if (strEndDate != null) {
				endDateBox.getTextBox().setText(strEndDate);
			}
		}
	}

	public static String getScheduleInfoString(ScheduleInfo scheduleInfo) {
		String scheduleInfoString = "";
		
		if (scheduleInfo != null) {
			scheduleInfoString = SchedulingWidget.getScheduleInfoString(scheduleInfo);
		}
		
		return scheduleInfoString;
	}

	/**
	 * 
	 * @see com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidget#reset()
	 */
	public void reset() {
		schedulingWidget.reset();
		startDateBox.getTextBox().setText(null);
		endDateBox.getTextBox().setText(null);
	}

	/**
	 * @return
	 * @see com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidget#validate()
	 */
	public List<String> validate() {
		List<String> validationMessages = new ArrayList<String>();

		ScheduleType scheduleType = schedulingWidget.getScheduleType();
		
		String strStartDate = startDateBox.getTextBox().getText();
		String strEndDate = endDateBox.getTextBox().getText();

		if (ScheduleType.ON_DATE.equals(scheduleType)) {
			// Start Date and End Date should not be supplied if it's OnDate
			// schedule
			if ((strStartDate != null) && (!strStartDate.isEmpty())) {
				validationMessages.add(schedulingConstants
						.startDateNotRequired());
			}
			if ((strEndDate != null) && (!strEndDate.isEmpty())) {
				validationMessages
						.add(schedulingConstants.endDateNotRequired());
			}
		}		
		else {
			Date startDate = null;
			if ((strStartDate != null) && (!strStartDate.isEmpty())) {
				try {
					startDate = DATE_FORMAT.parse(strStartDate);
				} catch (IllegalArgumentException e) {
					validationMessages.add(schedulingConstants
							.startDateRequiredFormat());
				}
			}
			
			Date endDate = null;
			if ((strEndDate != null) && (!strEndDate.isEmpty())) {
				try {
					endDate = DATE_FORMAT.parse(strEndDate);
				} catch (IllegalArgumentException e) {
					validationMessages.add(schedulingConstants
							.endDateRequiredFormat());
				}
			}
			
			if ((startDate != null) && (endDate != null) && (endDate.before(startDate))) {
					validationMessages.add(schedulingConstants
							.endDateBeforeStartDate());
			}
		}
		
		validationMessages.addAll(schedulingWidget.validate());

		return validationMessages;
	}

	/**
	 * @param metadataTree
	 * @see com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidget#setMetadataTree(com.ericsson.cms.scheduling.ui.client.data.UiMetadataTree)
	 */
	public void setMetadataTree(UiMetadataTree metadataTree) {
		schedulingWidget.setMetadataTree(metadataTree);
	}

	/**
	 * @return
	 * @see com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidget#getSelectedSchedulingWidgetRow()
	 */
	public SchedulingWidgetRow getSelectedSchedulingWidgetRow() {
		return schedulingWidget.getSelectedSchedulingWidgetRow();
	}

	/**
	 * 
	 * @return
	 */
	public boolean isEnabled() {
		return isEnabled;
	}
	
	/**
	 * @param enabled
	 */
	public void setEnabled(boolean enabled) {
		isEnabled = enabled;
		schedulingWidget.setEnabled(enabled);
		startDateBox.setEnabled(enabled);
		endDateBox.setEnabled(enabled);
	}

	private DateBox newDateBoxInstance() {
		DateBox dateBox = new DateBoxWidget();
		dateBox.getTextBox().setVisibleLength(12);
		dateBox.getTextBox().setHeight("20px");
		DateBox.DefaultFormat fmt = new DateBox.DefaultFormat(DATE_FORMAT);
		dateBox.setFormat(fmt);

		return dateBox;
	}
}
