/**
 * File Name	:	TimeEntryWidget.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Feb 10, 2011 4:31:25 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.scheduling.ui.client.widgets;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.scheduling.ui.client.common.SchedulingConstants;
import com.ericsson.cms.scheduling.ui.client.data.AmPm;
import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.TextBox;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class TimeEntryWidget extends HorizontalContainer {

	private static final String PATTERN_TIME_FORMAT = "h:mm a";

	TextBox timeEntryBox;
	ListBoxWidget<AmPm> ampmOption;

	SchedulingConstants schedulingConstants = (SchedulingConstants) GWT.create(SchedulingConstants.class);

	public TimeEntryWidget() {
		super();
		
		timeEntryBox = new TextBox();
		timeEntryBox.setVisibleLength(5);
		this.add(timeEntryBox);
		ampmOption = new ListBoxWidget<AmPm>();
		ampmOption.setVisibleItemCount(1);
		ampmOption.addItem(AmPm.am.toString(), AmPm.am);
		ampmOption.addItem(AmPm.pm.toString(), AmPm.pm);
		this.add(ampmOption);		
	}
	
	public String getTime() {
		String strTime = timeEntryBox.getText();
		strTime += " ";
		strTime += ampmOption.getSelectedItem().toString();
		
		return strTime;
	}
	
	public void setTime(String strTime) {
		String[] strTimeComponents = strTime.split(" ");
		// Last component should be am/pm component
		int numStrTimeComponents = strTimeComponents.length;
		String strAmPm = strTimeComponents[numStrTimeComponents - 1];
		String strHrMins = strTimeComponents[0];
		
		ampmOption.setSelectedItem(AmPm.valueOf(strAmPm));
		timeEntryBox.setText(strHrMins);
	}
	
	public void reset() {
		timeEntryBox.setText(null);
		ampmOption.setSelectedItem(AmPm.am);
	}

	public List<String> validate() {
		List<String> validationMessages = new ArrayList<String>();
		
		String strTime = getTime();
		DateTimeFormat fmt = DateTimeFormat.getFormat(PATTERN_TIME_FORMAT);
		try {
			fmt.parseStrict(strTime);
		} catch (IllegalArgumentException e) {
			validationMessages.add(schedulingConstants.timeRequiredFormat());
		}
		
		if (!validationMessages.contains(schedulingConstants
				.timeRequiredFormat())) {
			// Strict Parsing with DateTimeFormat does not seem to throw
			// exception for the Time Format Pattern used above if hour 
			// is a number greater than 12.

			try {
				String[] strTimeParts = strTime.split(":");
				String strTimeHourPart = strTimeParts[0];
				int hour = Integer.parseInt(strTimeHourPart.trim());
				if (hour > 12) {
					validationMessages.add(schedulingConstants
							.timeRequiredFormat());
				}
			} catch (NumberFormatException e) {
				validationMessages
						.add(schedulingConstants.timeRequiredFormat());
			}
		}
		return validationMessages;
	}

	/**
	 * 
	 * @param enabled
	 */
	public void setEnabled(boolean enabled) {
		timeEntryBox.setEnabled(enabled);
		ampmOption.setEnabled(enabled);
	}
}
