package com.ericsson.cms.sites.ui.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.ericsson.cms.scheduling.ui.client.data.ScheduleInfo;
import com.ericsson.cms.scheduling.ui.client.data.UIJob;
import com.ericsson.cms.scheduling.ui.client.data.UiMetadataTree;
import com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidget;
import com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetConfig;
import com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetFactory;
import com.ericsson.cms.sites.ui.client.CheckboxGroup.Item;
import com.ericsson.cms.sites.ui.client.ExportStatusSelectionDialog.IExportActionHandler;
import com.ericsson.cms.sites.ui.client.SitesTabContainer.SiteCRUDNotifier;
import com.ericsson.cms.sites.ui.client.entities.UIDistributionOption;
import com.ericsson.cms.sites.ui.client.entities.UISite;
import com.ericsson.cms.sites.ui.client.entities.UISitePartner;
import com.ericsson.cms.sites.ui.client.entities.UISiteTreeNode;
import com.ericsson.cms.sites.ui.client.entities.UISiteType;
import com.ericsson.cms.sites.ui.client.entities.UIStatusPlugin;
import com.ericsson.cms.sites.ui.client.entities.UIStatusPluginType;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.ericsson.cms.sites.ui.client.i18n.SitesMessages;
import com.ericsson.cms.sites.ui.client.images.ISiteClientBundle;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UIDistributionStatus;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextAreaWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DialogBoxContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * Basic Site Information.
 * <p>
 * For layout, it uses a {@link com.google.gwt.user.client.ui.DockPanel}, with 
 * the site info in center and the buttons panel in south.
 * <p>
 * Site Info itself is divided into two disclosure panels, 
 * one for basic site info and the other for partner info.
 * 
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class BasicTab extends Composite implements ISiteTab {
	private static final String STYLE_DIALOG_BOX = "sites-basicTab-rollbackDialogBox";
	private static final String STYLE_DIALOG_BOX_BUTTON_PANEL = "sites-basicTab-rollbackDialogBoxButtonPanel";
	private static final String STYLE_SCROLL_CONTAINER = "sites-basicTab-scrollContainer";
	private static final String STYLE_DISCLOSURE_CONTAINER = "sites-basicTab-disclosureContainer";
	private static final boolean DISTRIBUTION_STATUS_PLUGIN_REQUIRED = false;

	private static final String SCHEDULER_LICENSE_KEY = "SchedulerLicense";

	private static final String METADATA_FORMAT_CABLELABSVOD1_1 = "CableLabsVOD1.1";
	private static final String METADATA_FORMAT_ALIAS_CABLELABSVOD1_1 = "CL1_1";

	private NeptuneSecurity security;
	private SiteCRUDNotifier crudNotifier;

	private VerticalContainer mainPanel;
	private SimpleContainer basicInfoPanel;
	private RoundedDisclosureContainer basicInfoDisclosurePanel;
	private PartnerInfoPanel partnerInfoPanel;
	private RoundedDisclosureContainer partnerInfoDisclosurePanel;
	private LabelWidget noSiteLabel;
	private MessageArea messageArea;
	private HorizontalContainer siteStatusPanel;
	private FormContainer basicFormContainer;
	private HorizontalPanel buttonsPanel;

	private LabelWidget siteStatusLabel, fileLookupKeysLabel,
			metadataFormatLabel, distOptionLabel, distConfLabel,
			exportConfLabel, alertDelayPeriodLabel, distStatusPluginPanelLabel,
			deplStatusPluginPanelLabel;

	private ISiteClientBundle clientBundle = GWT
			.create(ISiteClientBundle.class);
	private ImageWidget siteActiveImage = new ImageWidget();
	private ImageWidget siteInactiveImage = new ImageWidget();
	private TextBoxWidget nameValueWidget = new TextBoxWidget();
	private TextBoxWidget externalIdValueWidget = new TextBoxWidget();
	private TextAreaWidget descriptionValueWidget = new TextAreaWidget();
	private ListBoxWidget<UISiteType> siteTypeValueWidget = new ListBoxWidget<UISiteType>();
	private CheckboxGroup<String> fileLookupKeysValueWidget = new CheckboxGroup<String>();
	private ListBoxWidget<String> metadataFormatValueWidget = new ListBoxWidget<String>();
	private VerticalContainer distOptionValueWidget;
	private SchedulingWidget schedulingWidget;
	private ListBoxWidget<UIDistributionOption> distOptionListBox;
	private DistConfPanel distConfPanel;
	private ExportConfPanel exportConfPanel;
	private HorizontalContainer alertDelayPeriodValueWidget;
	private TextBoxWidget alertDelayPeriodTextWidget = new TextBoxWidget();
	private StatusPluginPanel distStatusPluginPanel;
	private StatusPluginPanel deplStatusPluginPanel;
	private DockPanel dockPanel;
	private ScrollPanel rightScrollPanel;
	private HandlerRegistration windowRegistration = null;
	protected ScheduledCommand resizeCommand;
	private SitesTree treeWidget;
	private SitesTabContainer parentTabContainer;

	private ButtonWidget saveButton, activateButton, inactivateButton,
			deleteButton, exportButton, createChildButton, addExistingButton, 
			dissociateFromParentButton;

	private UISite site;

	private BusyIndicator busyIndicator = new BusyIndicator();

	private IUISiteServiceAsync service = GWT.create(IUISiteService.class);
	private SitesConstants constants = GWT.create(SitesConstants.class);
	private SitesMessages messages = GWT.create(SitesMessages.class);

	List<String> siteNameValidationErrors = new ArrayList<String>();
	List<String> externalSiteIdValidationErrors = new ArrayList<String>();

	private boolean isDistStatusPluginRequired = DISTRIBUTION_STATUS_PLUGIN_REQUIRED;
	private boolean isSchedulerLicensed;

	public BasicTab(Map<String, String> info) {
		this.security = NeptuneApplication.getApplication().getSecurity();

	    mainPanel = new VerticalContainer();
	    mainPanel.setSpacing(10);
	    
	    basicInfoPanel = new SimpleContainer();
		partnerInfoPanel = new PartnerInfoPanel();
	    
		noSiteLabel = new LabelWidget(constants.noSiteSelected());
		siteActiveImage.setResource(clientBundle.siteActive());
		siteInactiveImage.setResource(clientBundle.siteInactive());

		siteStatusPanel = new HorizontalContainer();
		siteStatusLabel = new LabelWidget(constants.fieldLabelSiteStatus());

		nameValueWidget.addValueChangeHandler(new ValueChangeHandler<String>() {
			@Override
			public void onValueChange(ValueChangeEvent<String> event) {
				String siteName = nameValueWidget.getText();
				validateSiteName(siteName);
			}
		});

		externalIdValueWidget
				.addValueChangeHandler(new ValueChangeHandler<String>() {
					@Override
					public void onValueChange(ValueChangeEvent<String> event) {
						String externalId = externalIdValueWidget.getText();
						validateExternalSiteId(externalId);
					}
				});

		siteTypeValueWidget.addItem(constants.fieldValueSiteTypeLogical(),
				UISiteType.LOGICAL);
		siteTypeValueWidget.addItem(constants.fieldValueSiteTypeDistribution(),
				UISiteType.DISTRIBUTION);
		siteTypeValueWidget.addItem(constants.fieldValueSiteTypeMediaPathDistribution(),
				UISiteType.MEDIAPATH_DISTRIBUTION);
		siteTypeValueWidget.addItem(constants.fieldValueSiteTypeTracking(),
				UISiteType.TRACKING);
		siteTypeValueWidget.setEnabled(false);

		fileLookupKeysLabel = new LabelWidget(
				constants.fieldLabelFileLookupKeys());
		// TODO set size

		metadataFormatLabel = new LabelWidget(
				constants.fieldLabelMetadataFormat());

		distOptionLabel = new LabelWidget(constants.fieldLabelDistOption());
		distOptionValueWidget = new VerticalContainer();
		distOptionListBox = new ListBoxWidget<UIDistributionOption>();
		distOptionListBox.addItem(constants.fieldValueDistOptionImmediate(),
				UIDistributionOption.IMMEDIATE);
		isSchedulerLicensed = Boolean.parseBoolean(info
				.get(SCHEDULER_LICENSE_KEY));

		boolean canCreateSchedule = security
				.isUserInRole(com.ericsson.cms.scheduling.ui.client.Permissions.CREATE);
		boolean canViewSchedule = security
				.isUserInRole(com.ericsson.cms.scheduling.ui.client.Permissions.VIEW);
		boolean canEditSchedule = security.isUserInRole(Permissions.EDIT)
				&& security
						.isUserInRole(com.ericsson.cms.scheduling.ui.client.Permissions.EDIT);
		boolean canDeleteSchedule = security.isUserInRole(Permissions.EDIT)
				&& security
						.isUserInRole(com.ericsson.cms.scheduling.ui.client.Permissions.DELETE);

		boolean isTimedOptionAvailable = canCreateSchedule || canViewSchedule
				|| canEditSchedule || canDeleteSchedule;

		if (isTimedOptionAvailable) {
			distOptionListBox.addItem(constants.fieldValueDistOptionTimed(),
					UIDistributionOption.TIMED);
		}

		distOptionListBox.addItem(constants.fieldValueDistOptionManual(),
				UIDistributionOption.MANUAL);
		distOptionValueWidget.add(distOptionListBox);
		schedulingWidget = getSchedulingWidget();
		schedulingWidget.setVisible(false);
		distOptionValueWidget.add(schedulingWidget);
		distOptionListBox.addChangeHandler(new ChangeHandler() {
			@Override
			public void onChange(ChangeEvent event) {
				UIDistributionOption selectedDistributionOption = distOptionListBox
						.getSelectedItem();
				if (UIDistributionOption.TIMED
						.equals(selectedDistributionOption)) {
					boolean isScheduleVisible = (security
							.isUserInRole(com.ericsson.cms.scheduling.ui.client.Permissions.CREATE) && (site
							.getTimerJob() == null))
							|| (security
									.isUserInRole(com.ericsson.cms.scheduling.ui.client.Permissions.VIEW) && (site
									.getTimerJob() != null))
							|| (security
									.isUserInRole(com.ericsson.cms.scheduling.ui.client.Permissions.EDIT) && (site
									.getTimerJob() != null))
							|| (security
									.isUserInRole(com.ericsson.cms.scheduling.ui.client.Permissions.DELETE) && (site
									.getTimerJob() != null));
					boolean isScheduleEnabled = (security
							.isUserInRole(com.ericsson.cms.scheduling.ui.client.Permissions.CREATE) && (site
									.getTimerJob() == null))
									|| (security
									.isUserInRole(com.ericsson.cms.scheduling.ui.client.Permissions.EDIT) && (site
									.getTimerJob() != null));
					schedulingWidget.setVisible(isScheduleVisible);
					schedulingWidget.setEnabled(isScheduleEnabled);
					
					if (!isScheduleVisible) {
						Window.alert("You do not have permission for this operation.");
						distOptionListBox.setSelectedItem(site.getDistributionOption());
					}

				} else {
					schedulingWidget.setVisible(false);
				}
			}
		});

		distConfLabel = new LabelWidget(constants.fieldLabelDistConf());
		distConfPanel = new DistConfPanel();

		exportConfLabel = new LabelWidget(constants.fieldLabelExportConf());
		exportConfPanel = new ExportConfPanel();

		alertDelayPeriodLabel = new LabelWidget(
				constants.fieldLabelAlertDelayPeriod());
		alertDelayPeriodValueWidget = new HorizontalContainer();
		alertDelayPeriodValueWidget.add(alertDelayPeriodTextWidget);
		LabelWidget minutesLabel = new LabelWidget(constants.minutes());
		alertDelayPeriodValueWidget.add(minutesLabel);

		distStatusPluginPanelLabel = new LabelWidget(
				constants.fieldLabelDistStatusPluginPanel());
		distStatusPluginPanel = new StatusPluginPanel();
		deplStatusPluginPanel = new StatusPluginPanel();
		deplStatusPluginPanelLabel = new LabelWidget(
				constants.fieldLabelDeplStatusPluginPanel());

		saveButton = new ButtonWidget(constants.buttonLabelSave(),
				new ClickHandler() {
					@Override
					public void onClick(ClickEvent event) {
						save();
					}
				});
		saveButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);

		activateButton = new ButtonWidget(constants.buttonLabelActivate(),
				new ClickHandler() {
					@Override
					public void onClick(ClickEvent event) {
						activateAfterConfirming();
					}
				});
		activateButton.addStyleDependentName(StyleNames.DO_BUTTON_STYLE);

		inactivateButton = new ButtonWidget(constants.buttonLabelInactivate(),
				new ClickHandler() {
					@Override
					public void onClick(ClickEvent event) {
						inactivateAfterConfirming();
					}
				});
		inactivateButton.addStyleDependentName(StyleNames.CAUTION_BUTTON_STYLE);

		deleteButton = new ButtonWidget(constants.buttonLabelDelete(),
				new ClickHandler() {
					@Override
					public void onClick(ClickEvent event) {
						delete();
					}
				});
		deleteButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);

		exportButton = new ButtonWidget(constants.buttonLabelExport(),
				new ClickHandler() {
					@Override
					public void onClick(ClickEvent event) {
						showExportDialog();
					}
				});
		exportButton.addStyleDependentName(StyleNames.DO_BUTTON_STYLE);

		createChildButton = new ButtonWidget(constants.buttonLabelCreateChild());
		createChildButton.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
		createChildButton.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(final ClickEvent event) {
				createChildSite(event);
			}
			
		});

		addExistingButton = new ButtonWidget(constants.buttonLabelAddExisting());
		addExistingButton.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
		addExistingButton.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(final ClickEvent event) {
				addExistingSite();
			}
			
		});
				
		dissociateFromParentButton = new ButtonWidget(constants.buttonLabelDissociate());
		dissociateFromParentButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		dissociateFromParentButton.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(final ClickEvent event) {
				dissociate();
			}
			
		});

		dockPanel = new DockPanel();
		dockPanel.setSpacing(10);
		
		buttonsPanel = new HorizontalPanel();
	    dockPanel.add(buttonsPanel, DockPanel.SOUTH);

	    rightScrollPanel = new ScrollPanel();
	    rightScrollPanel.addStyleName(STYLE_SCROLL_CONTAINER);
	    
		rightScrollPanel.add(mainPanel);
		rightScrollPanel.setHeight("500px");
		rightScrollPanel.setWidth("500px");
		dockPanel.add(rightScrollPanel, DockPanel.CENTER);
		
		initWidget(dockPanel);
	    
		resizeCommand = new ScheduledCommand() {
			@Override
			public void execute() {
				resizeRightScrollPanel();
			}
		};
		
		showNoSiteSelectedLabel();
	}

	@Override
	public String getName() {
		return "Basic";
	}

	@Override
	public String getDisplayName() {
		return constants.basicTabName();
	}

	@Override
	public void setCRUDNotifier(SiteCRUDNotifier crudListener) {
		this.crudNotifier = crudListener;
	}

	@Override
	public void setSelected(boolean selected) {
		if(!selected)
			return;

		messageArea.reset();
		
		if (site != null && site.getId() != null) {
			History.newItem(
					Anchors.getAnchor(site.getId(), site.getParentId()), false);
			setMetadataTree(schedulingWidget);
		}
		updateScrollPanelSize();
	}


	/**
	 * @param parentTabContainer the parentTabContainer to set
	 */
	public void setParentTabContainer(SitesTabContainer parentTabContainer) {
		this.parentTabContainer = parentTabContainer;
	}

	/**
	 * @param treeWidget the treeWidget to set
	 */
	public void setTreeWidget(SitesTree treeWidget) {
		this.treeWidget = treeWidget;
	}

	private void showNoSiteSelectedLabel() {
		mainPanel.clear();
		mainPanel.add(noSiteLabel);
		buttonsPanel.clear();
	}

	private void showForm() {
		setErrorMessage(null);
		setInfoMessage(null);
		mainPanel.clear();

		siteStatusPanel.add(siteStatusLabel);
		siteStatusPanel.add(siteActiveImage);
		siteStatusPanel.add(siteInactiveImage);
		mainPanel.add(siteStatusPanel);
		mainPanel.add(basicInfoPanel);
	}

	private void setErrorMessage(String message) {
		messageArea.setErrorMessage(message);
		updateScrollPanelSize();
	}

	private void setErrorHTML(String html) {
		messageArea.setErrorHTML(html);
		updateScrollPanelSize();
	}

	private void setInfoMessage(String message) {
		messageArea.setInfoMessage(message);
		updateScrollPanelSize();
	}

	private void showErrorMessage(String message) {
		mainPanel.clear();
		setErrorMessage(message);
	}

	private void showInfoMessage(String message) {
		mainPanel.clear();
		setInfoMessage(message);
	}

	private void setValidationErrors(String heading,
			List<String> validationErrors, String message) {
		setInfoMessage(null);
		StringBuilder html = new StringBuilder();
		if(heading != null)
			html.append(heading).append("<br>");
		if(validationErrors != null) {
			html.append("<ul>");
			for(String e : validationErrors)
				html.append("<li>" + e + "</li>");
			html.append("</ul>");
		}
		if(message != null)
			html.append(message);
		
		setErrorHTML(html.toString());
	}

	public void showAddExistingTrackingSite(int parentSiteId,
			AsyncCallback<Void> callback) {
		site = null;
		mainPanel.clear();
		buttonsPanel.clear();
		mainPanel.add(new TrackingSitesListPanel(parentSiteId, callback));
	}

	private void buildFormUI(UISiteType siteType) {
		basicFormContainer = new FormContainer(HorizontalContainer.ALIGN_LEFT);

		basicFormContainer.addRow(constants.fieldLabelName(), nameValueWidget, true);
		basicFormContainer.addRow(constants.fieldLabelSiteType(),
				siteTypeValueWidget);
		basicFormContainer.addRow(constants.fieldLabelExternalId(),
				externalIdValueWidget, true);
		basicFormContainer.addRow(constants.fieldLabelDescription(),
				descriptionValueWidget);

		if ((siteType == UISiteType.DISTRIBUTION) || (siteType == UISiteType.MEDIAPATH_DISTRIBUTION)) {
			basicFormContainer.addRow(fileLookupKeysLabel, fileLookupKeysValueWidget, true);
			basicFormContainer.addRow(metadataFormatLabel,
					metadataFormatValueWidget, true);
			basicFormContainer.addRow(distOptionLabel, distOptionValueWidget, true);
			basicFormContainer.addRow(distConfLabel, distConfPanel, true);
			basicFormContainer.addRow(exportConfLabel, exportConfPanel);
			basicFormContainer.addRow(alertDelayPeriodLabel,
					alertDelayPeriodValueWidget, true);
			basicFormContainer.addRow(distStatusPluginPanelLabel,
					distStatusPluginPanel, isDistStatusPluginRequired);
			basicFormContainer.addRow(deplStatusPluginPanelLabel,
					deplStatusPluginPanel);
		} else if (siteType == UISiteType.TRACKING) {
			basicFormContainer.addRow(alertDelayPeriodLabel,
					alertDelayPeriodValueWidget, true);
			basicFormContainer.addRow(deplStatusPluginPanelLabel,
					deplStatusPluginPanel);
		}

		basicInfoPanel.setWidget(basicFormContainer);

		buttonsPanel.add(saveButton);
		if ((siteType == UISiteType.DISTRIBUTION) || (siteType == UISiteType.MEDIAPATH_DISTRIBUTION))
			buttonsPanel.add(exportButton);
		buttonsPanel.add(activateButton);
		buttonsPanel.add(inactivateButton);
		buttonsPanel.add(createChildButton);
		buttonsPanel.add(addExistingButton);
		buttonsPanel.add(dissociateFromParentButton);
		buttonsPanel.add(deleteButton);
	}

	private String getFailureMessageSuffix(Throwable caught) {
		return " | " + constants.reason() + ": "
				+ (caught != null ? caught.getLocalizedMessage() : "");
	}

	private void showCommonSiteInfo(UISite site) {
		buildFormUI(site.getType());
		showForm();
		siteNameValidationErrors.clear();
		externalSiteIdValidationErrors.clear();
		nameValueWidget.setText(site.getName());
		externalIdValueWidget.setText(site.getExternalId());
		descriptionValueWidget.setText(site.getDescription());
		siteTypeValueWidget.setSelectedItem(site.getType());
		boolean siteActive = site.isActive();
		siteActiveImage.setVisible(siteActive);
		siteInactiveImage.setVisible(!siteActive);

		Scheduler.get().scheduleDeferred(new ScheduledCommand() {
	        public void execute () {
	    		nameValueWidget.setFocus(true);
	        }
	   });
	}

	private void showPartnerInfo(UISite site) {
		mainPanel.clear();
		mainPanel.add(siteStatusPanel);
		
		basicInfoDisclosurePanel = new RoundedDisclosureContainer(
				new LabelWidget(constants.basicDisclosurePanelHeading()), true);
		basicInfoDisclosurePanel.addStyleName(STYLE_DISCLOSURE_CONTAINER);
		basicInfoDisclosurePanel.setContent(basicInfoPanel);
		mainPanel.add(basicInfoDisclosurePanel);

		partnerInfoDisclosurePanel = new RoundedDisclosureContainer(
				new LabelWidget(constants.partnerDisclosurePanelHeading()), true);
		partnerInfoDisclosurePanel.addStyleName(STYLE_DISCLOSURE_CONTAINER);
		partnerInfoDisclosurePanel.setContent(partnerInfoPanel);
		
		mainPanel.add(partnerInfoDisclosurePanel);

		partnerInfoPanel.showSite(site);
	}

	private void showCreateButtons() {
		saveButton.setVisible(true);
		activateButton.setVisible(false);
		inactivateButton.setVisible(false);
		deleteButton.setVisible(false);
		exportButton.setVisible(false);
		createChildButton.setVisible(false);
		addExistingButton.setVisible(false);
		dissociateFromParentButton.setVisible(false);
	}

	private void showViewEditButtons(UISite site) {
		boolean hasCreatePrivilege = security.isUserInRole(Permissions.CREATE);
		boolean hasEditPrivilege = security.isUserInRole(Permissions.EDIT);
		boolean hasDeletePrivilege = security.isUserInRole(Permissions.DELETE);
		UIJob timerJob = site.getTimerJob();
		if (timerJob != null) {
			hasEditPrivilege = hasEditPrivilege
					&& security.isUserInRole(Permissions.SCHEDULER_MODIFY);
			hasDeletePrivilege = hasDeletePrivilege 
					&& security.isUserInRole(Permissions.SCHEDULER_DELETE);
		}
		UISiteType siteType = site.getType();

		saveButton.setVisible(hasEditPrivilege);
		activateButton.setVisible(hasEditPrivilege && !site.isActive());
		inactivateButton.setVisible(hasEditPrivilege && site.isActive());
		deleteButton.setVisible(hasDeletePrivilege && !site.isShared());
		exportButton.setVisible((siteType.equals(UISiteType.DISTRIBUTION) 
				|| siteType.equals(UISiteType.MEDIAPATH_DISTRIBUTION))
				&& security.isUserInRole(Permissions.EXPORT));
		createChildButton.setVisible(hasCreatePrivilege
				&& hasEditPrivilege
				&& (siteType.equals(UISiteType.LOGICAL)
						|| siteType.equals(UISiteType.DISTRIBUTION) || siteType
							.equals(UISiteType.MEDIAPATH_DISTRIBUTION)));
		addExistingButton.setVisible(hasEditPrivilege
				&& (siteType.equals(UISiteType.DISTRIBUTION) || siteType
						.equals(UISiteType.MEDIAPATH_DISTRIBUTION)));
		dissociateFromParentButton.setVisible(hasEditPrivilege
				&& siteType.equals(UISiteType.TRACKING) && site.isShared());
	}

	private void showLogicalSite(UISite site) {
		showCommonSiteInfo(site);
		showPartnerInfo(site);
	}

	public void showCreateLogicalSite() {
		site = new UISite();
		site.setType(UISiteType.LOGICAL);
		showLogicalSite(site);
		showCreateButtons();
	}

	private void showViewEditLogicalSite(UISite site) {
		showLogicalSite(site);
		showViewEditButtons(site);
	}

	private void showDistributionSite(UISite site) {
		showCommonSiteInfo(site);

		// clear
		fileLookupKeysValueWidget.clear();
		// set fileLookupKey items
		if (site.getAllFileLookupKeys() != null) {
			for (String fileLookupKey : site.getAllFileLookupKeys()) {
				fileLookupKeysValueWidget.addItem(fileLookupKey, fileLookupKey);
			}
		}
		// set selected fileLookupKey items
		if (site.getFileLookupKeys() != null) {
			for (String key : site.getFileLookupKeys()) {
				fileLookupKeysValueWidget.setItemSelected(new Item<String>(key,
						key), true);
			}
		}

		metadataFormatValueWidget.clear();
		for (String mf : site.getAllMetadataFormats()) {
			if (UISiteType.MEDIAPATH_DISTRIBUTION.equals(site.getType())) {
				if ((METADATA_FORMAT_CABLELABSVOD1_1.equals(mf))
						|| (METADATA_FORMAT_ALIAS_CABLELABSVOD1_1.equals(mf))) {
					metadataFormatValueWidget.addItem(mf, mf);
				}
			}
			else {
				metadataFormatValueWidget.addItem(mf, mf);				
			}
		}
		metadataFormatValueWidget.setSelectedItem(site.getMetadataFormat());
		// TODO handle the case when the selected item is not in the ALL list

		distOptionListBox.setEnabled(true);
		distOptionListBox.setSelectedItem(site.getDistributionOption());
		boolean isScheduleEnabled;
		if (isSchedulerLicensed
				&& (UIDistributionOption.TIMED.equals(site
						.getDistributionOption()))) {
			UIJob timerJob = site.getTimerJob();
			if (timerJob != null) {
				schedulingWidget.setScheduleInfo(timerJob.getScheduleInfo());
				if (!security
						.isUserInRole(com.ericsson.cms.scheduling.ui.client.Permissions.DELETE)) {
					UIDistributionOption selectedDistributionOption = distOptionListBox
							.getSelectedItem();
					if (UIDistributionOption.TIMED
							.equals(selectedDistributionOption)) {
						distOptionListBox.setEnabled(false);
					}
				}
				isScheduleEnabled = security
						.isUserInRole(com.ericsson.cms.scheduling.ui.client.Permissions.EDIT);
			}
			else {
				isScheduleEnabled = security
						.isUserInRole(com.ericsson.cms.scheduling.ui.client.Permissions.CREATE);
			}
			schedulingWidget.setEnabled(isScheduleEnabled);
			boolean isScheduleVisible = (security
					.isUserInRole(com.ericsson.cms.scheduling.ui.client.Permissions.CREATE) && (timerJob == null))
					|| (security
							.isUserInRole(com.ericsson.cms.scheduling.ui.client.Permissions.VIEW) && (timerJob != null))
					|| (security
							.isUserInRole(com.ericsson.cms.scheduling.ui.client.Permissions.EDIT) && (timerJob != null))
					|| (security
							.isUserInRole(com.ericsson.cms.scheduling.ui.client.Permissions.DELETE) && (timerJob != null));
			schedulingWidget.setVisible(isScheduleVisible);
		} else {
			schedulingWidget.setScheduleInfo(null);
			schedulingWidget.setEnabled(false);
			schedulingWidget.setVisible(false);
		}

		distConfPanel.setData(site.getAllTemplatesInfo(),
				site.getDistTemplateName(), site.getAssociatedGroupName(), site.getDistConfParams(),
				site.getAssociatedResourceId());

		exportConfPanel.setData(site.getAllExportPluginsInfo(),
				site.getExportPluginName(), site.getExportConfParams());

		alertDelayPeriodTextWidget
				.setText(site.getAlertDelayPeriod() == null ? "" : Integer
						.toString(site.getAlertDelayPeriod()));

		// Show Distribution status Plugin
		showStatusPlugin(site.getId(), UIStatusPluginType.DISTRIBUTION_STATUS,
				distStatusPluginPanel);

		// Show Deployment Status Plugin
		showStatusPlugin(site.getId(), UIStatusPluginType.DEPLOYMENT_STATUS,
				deplStatusPluginPanel);
		
		showPartnerInfo(site);
	}

	public void showCreateDistributionSite(final Integer parentSiteId) {
		/*
		 * setSelected() is called immediately after this method returns.
		 * setSelected() resets the anchor as per site instance variable.
		 * Setting dummy site data until this method's getNew() async call
		 * returns.
		 */
		site = new UISite();
		site.setType(UISiteType.DISTRIBUTION);
		busyIndicator.center();
		service.getNew(new NeptuneAsyncCallback<UISite>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				showErrorMessage(constants.loadingAllListsFailed()
						+ getFailureMessageSuffix(caught));
				busyIndicator.hide();
			}

			@Override
			public void onNeptuneSuccess(UISite newSite) {
				newSite.setType(UISiteType.DISTRIBUTION);
				newSite.setParentId(parentSiteId);
				BasicTab.this.site = newSite;
				schedulingWidget.setScheduleInfo(null);
				schedulingWidget.setVisible(false);
				showDistributionSite(BasicTab.this.site);
				showCreateButtons();
				busyIndicator.hide();
			}
		});
	}

	public void showCreateMediaPathDistributionSite(final Integer parentSiteId) {
		/*
		 * setSelected() is called immediately after this method returns.
		 * setSelected() resets the anchor as per site instance variable.
		 * Setting dummy site data until this method's getNew() async call
		 * returns.
		 */
		site = new UISite();
		site.setType(UISiteType.MEDIAPATH_DISTRIBUTION);
		busyIndicator.center();
		service.getNew(new NeptuneAsyncCallback<UISite>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				showErrorMessage(constants.loadingAllListsFailed()
						+ getFailureMessageSuffix(caught));
				busyIndicator.hide();
			}

			@Override
			public void onNeptuneSuccess(UISite newSite) {
				newSite.setType(UISiteType.MEDIAPATH_DISTRIBUTION);
				newSite.setParentId(parentSiteId);
				BasicTab.this.site = newSite;
				schedulingWidget.setScheduleInfo(null);
				schedulingWidget.setVisible(false);
				showDistributionSite(BasicTab.this.site);
				showCreateButtons();
				busyIndicator.hide();
			}
		});
	}

	/**
	 * @return the messageArea
	 */
	public MessageArea getMessageArea() {
		return messageArea;
	}

	/**
	 * @param messageArea the messageArea to set
	 */
	public void setMessageArea(MessageArea messageArea) {
		this.messageArea = messageArea;
		this.partnerInfoPanel.setMessageArea(messageArea);
	}

	private void showViewEditDistributionSite(UISite site) {
		showDistributionSite(site);
		showViewEditButtons(site);
	}

	private void showTrackingSite(UISite site) {
		showCommonSiteInfo(site);
		alertDelayPeriodTextWidget
				.setText(site.getAlertDelayPeriod() == null ? "" : Integer
						.toString(site.getAlertDelayPeriod()));

		// Show Deployment Status Plugin
		showStatusPlugin(site.getId(), UIStatusPluginType.DEPLOYMENT_STATUS,
				deplStatusPluginPanel);
	}

	public void showCreateTrackingSite(int parentSiteId) {
		site = new UISite();
		site.setType(UISiteType.TRACKING);
		site.setParentId(parentSiteId);
		showTrackingSite(site);
		showCreateButtons();
	}

	private void showViewEditTrackingSite(UISite site) {
		showTrackingSite(site);
		showViewEditButtons(site);
	}

	@Override
	public boolean setSite(UISite site, Map<String, String> params) {
		internalSetSite(site);
		if (site == null)
			showNoSiteSelectedLabel();
		return true;
	}

	private void internalSetSite(UISite site) {
		this.site = site;
		if (site == null)
			return;
		switch (site.getType()) {
		case LOGICAL:
			showViewEditLogicalSite(site);
			break;
		case DISTRIBUTION:
		case MEDIAPATH_DISTRIBUTION:
			showViewEditDistributionSite(site);
			break;
		case TRACKING:
			showViewEditTrackingSite(site);
			break;
		}
	}

	public void showStatusPlugin(final Integer siteId,
			final UIStatusPluginType uiStatusPluginType,
			final StatusPluginPanel statusPluginPanel) {
		statusPluginPanel.reset();
		service.getStatusPlugins(uiStatusPluginType,
				new NeptuneAsyncCallback<List<UIStatusPlugin>>() {
					@Override
					public void onNeptuneFailure(Throwable caught) {
						busyIndicator.hide();
						showErrorMessage(messages
								.loadStatusPluginFailed(siteId)
								+ getFailureMessageSuffix(caught));
					}

					@Override
					public void onNeptuneSuccess(
							List<UIStatusPlugin> uiStatusPlugins) {
						statusPluginPanel.setAvailablePlugins(uiStatusPlugins);
					}
				});

		if (siteId != null) {
			service.getAssociatedPluginForSite(siteId, uiStatusPluginType,
					new NeptuneAsyncCallback<UIStatusPlugin>() {
						@Override
						public void onNeptuneFailure(Throwable caught) {
							busyIndicator.hide();
							showErrorMessage(messages
									.loadStatusPluginFailed(siteId)
									+ getFailureMessageSuffix(caught));
						}

						@Override
						public void onNeptuneSuccess(
								UIStatusPlugin uiStatusPlugin) {
							statusPluginPanel
									.setAssociatedPlugin(uiStatusPlugin);
							busyIndicator.hide();
						}
					});
		} else {
			service.getBlankUiStatusPlugin(uiStatusPluginType,
					new NeptuneAsyncCallback<UIStatusPlugin>() {
						@Override
						public void onNeptuneFailure(Throwable caught) {
							busyIndicator.hide();
							showErrorMessage(messages
									.loadBlankStatusPluginFailed()
									+ getFailureMessageSuffix(caught));
						}

						@Override
						public void onNeptuneSuccess(
								UIStatusPlugin uiStatusPlugin) {
							statusPluginPanel
									.setAssociatedPlugin(uiStatusPlugin);
							busyIndicator.hide();
						}
					});
		}

	}

	private UISite getSiteFromForm() {
		UISite site = new UISite();
		site.setId(this.site.getId());
		site.setParentId(this.site.getParentId());
		site.setName(nameValueWidget.getText().trim());
		site.setType(siteTypeValueWidget.getSelectedItem());
		site.setExternalId(externalIdValueWidget.getText());
		site.setDescription(descriptionValueWidget.getText());

		if ((site.getType() == UISiteType.DISTRIBUTION) || (site.getType() == UISiteType.MEDIAPATH_DISTRIBUTION)) {
			List<String> selectedFileLookupKeys = new ArrayList<String>();
			for (Item<String> selectedItem : fileLookupKeysValueWidget
					.getSelectedItems()) {
				selectedFileLookupKeys.add(selectedItem.getValue());
			}
			site.setFileLookupKeys(selectedFileLookupKeys);

			site.setMetadataFormat(metadataFormatValueWidget.getSelectedItem());

			site.setDistributionOption(distOptionListBox.getSelectedItem());
			if (UIDistributionOption.TIMED.equals(distOptionListBox
					.getSelectedItem())) {
				UIJob timerJob = this.site.getTimerJob();
				if (timerJob == null) {
					timerJob = new UIJob();
				}
				ScheduleInfo scheduleInfo = schedulingWidget.getScheduleInfo();
				timerJob.setScheduleInfo(scheduleInfo);
				site.setTimerJob(timerJob);
			}
			site.setDistConfParams(distConfPanel.getParamValues());
			site.setAssociatedResourceId(distConfPanel.getAssociatedResource());
			site.setDistTemplateName(distConfPanel.getSelectedTemplateName());
			site.setAssociatedGroupName(distConfPanel.getAssociatedGroupName());
			site.setExportPluginName(exportConfPanel.getSelectedPluginName());
			site.setExportConfParams(exportConfPanel.getParams());
		}

		if (site.getType() == UISiteType.DISTRIBUTION
				|| site.getType() == UISiteType.MEDIAPATH_DISTRIBUTION
				|| site.getType() == UISiteType.TRACKING) {
			Integer delayPeriodInt = null;
			if (!isBlank(alertDelayPeriodTextWidget.getText())) {
				try {
					delayPeriodInt = Integer
							.parseInt(alertDelayPeriodTextWidget.getText());
				} catch (Exception e) {
				}
			}
			site.setAlertDelayPeriod(delayPeriodInt);
		}

		site.setDistUiStatusPlugin(distStatusPluginPanel.getAssociatedPlugin());
		site.setDeplUiStatusPlugin(deplStatusPluginPanel.getAssociatedPlugin());

		// If non-Tracking site, get partner info if any provided.
		if (site.getType() != UISiteType.TRACKING) {
			UISitePartner uiSitePartner = partnerInfoPanel.getPartnerFromForm();
			site.setSitePartner(uiSitePartner);
		}
		
		return site;
	}

	private List<String> validateBasicInfo() {
		final List<String> validationErrors = new ArrayList<String>();

		String siteName = nameValueWidget.getText();
		UISiteType siteType = siteTypeValueWidget.getSelectedItem();
		String externalId = externalIdValueWidget.getText();
		String description = descriptionValueWidget.getText();
		String metadataFormat = metadataFormatValueWidget.getSelectedItem();
		UIDistributionOption uiDistributionOption = distOptionListBox
				.getSelectedItem();
		String distributionConfiguration = distConfPanel
				.getSelectedTemplateName();
		String strAlertDelayPeriod = alertDelayPeriodTextWidget.getText();
		UIStatusPlugin distributionStatusPlugin = distStatusPluginPanel
				.getAssociatedPlugin();

		if ((isBlank(siteName)) && (siteNameValidationErrors.isEmpty())) {
			siteNameValidationErrors.add(constants.nameIsRequired());
		}

		validationErrors.addAll(siteNameValidationErrors);

		if ((isBlank(externalId)) && (externalSiteIdValidationErrors.isEmpty())) {
			externalSiteIdValidationErrors
					.add(constants.externalIdIsRequired());
		}

		validationErrors.addAll(externalSiteIdValidationErrors);

		if (!isBlank(description)) {
			int lengthDescription = description.length();
			int maxLengthDescription = constants.maxLengthSiteDescription();
			if (lengthDescription > maxLengthDescription) {
				validationErrors.add(messages
						.siteDescriptionCannotBeLonger(maxLengthDescription));
			}
		}

		if (UISiteType.DISTRIBUTION.equals(siteType) || UISiteType.MEDIAPATH_DISTRIBUTION.equals(siteType)) {
			List<Item<String>> items = fileLookupKeysValueWidget.getSelectedItems();
			if(items == null || items.isEmpty()) {
				validationErrors.add(constants.fileLookupKeysIsRequired());
			}

			if (isBlank(metadataFormat)) {
				validationErrors.add(constants.metadataFormatIsRequired());
			}

			if (uiDistributionOption == null) {
				validationErrors.add(constants.distributionOptionIsRequired());
			}

			if (schedulingWidget.isVisible() && schedulingWidget.isEnabled()) {
				List<String> schedulingWidgetValidationErrors = schedulingWidget
						.validate();
				validationErrors.addAll(schedulingWidgetValidationErrors);
			}

			if (isBlank(distributionConfiguration)) {
				validationErrors.add(constants
						.distributionConfigurationIsRequired());
			} else {
				List<String> distConfValidationErrors = distConfPanel
						.validate();
				if ((distConfValidationErrors != null)
						&& (!distConfValidationErrors.isEmpty())) {
					validationErrors.addAll(distConfValidationErrors);
				}
			}

			if (isDistStatusPluginRequired && isBlank(distributionStatusPlugin)) {
				validationErrors.add(constants.distStatusPluginIsRequired());
			}
		}

		if ((UISiteType.DISTRIBUTION.equals(siteType))
				|| (UISiteType.MEDIAPATH_DISTRIBUTION.equals(siteType))
				|| (UISiteType.TRACKING.equals(siteType))) {
			if (isBlank(strAlertDelayPeriod)) {
				validationErrors.add(constants.alertDelayPeriodIsRequired());
			} else {
				int minValueAlertDelayPeriod = constants
						.minValueSiteAlertDelayPeriod();
				int maxValueAlertDelayPeriod = constants
						.maxValueSiteAlertDelayPeriod();
				try {
					int alertDelayPeriod = Integer
							.parseInt(strAlertDelayPeriod);

					if (!((alertDelayPeriod >= minValueAlertDelayPeriod) && (alertDelayPeriod <= maxValueAlertDelayPeriod))) {
						validationErrors.add(messages
								.siteAlertDelayPariodRequiredRange(
										minValueAlertDelayPeriod,
										maxValueAlertDelayPeriod));
					}
				} catch (Exception e) {
					validationErrors.add(messages
							.siteAlertDelayPariodRequiredRange(
									minValueAlertDelayPeriod,
									maxValueAlertDelayPeriod));
				}
			}
		}

		return validationErrors;
	}

	private List<String> validateForActivation() {
		final List<String> validationErrors = new ArrayList<String>();

		UISiteType siteType = siteTypeValueWidget.getSelectedItem();
		String externalId = externalIdValueWidget.getText();
		String metadataFormat = metadataFormatValueWidget.getSelectedItem();
		String distTemplateName = distConfPanel.getSelectedTemplateName();
		String strAlertDelayPeriod = alertDelayPeriodTextWidget.getText();
		UIStatusPlugin distStatusPlugin = distStatusPluginPanel.getAssociatedPlugin();

		if ((isBlank(externalId)) && (externalSiteIdValidationErrors.isEmpty())) {
			externalSiteIdValidationErrors.add(constants.externalIdIsRequired());
		}

		validationErrors.addAll(externalSiteIdValidationErrors);

		if (UISiteType.DISTRIBUTION.equals(siteType)
				|| UISiteType.MEDIAPATH_DISTRIBUTION.equals(siteType)) {
			List<Item<String>> items = fileLookupKeysValueWidget.getSelectedItems();
			if(items == null || items.isEmpty()) {
				validationErrors.add(constants.fileLookupKeysIsRequired());
			}
			
			if (isBlank(metadataFormat)) {
				validationErrors.add(constants.metadataFormatIsRequired());
			}

			if (isBlank(distTemplateName)) {
				validationErrors.add(constants
						.distributionConfigurationIsRequired());
			}

			if (isDistStatusPluginRequired && isBlank(distStatusPlugin)) {
				validationErrors.add(constants.distStatusPluginIsRequired());
			}
		}

		if ((UISiteType.DISTRIBUTION.equals(siteType))
				|| (UISiteType.MEDIAPATH_DISTRIBUTION.equals(siteType))
				|| (UISiteType.TRACKING.equals(siteType))) {
			if (isBlank(strAlertDelayPeriod)) {
				validationErrors.add(constants.alertDelayPeriodIsRequired());
			} else {
				int minValueAlertDelayPeriod = constants
						.minValueSiteAlertDelayPeriod();
				int maxValueAlertDelayPeriod = constants
						.maxValueSiteAlertDelayPeriod();
				try {
					int alertDelayPeriod = Integer
							.parseInt(strAlertDelayPeriod);

					if (!((alertDelayPeriod >= minValueAlertDelayPeriod)
							&& (alertDelayPeriod <= maxValueAlertDelayPeriod))) {
						validationErrors.add(messages
								.siteAlertDelayPariodRequiredRange(
										minValueAlertDelayPeriod,
										maxValueAlertDelayPeriod));
					}
				} catch (Exception e) {
					validationErrors.add(messages
							.siteAlertDelayPariodRequiredRange(
									minValueAlertDelayPeriod,
									maxValueAlertDelayPeriod));
				}
			}
		}

		return validationErrors;
	}

	private void validateSiteName(String siteName) {
		siteNameValidationErrors = new ArrayList<String>();

		if (isBlank(siteName)) {
			siteNameValidationErrors.add(constants.nameIsRequired());
		} else {
			siteName = siteName.trim();
			int lengthSiteName = siteName.length();
			int maxLengthSiteName = constants.maxLengthSiteName();
			if (lengthSiteName > maxLengthSiteName) {
				siteNameValidationErrors.add(messages
						.siteNameCannotBeLonger(maxLengthSiteName));
			} else {
				if ((this.site.getId() == null)
						|| (!siteName.equals(this.site.getName()))) {
					service.isSiteNameAlreadyUsed(siteName,
							new NeptuneAsyncCallback<Boolean>() {

								@Override
								public void onNeptuneFailure(Throwable caught) {
									showErrorMessage(constants
											.failedCheckingSiteNameUniqueness()
											+ getFailureMessageSuffix(caught));
								}

								@Override
								public void onNeptuneSuccess(
										Boolean isSiteNameAlreadyUsed) {
									busyIndicator.hide();
									if (isSiteNameAlreadyUsed) {
										siteNameValidationErrors.add(constants
												.nameRequiredUnique());
									}

									if (!siteNameValidationErrors.isEmpty()) {
										setValidationErrors("Site Name Validation Failed: ", siteNameValidationErrors, null);
									} else {
										setErrorMessage("");
									}

								}
							});
				}

			}
		}

		if (!siteNameValidationErrors.isEmpty()) {
			setValidationErrors("Site Name Validation Failed: ", siteNameValidationErrors, null);
		} else {
			setErrorMessage("");
		}

	}

	private void validateExternalSiteId(final String externalSiteId) {
		externalSiteIdValidationErrors = new ArrayList<String>();

		if (isBlank(externalSiteId)) {
			externalSiteIdValidationErrors
					.add(constants.externalIdIsRequired());
		} else {
			int lengthExternalSiteId = externalSiteId.length();
			int maxLengthExternalSiteId = constants.maxLengthSiteExternalId();
			if (lengthExternalSiteId > maxLengthExternalSiteId) {
				externalSiteIdValidationErrors.add(messages
						.siteExternalIdCannotBeLonger(maxLengthExternalSiteId));
			} else {
				if ((this.site.getId() == null)
						|| (!externalSiteId.equals(this.site.getExternalId()))) {
					service.isExternalSiteIdAlreadyUsed(externalSiteId,
							this.site.getType(),
							new NeptuneAsyncCallback<Boolean>() {

								@Override
								public void onNeptuneFailure(Throwable caught) {
									showErrorMessage(constants
											.failedCheckingSiteExternalIdUniqueness()
											+ getFailureMessageSuffix(caught));
								}

								@Override
								public void onNeptuneSuccess(
										Boolean isExternalSiteIdAlreadyUsed) {
									busyIndicator.hide();
									if (isExternalSiteIdAlreadyUsed) {
										externalSiteIdValidationErrors.add(messages
												.externalIdAlreadyInUse(externalSiteId));
									}

									if (!externalSiteIdValidationErrors
											.isEmpty()) {
										setValidationErrors("External Site Id Validation Failed: ",
												externalSiteIdValidationErrors, null);
									} else {
										setErrorMessage("");
									}

								}
							});
				}

			}
		}

		if (!externalSiteIdValidationErrors.isEmpty()) {
			setValidationErrors("External Site Id Validation Failed: ",
					externalSiteIdValidationErrors, null);
		} else {
			setErrorMessage("");
		}

	}

	private boolean isBlank(String s) {
		return (s == null || s.trim().isEmpty());
	}

	private boolean isBlank(UIStatusPlugin uiStatusPlugin) {
		boolean isBlank = false;

		if (uiStatusPlugin == null) {
			isBlank = true;
		} else {
			String pluginId = uiStatusPlugin.getId();
			if ((pluginId == null) || (pluginId.trim().isEmpty())) {
				isBlank = true;
			}
		}
		return isBlank;
	}

	private void save() {
		// TODO clear info/error messages before all actions
		final List<String> validationErrors = validateBasicInfo();

		UISiteType siteType = siteTypeValueWidget.getSelectedItem();
		if (!UISiteType.TRACKING.equals(siteType)) {
			partnerInfoPanel.validate(new AsyncCallback<List<String>>() {
				@Override
				public void onFailure(Throwable caught) {
					setErrorMessage("Unable to validate partner information. | Reason: "
							+ caught != null ? caught.getLocalizedMessage()
							: null);
				}

				@Override
				public void onSuccess(List<String> errors) {
					validationErrors.addAll(errors);
					saveToServer(validationErrors);
				}
			});
		}
		else {
			saveToServer(validationErrors);
		}

	}

	private void saveToServer(List<String> validationErrors) {
		if (!validationErrors.isEmpty()) {
			setValidationErrors("Validation Failed: ",
					validationErrors, null);
		} else {
			final UISite site = getSiteFromForm();
			// If the distribution mode of an existing active site is changed to
			// IMMEDIATE notify the user that all ready to distribute titles will be
			// distributed
			if (this.site != null
					&& this.site.isActive()
					&& this.site.getDistributionOption() != UIDistributionOption.IMMEDIATE
					&& site.getDistributionOption() == UIDistributionOption.IMMEDIATE) {
				confirm(constants.confirmTitleDistribution(),
						new Command() {
							@Override
							public void execute() {
								saveToServer(site);
							}
						}, null);
			} else {
				saveToServer(site);
			}
		}
	}

	private void saveToServer(final UISite site) {
		busyIndicator.center();
		service.save(site, new NeptuneAsyncCallback<UISite>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				setInfoMessage(null);
				setErrorMessage(constants.saveFailed()
						+ getFailureMessageSuffix(caught));
				busyIndicator.hide();
			}

			@Override
			public void onNeptuneSuccess(UISite result) {
				internalSetSite(result);
				setInfoMessage(constants.saveSuccessful());
				setErrorMessage(null);
				if (site.getId() == null)
					crudNotifier.created(result, BasicTab.this);
				else
					crudNotifier.updated(result, BasicTab.this);
				busyIndicator.hide();
			}
		});
	}

	private void confirm(String questionText, final Command yesCommand,
			final Command noCommand) {
		ConfirmDialog confirmDialog = new ConfirmDialog(questionText, yesCommand, noCommand);
		confirmDialog.center();
		confirmDialog.show();
	}

	private void alert(String text, final Command command) {
		final DialogBoxContainer dialogBox = new DialogBoxContainer(false, true);
		dialogBox.addStyleName(STYLE_DIALOG_BOX);
		dialogBox.setText(text);

		// ok button
		ButtonWidget okButton = new ButtonWidget(constants.buttonLabelOk());
		okButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
		okButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				dialogBox.hide();
				if(command != null)
					command.execute();
			}
		});
		
		// panel which contains the buttons
		HorizontalContainer buttonPanel = new HorizontalContainer();
		buttonPanel.addStyleName(STYLE_DIALOG_BOX_BUTTON_PANEL);
		buttonPanel.setCellHorizontalAlignment(okButton,
				HorizontalPanel.ALIGN_CENTER);
		dialogBox.setWidget(buttonPanel);
		buttonPanel.add(okButton);

		dialogBox.center();
		dialogBox.show();
	}
	
	private void activateAfterConfirming() {
		if (site.hasChildren()) {
			confirm(constants.confirmRecursiveActivate(), new Command() {
				@Override
				public void execute() {
					activate();
				}
			}, null);
		} else {
			activate();
		}
	}

	private void activate() {
		internalSetSite(site);
		List<String> validationErrors = validateForActivation();
		if (!validationErrors.isEmpty()) {
			setValidationErrors("Validation Failed: ", validationErrors,
					"Fix the validation errors, save the site and try activating again.");
			return;
		}

		// show a notification that for distribution sites with immediate mode
		// of distribution, ready to distribute titles will be distributed.
		if (((site.getType() == UISiteType.DISTRIBUTION) || (site.getType() == UISiteType.MEDIAPATH_DISTRIBUTION))
				&& (site.getDistributionOption() == UIDistributionOption.IMMEDIATE)) {
			alert(constants.activationTitleNotification(), new Command() {
				@Override
				public void execute() {
					performSiteActivation();
				}
			});
		} else {
			performSiteActivation();
		}
	}

	private void performSiteActivation() {
		busyIndicator.center();
		service.activate(site.getId(), new NeptuneAsyncCallback<Void>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				busyIndicator.hide();
				setInfoMessage(null);
				setErrorMessage(constants.activateFailed()
						+ getFailureMessageSuffix(caught));
			}

			@Override
			public void onNeptuneSuccess(Void result) {
				setErrorMessage(null);
				setInfoMessage(constants.activateSuccessful());
				// update the instance variable site
				site.setActive(true);
				// update status image
				siteActiveImage.setVisible(true);
				siteInactiveImage.setVisible(false);
				// update buttons
				activateButton.setVisible(false);
				inactivateButton.setVisible(true);
				crudNotifier.updated(site, BasicTab.this);
				busyIndicator.hide();
				if (security
						.isUserInRole(com.ericsson.cms.scheduling.ui.client.Permissions.VIEW)) {
					// enableSiteJobsAfterConfirming();
					alert(constants.notifyJobsMayNeedEnabling(), new Command() {
						@Override
						public void execute() {
							updateStatusForAllPluginsAfterConfirming();
						}
					});
				}
				else {
					updateStatusForAllPluginsAfterConfirming();
				}
			}
		});
	}

	// TODO: Uncomment this and start using once there is suitable api on
	// scheduler backend.
	// private void enableSiteJobsAfterConfirming() {
	// confirm(constants.confirmEnableJobs(), new Command() {
	// @Override
	// public void execute() {
	// enableSiteJobs();
	// }}, null);
	// }
	//
	// private void enableSiteJobs() {
	// busyIndicator.center();
	// service.enableSiteJobs(site.getId(), new NeptuneAsyncCallback<Void>() {
	//
	// @Override
	// public void onNeptuneFailure(Throwable caught) {
	// busyIndicator.hide();
	// setErrorMessage(constants.enableJobsFailed() +
	// getFailureMessageSuffix(caught));
	// }
	//
	// @Override
	// public void onNeptuneSuccess(Void result) {
	// setInfoMessage(constants.enableJobsSuccessful());
	// busyIndicator.hide();
	// }
	//
	// });
	// }

	private void updateStatusForAllPluginsAfterConfirming() {
		confirm(constants.confirmUpdateStatus(), new Command() {
			@Override
			public void execute() {
				updateStatusForAllPlugins();
			}
		}, null);
	}

	private void updateStatusForAllPlugins() {
		busyIndicator.center();
		service.updateStatusForAllPlugins(site.getId(),
				new NeptuneAsyncCallback<Void>() {
					@Override
					public void onNeptuneFailure(Throwable caught) {
						busyIndicator.hide();
						setErrorMessage(constants.updateStatusFailed()
								+ getFailureMessageSuffix(caught));
					}

					@Override
					public void onNeptuneSuccess(Void result) {
						setInfoMessage(constants.updateStatusSuccessful());
						busyIndicator.hide();
					}
				});
	}

	private void inactivateAfterConfirming() {
		if (site.hasChildren()) {
			confirm(constants.confirmRecursiveInactivate(), new Command() {
				@Override
				public void execute() {
					inactivate();
				}
			}, null);
		} else {
			inactivate();
		}
	}

	private void inactivate() {
		internalSetSite(site);
		busyIndicator.center();
		service.inactivate(site.getId(), new NeptuneAsyncCallback<Void>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				busyIndicator.hide();
				setInfoMessage(null);
				setErrorMessage(constants.inactivateFailed()
						+ getFailureMessageSuffix(caught));
			}

			@Override
			public void onNeptuneSuccess(Void result) {
				setErrorMessage(null);
				setInfoMessage(constants.inactivateSuccessful());
				// update the instance variable site
				site.setActive(false);
				// update status image
				siteActiveImage.setVisible(false);
				siteInactiveImage.setVisible(true);
				// update buttons
				activateButton.setVisible(true);
				inactivateButton.setVisible(false);
				crudNotifier.updated(site, BasicTab.this);
				busyIndicator.hide();
				if (security
					.isUserInRole(com.ericsson.cms.scheduling.ui.client.Permissions.VIEW)) {
					// disableSiteJobsAfterConfirming();
					alert(constants.notifyJobsMayNeedDisabling(), null);
				}
			}
		});
	}

	// TODO: Uncomment this and start using once there is suitable api on
	// scheduler backend.
	// private void disableSiteJobsAfterConfirming() {
	// confirm(constants.confirmDisableJobs(), new Command() {
	// @Override
	// public void execute() {
	// disableSiteJobs();
	// }}, null);
	// }
	//
	// private void disableSiteJobs() {
	// busyIndicator.center();
	// service.disableSiteJobs(site.getId(), new NeptuneAsyncCallback<Void>() {
	//
	// @Override
	// public void onNeptuneFailure(Throwable caught) {
	// busyIndicator.hide();
	// setErrorMessage(constants.disableJobsFailed() +
	// getFailureMessageSuffix(caught));
	// }
	//
	// @Override
	// public void onNeptuneSuccess(Void result) {
	// setInfoMessage(constants.disableJobsSuccessful());
	// busyIndicator.hide();
	// }
	//
	// });
	// }

	private void delete() {
		busyIndicator.center();
		service.delete(site.getId(), new NeptuneAsyncCallback<Void>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				busyIndicator.hide();
				setInfoMessage(null);
				setErrorMessage(constants.deleteFailed()
						+ getFailureMessageSuffix(caught));
			}

			@Override
			public void onNeptuneSuccess(Void result) {
				UISite deletedSite = site;
				internalSetSite(null);
				setErrorMessage(null);
				showInfoMessage(constants.deleteSuccessful());
				showNoSiteSelectedLabel();
				crudNotifier.deleted(deletedSite, BasicTab.this);
				busyIndicator.hide();
			}
		});
	}

	private void showExportDialog() {
		ExportStatusSelectionDialog dialogBox = new ExportStatusSelectionDialog(
				new IExportActionHandler() {
					@Override
					public void export(List<UIDistributionStatus> statuses) {
						if (statuses == null || statuses.isEmpty()) {
							setInfoMessage(null);
							setErrorMessage(constants.exportNoneSelected());
						} else {
							BasicTab.this.export(statuses);
						}
					}
				});
		dialogBox.addStyleName(STYLE_DIALOG_BOX);
		dialogBox.center();
	}

	private void export(List<UIDistributionStatus> statuses) {
		busyIndicator.center();
		service.export(site.getId(), statuses,
				new NeptuneAsyncCallback<String>() {
					@Override
					public void onNeptuneFailure(Throwable caught) {
						busyIndicator.hide();
						setInfoMessage(null);
						setErrorMessage(constants.exportFailed()
								+ getFailureMessageSuffix(caught));
					}

					@Override
					public void onNeptuneSuccess(String result) {
						setErrorMessage(null);
						setInfoMessage(null);
						busyIndicator.hide();
						Window.Location.replace("ExportSiteTitles?filePath="
								+ URL.encode(result));
					}
				});
	}

	private void createChildSite(final ClickEvent event) {
		UISiteType siteType = site.getType();
		Integer parentSiteId = site.getId();
		String siteName = site.getName();
		if (UISiteType.LOGICAL.equals(siteType)) {
			UISiteTreeNode siteTreeNode = new UISiteTreeNode();
			siteTreeNode.setId(parentSiteId);
			siteTreeNode.setType(siteType);
			siteTreeNode.setName(siteName);
			final CreateSiteDialogBox createSiteDialogBox = new CreateSiteDialogBox(security, true, true, parentTabContainer, siteTreeNode);
			createSiteDialogBox.setPopupPositionAndShow(new PopupPanel.PositionCallback() {
		          public void setPosition(int offsetWidth, int offsetHeight) {
						Button source =  (Button) event.getSource();
						int left = source.getAbsoluteLeft() + source.getOffsetWidth();
						int top = source.getAbsoluteTop() - offsetHeight;
						createSiteDialogBox.setPopupPosition(left, top);
		          }
			});
		} 
		else if (UISiteType.DISTRIBUTION.equals(siteType)
				|| UISiteType.MEDIAPATH_DISTRIBUTION.equals(siteType)) {
			parentTabContainer.showCreateTrackingSite(parentSiteId);
		}

	}
	
	private void addExistingSite() {
		Integer siteId = site.getId();
		parentTabContainer.showAddExistingTrackingSite(siteId);
	}
	
	private void dissociate() {
		Integer trackingSiteId = site.getId();
		Integer parentDistSiteId = site.getParentId();
		dissociateAfterConfirming(trackingSiteId, parentDistSiteId);
	}
	
	private void dissociateAfterConfirming(final int trackingSiteId, final int parentDistSiteId) {
		confirm(constants.confirmDissociate(), new Command() {
			@Override
			public void execute() {
				dissociateFromParent(trackingSiteId, parentDistSiteId);
			}
		}, null);
	}
	
	private void dissociateFromParent(int trackingSiteId, final int parentDistSiteId) {
		busyIndicator.center();
		service.dissociateTrackingSite(trackingSiteId, parentDistSiteId, new NeptuneAsyncCallback<Void>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				busyIndicator.hide();
				Window.alert(constants.dissociatingTrackingSiteFailed() + " | " + constants.reason() + ": " + (caught != null ? caught.getLocalizedMessage() : ""));
			}

			@Override
			public void onNeptuneSuccess(Void result) {
				treeWidget.reload(parentDistSiteId, null);
				parentTabContainer.showSite(parentDistSiteId, null);
				busyIndicator.hide();
			}});
	}

	protected SchedulingWidget getSchedulingWidget() {
		SchedulingWidgetConfig widgetConfig = new SchedulingWidgetConfig();
		widgetConfig.setShowOnDateRow(false);
		widgetConfig.setShowEveryNDaysRow(true);
		widgetConfig.setShowOnDayEveryNWeeksRow(true);
		widgetConfig.setShowNDaysFromMetadataRow(true);

		SchedulingWidget schedulingWidget = SchedulingWidgetFactory
				.create(widgetConfig);

		setMetadataTree(schedulingWidget);

		return schedulingWidget;
	}

	protected void setMetadataTree(final SchedulingWidget schedulingWidget) {
		if (schedulingWidget != null) {
			busyIndicator.center();
			service.getSiteTimerMetadataTree(new NeptuneAsyncCallback<UiMetadataTree>() {

				@Override
				public void onNeptuneFailure(Throwable caught) {
					busyIndicator.hide();
					showErrorMessage(messages.loadMetadataTreeFailed()
							+ getFailureMessageSuffix(caught));
				}

				@Override
				public void onNeptuneSuccess(UiMetadataTree result) {
					schedulingWidget.setMetadataTree(result);
					busyIndicator.hide();
				}

			});
		}
	}
	
	protected void updateScrollPanelSize() {
		Scheduler.get().scheduleDeferred(resizeCommand);
	}
	
	/*
	 * Resize the right scroll panel
	 */
	protected void resizeRightScrollPanel() {
		/* Calculate the size to use */
		int width = Window.getClientWidth() - 335;
		int height = Window.getClientHeight() - 280
				- messageArea.getOffsetHeight();

		/* Set the dimensions */
		rightScrollPanel.setPixelSize(
				width,
				height - buttonsPanel.getOffsetHeight());
		dockPanel.setPixelSize(width, height);
		messageArea.setWidth(width + "px");
	}

	// ==============================================================
	// ===================== WIDGET OVERRIDES
	// ==============================================================

	@Override
	protected void onLoad() {
		super.onLoad();

		windowRegistration = Window.addResizeHandler(new ResizeHandler() {
			public void onResize(ResizeEvent event) {
				updateScrollPanelSize();
			}
		});
	};

	@Override
	protected void onUnload() {
		windowRegistration.removeHandler();
		windowRegistration = null;

		if (busyIndicator != null)
			busyIndicator.hide();

		super.onUnload();
	}
}
