package com.ericsson.cms.sites.ui.client;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;

public class CheckboxGroup<T> extends Composite {
	
	public static class Item<T> {
		private String label;
		private T value;

		public Item(String label, T value) {
			this.label = label;
			this.value = value;
		}
		
		public String getLabel() {
			return label;
		}

		public void setLabel(String label) {
			this.label = label;
		}

		public T getValue() {
			return value;
		}

		public void setValue(T value) {
			this.value = value;
		}
		
		@Override
		public boolean equals(Object other) {
			if(!(other instanceof Item))
				return false;
			return value.equals(((Item<?>) other).value);
		}
		
		@Override
		public int hashCode() {
			return value.hashCode();
		}
	}
	
	private ScrollPanel scrollPanel;
	private VerticalPanel verticalPanel;
	private List<Item<T>> items;
	
	public CheckboxGroup() {
		scrollPanel = new ScrollPanel();
		scrollPanel.addStyleName("sites-basicTab-fileLookupKeys");
		verticalPanel = new VerticalPanel();
		scrollPanel.add(verticalPanel);
		items = new ArrayList<Item<T>>();
		initWidget(scrollPanel);
	}
	
	public void clear() {
		verticalPanel.clear();
		items.clear();
	}
	
	public void addItem(Item<T> item) {
		verticalPanel.add(new CheckBoxWidget(item.getLabel()));
		items.add(item);
	}
	
	public void addItem(String label, T value) {
		addItem(new Item<T>(label, value));
	}
	
	public void setItems(List<Item<T>> items) {
		clear();
		for(Item<T> item : items)
			addItem(item);
	}
	
	public List<Item<T>> getItems() {
		return items;
	}
	
	public List<Item<T>> getSelectedItems() {
		List<Item<T>> selectedItems = new ArrayList<Item<T>>();
		for(int i=0; i<verticalPanel.getWidgetCount(); ++i) {
			CheckBoxWidget cb = (CheckBoxWidget) verticalPanel.getWidget(i);
			if(cb.getValue())
				selectedItems.add(items.get(i));
		}
		return selectedItems;
	}

	public void setItemSelected(Item<T> item, boolean selected) {
		for(int i=0; i<items.size(); ++i) {
			if(items.get(i).equals(item)) {
				CheckBoxWidget cb = (CheckBoxWidget) verticalPanel.getWidget(i);
				cb.setValue(selected);
				break;
			}
		}
	}
}
