/**
 * File Name	:	ConfirmDialog.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Jun 18, 2012 7:10:31 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.sites.ui.client;

import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DialogBoxContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class ConfirmDialog extends DialogBoxContainer {

	private static final String STYLE_CONFIRM_DIALOG_BOX = "confirmDialogBox";
	private static final String STYLE_DIALOG_BOX_BUTTON_PANEL = "confirmDialogBoxButtonPanel";
	
	private SitesConstants constants = GWT.create(SitesConstants.class);

	public ConfirmDialog(String questionText, final Command yesCommand,
			final Command noCommand) {
		super(false, true);
		
		addStyleName(STYLE_CONFIRM_DIALOG_BOX);
		setText(questionText);

		// yes button
		ButtonWidget yesButton = new ButtonWidget(constants.buttonLabelYes());
		yesButton.addStyleDependentName(StyleNames.DO_BUTTON_STYLE);
		yesButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				hide();
				if (yesCommand != null)
					yesCommand.execute();
			}
		});

		// no button
		ButtonWidget noButton = new ButtonWidget(constants.buttonLabelNo());
		noButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		noButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				hide();
				if (noCommand != null)
					noCommand.execute();
			}
		});

		// panel which contains the buttons
		HorizontalContainer buttonPanel = new HorizontalContainer();
		buttonPanel.addStyleName(STYLE_DIALOG_BOX_BUTTON_PANEL);
		setWidget(buttonPanel);
		buttonPanel.add(yesButton);
		buttonPanel.setCellHorizontalAlignment(yesButton,
				HorizontalPanel.ALIGN_RIGHT);
		buttonPanel.add(noButton);
		buttonPanel.setCellHorizontalAlignment(noButton,
				HorizontalPanel.ALIGN_LEFT);
		
	}
}
