/**
 * File Name	:	CreateSiteDialogBox.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Jun 14, 2012 6:14:15 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.sites.ui.client;

import com.ericsson.cms.sites.ui.client.entities.UISiteTreeNode;
import com.ericsson.cms.sites.ui.client.entities.UISiteType;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class CreateSiteDialogBox extends DialogBox {

	RadioButton strbl; 	// Logical Site
	RadioButton strbd; 	// Distribution Site
	RadioButton strbm;	// Mediapath Distribution Site
	RadioButton strbt;	// Tracking Site
	
	private SitesTabContainer detailView; 

	private NeptuneSecurity security;
		
	private SitesConstants constants = GWT.create(SitesConstants.class);

	/**
	 * 
	 */
	public CreateSiteDialogBox(NeptuneSecurity security, SitesTabContainer detailView) {
		this(security, true, true, detailView, null);
	}

	/**
	 * @param autoHide
	 */
	public CreateSiteDialogBox(NeptuneSecurity security, boolean autoHide, SitesTabContainer detailView) {
		this(security, autoHide, true, detailView, null);
	}

	/**
	 * Create a Dialog Box to allow setting up a top level site.
	 * 
	 * @param autoHide
	 * @param modal
	 */
	public CreateSiteDialogBox(NeptuneSecurity security, boolean autoHide, boolean modal, SitesTabContainer detailView) {
		this(security, autoHide, modal, detailView, null);
	}

	/**
	 * Create a Dialog Box to allow setting up a site that is child of the given <code>uiSiteTreeNode></code>.
	 * 
	 * @param autoHide
	 * @param modal
	 * @param uiSiteTreeNode
	 */
	public CreateSiteDialogBox(NeptuneSecurity security, boolean autoHide, boolean modal, SitesTabContainer detailView, UISiteTreeNode uiSiteTreeNode) { 
		super(autoHide, modal);
		
		init(security, detailView, uiSiteTreeNode);
		
		String caption = null;

		if (uiSiteTreeNode != null) {
			String siteName = uiSiteTreeNode.getName();
			caption = constants.captionCreateChildSite() + " " + siteName;
			setText(caption);

			strbl.setEnabled(false);
			UISiteType siteType = uiSiteTreeNode.getType();
			if (siteType != null) {
				if (UISiteType.LOGICAL.equals(siteType)) {
					strbd.setEnabled(true);
					strbm.setEnabled(true);
					strbt.setEnabled(false);
					strbd.setValue(true);
					Scheduler.get().scheduleDeferred(new ScheduledCommand() {
				        public void execute () {
							strbd.setFocus(true);
				        }
				   });
				}
			}
		}
		else {
			strbt.setEnabled(false);
			strbl.setValue(true);
			Scheduler.get().scheduleDeferred(new ScheduledCommand() {
		        public void execute () {
					strbl.setFocus(true);
		        }
		   });
		}
		
	}

	private void init(NeptuneSecurity security, final SitesTabContainer detailView, final UISiteTreeNode uiSiteTreeNode) {
		Integer parentSiteId = null;
		if (uiSiteTreeNode != null) {
			parentSiteId = uiSiteTreeNode.getId();
		}
		init(security, detailView, parentSiteId);
	}	
	
	private void init(NeptuneSecurity security, final SitesTabContainer detailView, final Integer parentSiteId) {
		this.security = security;
		this.detailView = detailView;
		
		setText(constants.captionCreateTopLevelSite());

		setGlassEnabled(true);
		
		VerticalPanel mainPanel = new VerticalPanel();
		
		HorizontalPanel createInputsPanel = new HorizontalPanel();
		mainPanel.add(createInputsPanel);
		
		HorizontalPanel buttonsPanel = new HorizontalPanel();
		mainPanel.add(buttonsPanel);
		
		VerticalPanel siteTypePanel = new VerticalPanel();
		createInputsPanel.add(siteTypePanel);
		siteTypePanel.add(new Label(constants.fieldLabelSiteType()));

		VerticalPanel siteTypeRadioButtonsPanel = new VerticalPanel();
		strbl = new RadioButton("siteType", constants.fieldValueSiteTypeLogical());
		strbd = new RadioButton("siteType", constants.fieldValueSiteTypeDistribution());
		strbm = new RadioButton("siteType", constants.fieldValueSiteTypeMediaPathDistribution());
		strbt = new RadioButton("siteType", constants.fieldValueSiteTypeTracking());
		siteTypeRadioButtonsPanel.add(strbl);
		siteTypeRadioButtonsPanel.add(strbd);
		siteTypeRadioButtonsPanel.add(strbm);
		siteTypeRadioButtonsPanel.add(strbt);
		siteTypePanel.add(siteTypeRadioButtonsPanel);
		
		// A top level Tracking site cannot be created.
		strbt.setEnabled(false);
		
		Button okButton = new Button(constants.buttonLabelOk());
		buttonsPanel.add(okButton);
		okButton.addStyleDependentName(StyleNames.DO_BUTTON_STYLE);
		okButton.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				CreateSiteDialogBox.this.hide();
				
				if (strbl.getValue()) {
					detailView.showCreateLogicalSite();
				}
				else if (strbd.getValue()) {
					detailView.showCreateDistributionSite(parentSiteId);
				}
				else if (strbm.getValue()) {
					detailView.showCreateMediaPathDistributionSite(parentSiteId);
				}
				else if (strbt.getValue()) {
					detailView.showCreateTrackingSite(parentSiteId);
				}

			}
			
		});
		
		Button cancelButton = new Button(constants.buttonLabelCancel());
		buttonsPanel.add(cancelButton);
		cancelButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		cancelButton.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				CreateSiteDialogBox.this.hide();
			}
			
		});
		
		setWidget(mainPanel);
		
	}	

}
