/**
 * File Name	:	DistScheduleUISchedulerClient.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Mar 30, 2012 12:08:55 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.sites.ui.client;

import com.ericsson.cms.scheduling.ui.client.Action;
import com.ericsson.cms.scheduling.ui.client.IUISchedulerClient;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class DistScheduleUISchedulerClient implements IUISchedulerClient {

	private NeptuneSecurity security;

	public DistScheduleUISchedulerClient(NeptuneSecurity security) {
		this.security = security;
	}
	
	/* (non-Javadoc)
	 * @see com.ericsson.cms.scheduling.ui.client.IUISchedulerClient#getName()
	 */
	@Override
	public String getName() {
		return "DistributionSchedule";
	}

	/* (non-Javadoc)
	 * @see com.ericsson.cms.scheduling.ui.client.IUISchedulerClient#isUserAuthorized(com.ericsson.cms.scheduling.ui.client.Action)
	 */
	@Override
	public boolean isUserAuthorized(Action action) {
		switch(action) {
		case VIEW:
			return security.isUserInRole(Permissions.SCHEDULES_VIEW);
		case CREATE:
			return security.isUserInRole(Permissions.SCHEDULES_CREATE) && security.isUserInRole(Permissions.EDIT);
		case ACTIVATE:
		case INACTIVATE:
		case ENABLE_EXECUTION:
		case DISABLE_EXECUTION:
		case MODIFY:
			return security.isUserInRole(Permissions.SCHEDULES_MODIFY) && security.isUserInRole(Permissions.EDIT);
		case DELETE:
			return security.isUserInRole(Permissions.SCHEDULES_DELETE) && security.isUserInRole(Permissions.EDIT);
		case EXECUTE:
		default:
			return true;
		}
	}

}
