package com.ericsson.cms.sites.ui.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ericsson.cms.sites.ui.client.entities.UIExportPluginInfo;
import com.ericsson.cms.sites.ui.client.images.ISiteClientBundle;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class ExportConfPanel extends Composite {
	private VerticalContainer mainPanel;
	private HorizontalContainer listBoxContainer;
	private ImageWidget isNotLoadedImage;
	private ListBoxWidget<String> listBox;
	private FormContainer form;
	private Map<String, TextBoxWidget> paramWidgets = new HashMap<String, TextBoxWidget>();

	private ISiteClientBundle clientBundle = GWT.create(ISiteClientBundle.class);
	
	private Map<String, List<String>> exporterParamNamesMap = new HashMap<String, List<String>>();
	
	public ExportConfPanel() {
		mainPanel = new VerticalContainer();
		
		listBoxContainer = new HorizontalContainer();
		listBoxContainer.setSpacing(1);
		mainPanel.add(listBoxContainer);
		
		isNotLoadedImage = new ImageWidget();
		isNotLoadedImage.setResource(clientBundle.sitePluginConfigurationError());
		isNotLoadedImage.setVisible(false);
		listBoxContainer.add(isNotLoadedImage);
		
		listBox = new ListBoxWidget<String>();
		listBox.addChangeHandler(new ChangeHandler() {
			@Override
			public void onChange(ChangeEvent event) {
				if(isNotLoadedImage.isVisible()) {
					isNotLoadedImage.setVisible(false);
					for(int i=0; i<listBox.getItemCount(); ++i) {
						String item = listBox.getItem(i);
						if(item != null && !exporterParamNamesMap.containsKey(item)) {
							listBox.removeItem(item);
							break;
						}
					}
				}
				
				Map<String, String> params = new HashMap<String, String>();
				List<String> paramNames = exporterParamNamesMap.get(listBox.getSelectedItem());
				if(paramNames != null) {
					for(String paramName : paramNames) {
						params.put(paramName, null);
					}
				}
				drawParamFields(params);
			}});
		listBoxContainer.add(listBox);
		
		form = new FormContainer(HorizontalPanel.ALIGN_LEFT);
		mainPanel.add(form);

		initWidget(mainPanel);
	}
	
	/**
	 * Resets this panel to its newly constructed state.
	 */
	private void clear() {
		listBox.clear();
		exporterParamNamesMap.clear();
		drawParamFields(null);
	}
	
	public void setData(List<UIExportPluginInfo> allPluginsInfo, String selectedPluginName, Map<String, String> params) {
		clear();
		
		listBox.addItem("", null);
		for(UIExportPluginInfo pi : allPluginsInfo) {
			listBox.addItem(pi.getName(), pi.getName());
			exporterParamNamesMap.put(pi.getName(), pi.getParams());
		}
		
		/*
		 * if the selected plugin is not in the ALL list,
		 * raise a flag,
		 * show the selection and params. 
		 */
		if(listBox.getIndex(selectedPluginName) == -1) {
			isNotLoadedImage.setVisible(true);
			listBox.addItem(selectedPluginName, selectedPluginName);
			listBox.setSelectedItem(selectedPluginName);
			drawParamFields(params);
		} else {
			isNotLoadedImage.setVisible(false);
			listBox.setSelectedItem(selectedPluginName);
			/*
			 * if there are extra parameters that do not belong to the selected plugin
			 * they are not displayed.  
			 */
			Map<String, String> paramsToSetInUI = new HashMap<String, String>();
			List<String> associatedParams = exporterParamNamesMap.get(selectedPluginName);
			if(associatedParams != null) {
				for(String associatedParam : associatedParams) {
					String paramValue = (params != null) ? params.get(associatedParam): null;
					paramsToSetInUI.put(associatedParam, paramValue);
				}
			}
			drawParamFields(paramsToSetInUI);
		}
	}
	
	public String getSelectedPluginName() {
		return listBox.getSelectedItem();
	}
		
	public Map<String, String> getParams() {
		Map<String, String> params = new HashMap<String, String>();
		for(Map.Entry<String, TextBoxWidget> paramWidget : paramWidgets.entrySet()) {
			params.put(paramWidget.getKey(), paramWidget.getValue().getValue());
		}
		return params;
	}
	
	/**
	 * @param params	Parameters Name - Value map
	 */
	private void drawParamFields(Map<String, String> params) {
		mainPanel.remove(form);
		form = new FormContainer(HorizontalPanel.ALIGN_LEFT);
		mainPanel.add(form);
		paramWidgets.clear();

		if(params != null) {
			for(Map.Entry<String, String> param : params.entrySet()) {
				TextBoxWidget textBox = new TextBoxWidget();
				textBox.setValue(param.getValue());
				form.addRow(new LabelWidget(param.getKey()), textBox);
				paramWidgets.put(param.getKey(), textBox);
			}
		}
	}
}
