package com.ericsson.cms.sites.ui.client;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.DialogBox;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UIDistributionStatus;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class ExportStatusSelectionDialog extends DialogBox {
	public interface IExportActionHandler {
		void export(List<UIDistributionStatus> statuses);
	}
	
	private SitesConstants constants = GWT.create(SitesConstants.class);

	private CheckBoxWidget targetedStatusCB;
	private CheckBoxWidget readyForDistStatusCB;
	private CheckBoxWidget inProgressStatusCB;
	private CheckBoxWidget distributedStatusCB;
	private CheckBoxWidget failedStatusCB;
	
	private IExportActionHandler exportActionHandler;
	
	public ExportStatusSelectionDialog(IExportActionHandler exportActionHandler) {
		super(false, true);
		this.exportActionHandler = exportActionHandler;
		
		setText(constants.exportSelectStatusText());

		VerticalContainer mainPanel = new VerticalContainer();
		mainPanel.add(getCheckBoxPanel());
		mainPanel.add(getButtonPanel());
		setWidget(mainPanel);
	}
	
	private VerticalContainer getCheckBoxPanel() {
		VerticalContainer panel = new VerticalContainer();
		panel.add(getAllNonePanel());
		targetedStatusCB = new CheckBoxWidget(constants.targeted());
		panel.add(targetedStatusCB);
		readyForDistStatusCB = new CheckBoxWidget(constants.ready_for_distribution());
		panel.add(readyForDistStatusCB);
		inProgressStatusCB = new CheckBoxWidget(constants.in_progress());
		panel.add(inProgressStatusCB);
		distributedStatusCB = new CheckBoxWidget(constants.distributed());
		panel.add(distributedStatusCB);
		failedStatusCB = new CheckBoxWidget(constants.failed());
		panel.add(failedStatusCB);
		return panel;
	}
	
	private HorizontalContainer getAllNonePanel() {
		HorizontalContainer allNonePanel = new HorizontalContainer();
		allNonePanel.setSpacing(5);

		LabelWidget allLabel = new LabelWidget(constants.all());
		allLabel.addStyleName("sites-link");
		allLabel.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				setValueForAllCheckBoxes(true);
			}});
		allNonePanel.add(allLabel);

		LabelWidget noneLabel = new LabelWidget(constants.none());
		noneLabel.addStyleName("sites-link");
		noneLabel.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				setValueForAllCheckBoxes(false);
			}});
		allNonePanel.add(noneLabel);

		return allNonePanel;
	}

	private void setValueForAllCheckBoxes(boolean value) {
		targetedStatusCB.setValue(value);
		readyForDistStatusCB.setValue(value);
		inProgressStatusCB.setValue(value);
		distributedStatusCB.setValue(value);
		failedStatusCB.setValue(value);
	}
	
	private HorizontalContainer getButtonPanel() {
		HorizontalContainer panel = new HorizontalContainer();
		ButtonWidget exportButton = new ButtonWidget(constants.buttonLabelExport(), new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				hide();
				exportActionHandler.export(getSelectedStatuses());
			}});
		exportButton.addStyleDependentName(StyleNames.DO_BUTTON_STYLE);
		panel.add(exportButton);
		ButtonWidget cancelButton = new ButtonWidget(constants.buttonLabelCancel(), new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				hide();
			}});
		cancelButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		panel.add(cancelButton);
		return panel;
	}
	
	private List<UIDistributionStatus> getSelectedStatuses() {
		List<UIDistributionStatus> statuses = new ArrayList<UIDistributionStatus>();
		if(targetedStatusCB.getValue())
			statuses.add(UIDistributionStatus.TARGETED);
		if(readyForDistStatusCB.getValue())
			statuses.add(UIDistributionStatus.READY_FOR_DISTRIBUTION);
		if(inProgressStatusCB.getValue())
			statuses.add(UIDistributionStatus.IN_PROGRESS);
		if(distributedStatusCB.getValue())
			statuses.add(UIDistributionStatus.DISTRIBUTED);
		if(failedStatusCB.getValue())
			statuses.add(UIDistributionStatus.FAILED);
		return statuses;
	}
}
