package com.ericsson.cms.sites.ui.client;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.ericsson.cms.scheduling.ui.client.data.UiMetadataTree;
import com.ericsson.cms.sites.ui.client.entities.SiteActivityTables;
import com.ericsson.cms.sites.ui.client.entities.UIResourceGroup;
import com.ericsson.cms.sites.ui.client.entities.UISite;
import com.ericsson.cms.sites.ui.client.entities.UISiteTitleStatusData;
import com.ericsson.cms.sites.ui.client.entities.UISiteTreeNode;
import com.ericsson.cms.sites.ui.client.entities.UISiteType;
import com.ericsson.cms.sites.ui.client.entities.UIStatusPlugin;
import com.ericsson.cms.sites.ui.client.entities.UIStatusPluginType;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UIDistributionStatus;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UITrackingStatus;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleListItem;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;



@RemoteServiceRelativePath("service/sites/IUISiteService")
public interface IUISiteService extends RemoteService {
	List<UISiteTreeNode> getSiteTree() throws NeptuneException;
	List<UISite> getAllSites() throws NeptuneException;
	List<UISite> getAllDistributionSites() throws NeptuneException;
	List<UISite> getAllTrackingSites(Integer parentDistSiteId) throws NeptuneException;
	List<UISite> getShareableTrackingSites(int distributionSiteId) throws NeptuneException;

	UISite getNew() throws NeptuneException;
	UISite get(int siteId, Integer parentSiteId) throws NeptuneException;
	UISite save(UISite site) throws NeptuneException;
	void delete(int siteId) throws NeptuneException;
	void activate(int siteId) throws NeptuneException;
	void inactivate(int siteId) throws NeptuneException;
	String export(int siteId, List<UIDistributionStatus> statuses) throws NeptuneException;
	void associateTrackingSites(Set<Integer> trackingSiteIds, int distributionSiteId) throws NeptuneException;
	void dissociateTrackingSite(int trackingSiteId, int distributionSiteId) throws NeptuneException;
	
	List<UIRuleListItem> getRuleSetsBySiteAndPackage(int siteId, Packages packageType) throws NeptuneException;
	void dissociateRuleSets(int siteId, List<Integer> ruleSetIds) throws NeptuneException;
	
	Map<Long, String> getResourcesInGroup(String resourceGroupName) throws NeptuneException;

	List<UIStatusPlugin> getStatusPlugins(UIStatusPluginType statusPluginType) throws NeptuneException;
	UIStatusPlugin getAssociatedPluginForSite(int siteId, UIStatusPluginType statusPluginType)  throws NeptuneException;
	UIStatusPlugin getBlankUiStatusPlugin(UIStatusPluginType statusPluginType) throws NeptuneException;
	void updateStatusForAllPlugins(int siteId) throws NeptuneException;
	
	UISiteTitleStatusData getSiteTitleStatusData(
			UiTargetedTitlesRequest uiTargetedTitlesRequest)
			throws NeptuneException;
	List<String> getTemplateNames(int siteId) throws NeptuneException;
	
	void distributeImmediately(int siteId, List<Long> localTitleIds) throws NeptuneException;
	void deleteLocalTitles(int siteId, List<Long> localTitleIds) throws NeptuneException;
	void runTemplate(int siteId, List<Long> localTitleIds, String templateName) throws NeptuneException;
	
	/**
	 * Check if given <code>siteName</code> is already used for another site. 
	 * 
	 * @param siteName
	 * @return
	 * @throws NeptuneException
	 */
	boolean isSiteNameAlreadyUsed(String siteName) throws NeptuneException;
	
	/**
	 * Check if given <code>externalSiteId</code> is already used for another site, 
	 * of a type different from the given <code>uiSiteType</code>. 
	 * <p>
	 * The reason for this method is described in {@link http://bugzilla.us.tandbergtv.com/workflow/show_bug.cgi?id=6088}.
	 * 
	 * @param externalSiteId
	 * @param uiSiteType
	 * @return
	 * @throws NeptuneException
	 */
	boolean isExternalSiteIdAlreadyUsed(String externalSiteId, UISiteType uiSiteType) throws NeptuneException;
	
	boolean hasReachedMaxLicensedDistributionSites();
	
	boolean hasReachedMaxLicensedTrackingSites();

	UiMetadataTree getSiteTimerMetadataTree();
	Collection<UIResourceGroup> getAllResourceGroups() throws NeptuneException;
	Collection<UIResourceGroup> getAllGroupsByTemplateName(String name)throws NeptuneException;

	SiteActivityTables getDistSiteActivity(Integer distSiteId, UIDistributionStatus status,
			String fromDateStr, String toDateStr, Integer trackSiteId);
	SiteActivityTables getTrackSiteActivity(Integer trackSiteId, UITrackingStatus status,
			String fromDateStr, String toDateStr, Integer distSiteId);
}
