package com.ericsson.cms.sites.ui.client;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.ericsson.cms.scheduling.ui.client.data.UiMetadataTree;
import com.ericsson.cms.sites.ui.client.entities.SiteActivityTables;
import com.ericsson.cms.sites.ui.client.entities.UIResourceGroup;
import com.ericsson.cms.sites.ui.client.entities.UISite;
import com.ericsson.cms.sites.ui.client.entities.UISiteTitleStatusData;
import com.ericsson.cms.sites.ui.client.entities.UISiteTreeNode;
import com.ericsson.cms.sites.ui.client.entities.UISiteType;
import com.ericsson.cms.sites.ui.client.entities.UIStatusPlugin;
import com.ericsson.cms.sites.ui.client.entities.UIStatusPluginType;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UIDistributionStatus;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UITrackingStatus;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleListItem;


public interface IUISiteServiceAsync {
	void getSiteTree(AsyncCallback<List<UISiteTreeNode>> callback);
	void getAllSites(AsyncCallback<List<UISite>> callback);
	void getAllDistributionSites(AsyncCallback<List<UISite>> callback);
	void getAllTrackingSites(Integer parentDistSiteId, AsyncCallback<List<UISite>> callback);
	void getShareableTrackingSites(int distributionSiteId, AsyncCallback<List<UISite>> callback);

	void getNew(AsyncCallback<UISite> callback);
	void get(int siteId, Integer parentSiteId, AsyncCallback<UISite> callback);
	void save(UISite site, AsyncCallback<UISite> callback);
	void delete(int siteId, AsyncCallback<Void> callback);
	void activate(int siteId, AsyncCallback<Void> callback);
	void inactivate(int siteId, AsyncCallback<Void> callback);
	void export(int siteId, List<UIDistributionStatus> statuses, AsyncCallback<String> callback);
	
	void associateTrackingSites(Set<Integer> trackingSiteIds, int distributionSiteId,
			AsyncCallback<Void> callback);
	void dissociateTrackingSite(int trackingSiteId, int distributionSiteId,
			AsyncCallback<Void> callback);
	
	void getRuleSetsBySiteAndPackage(int siteId, Packages packageType,
			AsyncCallback<List<UIRuleListItem>> callback);
	void dissociateRuleSets(int siteId, List<Integer> ruleSetIds, AsyncCallback<Void> callback);
	
	void getResourcesInGroup(String resourceGroupName, AsyncCallback<Map<Long, String>> callback);
		

	void getStatusPlugins(UIStatusPluginType statusPluginType,
			AsyncCallback<List<UIStatusPlugin>> callback);

	void getAssociatedPluginForSite(int siteId,
			UIStatusPluginType statusPluginType,
			AsyncCallback<UIStatusPlugin> callback);
	
	void getBlankUiStatusPlugin(UIStatusPluginType statusPluginType,
			AsyncCallback<UIStatusPlugin> callback);

	void updateStatusForAllPlugins(int siteId, AsyncCallback<Void> callback);
	
	void getSiteTitleStatusData(UiTargetedTitlesRequest uiTargetedTitlesRequest,
			AsyncCallback<UISiteTitleStatusData> callback);

	void getTemplateNames(int siteId, AsyncCallback<List<String>> callback);

	void distributeImmediately(int siteId, List<Long> localTitleIds, AsyncCallback<Void> callback);

	void deleteLocalTitles(int siteId, List<Long> localTitleIds, AsyncCallback<Void> callback);
	
	void runTemplate(int siteId, List<Long> localTitleIds, String templateName, AsyncCallback<Void> callback);

	void isSiteNameAlreadyUsed(String siteName, AsyncCallback<Boolean> callback);

	void isExternalSiteIdAlreadyUsed(String externalSiteId, UISiteType uiSiteType, AsyncCallback<Boolean> callback);

	void hasReachedMaxLicensedDistributionSites(AsyncCallback<Boolean> callback);
	
	void hasReachedMaxLicensedTrackingSites(AsyncCallback<Boolean> callback);

	void getSiteTimerMetadataTree(AsyncCallback<UiMetadataTree> callback);
	

	void getAllResourceGroups(AsyncCallback<Collection<UIResourceGroup>> asyncCallback);
	void getAllGroupsByTemplateName(String name, AsyncCallback<Collection<UIResourceGroup>> asyncCallback);
	
	void getDistSiteActivity(Integer distSiteId, UIDistributionStatus status, String fromDateStr, String toDateStr, Integer trackSiteId,
			AsyncCallback<SiteActivityTables> callback);
	void getTrackSiteActivity(Integer trackSiteId, UITrackingStatus status, String fromDateStr, String toDateStr, Integer distSiteId,
			AsyncCallback<SiteActivityTables> callback);
}
