package com.ericsson.cms.sites.ui.client;

import java.util.Map;

import com.ericsson.cms.scheduling.ui.client.FilteredSchedules;
import com.ericsson.cms.sites.ui.client.SitesTabContainer.SiteCRUDNotifier;
import com.ericsson.cms.sites.ui.client.entities.UISite;
import com.ericsson.cms.sites.ui.client.entities.UISiteType;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class JobsTab extends Composite implements ISiteTab {
	public static final String NAME = "Jobs";
	
	private static final String ENTITY_TYPE_SITES = "Sites";
	
	private static final int MAIN_PANEL_OFFSET_WIDTH = 380;
	private static final int MAIN_PANEL_OFFSET_HEIGHT = 280;

	private VerticalContainer mainPanel;
	private UISite site;
	private BusyIndicator busyIndicator = new BusyIndicator();
	private FilteredSchedules filteredSchedules;
	
	private SitesConstants constants = GWT.create(SitesConstants.class);
	
	private HandlerRegistration windowRegistration = null;

	public JobsTab() {
		mainPanel = new VerticalContainer();

		filteredSchedules = new FilteredSchedules();
		mainPanel.add(filteredSchedules);
		initWidget(mainPanel);
		
		Scheduler.get().scheduleDeferred(new ScheduledCommand() {
			@Override
			public void execute() {
				updateMainPanelSize();
			}
		});
	}
	
	@Override
	public String getName() {
		return NAME;
	}

	@Override
	public String getDisplayName() {
		return constants.jobsTabName();
	}

	@Override
	public boolean setSite(UISite site, Map<String, String> params) {
		this.site = site;		
		return (site != null 
				&& ((site.getType() == UISiteType.DISTRIBUTION) || (site.getType() == UISiteType.MEDIAPATH_DISTRIBUTION)));
	}

	@Override
	public void setSelected(boolean selected) {
		if (selected && (site != null)) {
			History.newItem(Anchors.getAnchor(site.getId(), site.getParentId(), getName()), false);
			filteredSchedules.clearMessages();
			filteredSchedules.setEntity(ENTITY_TYPE_SITES, site.getId().longValue());
			updateMainPanelSize();
		}
	}
	
	@Override
	public void setCRUDNotifier(SiteCRUDNotifier crudNotifier) {
	}

	@Override
	public void setMessageArea(MessageArea messageArea) {
		filteredSchedules.setMessageArea(messageArea);
	}
	
	protected void updateMainPanelSize() {
		int offsetWidth = MAIN_PANEL_OFFSET_WIDTH; 
		int offsetHeight = MAIN_PANEL_OFFSET_HEIGHT;
		
		filteredSchedules.updateSize(offsetWidth, offsetHeight);
	}

	@Override
	protected void onLoad() {
		super.onLoad();

		windowRegistration = Window.addResizeHandler(new ResizeHandler() {
			public void onResize(ResizeEvent event) {
				updateMainPanelSize();
			}
		});
	};

	@Override
	protected void onUnload() {
		windowRegistration.removeHandler();
		windowRegistration = null;

		if (busyIndicator != null)
			busyIndicator.hide();

		super.onUnload();
	}

}
