package com.ericsson.cms.sites.ui.client;

import java.util.Map;

import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.LazyView;

public class LazySitesView extends LazyView {

	private SitesViewPanel widget = null;
	private Map<String, String> info;
	
	public LazySitesView() { }
	
	public LazySitesView(Map<String, String> info) {
		this.info = info;
	}
	
	@Override
	protected void setWidgetAnchor(String anchor) {
		widget.anchorChanged(anchor);
	}

	@Override
	protected Widget createWidget() {
		NeptuneSecurity security = NeptuneApplication.getApplication().getSecurity();
		widget = new SitesViewPanel(security, info);
		return widget;
	}

	@Override
	public String getAnchor() {
		return "#Sites.View";
	}

}
