package com.ericsson.cms.sites.ui.client;

import java.util.HashSet;
import java.util.Set;

import com.ericsson.cms.sites.ui.client.images.ISiteClientBundle;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

public class PropertyRow extends Composite {

	private TextBoxWidget nameWidget, valueWidget;
	private ImageWidget deleteIcon;
	private Set<HandlerRegistration> handlerRegistrations = new HashSet<HandlerRegistration>();
	
	private ISiteClientBundle imagesBundle = GWT.create(ISiteClientBundle.class);

	public PropertyRow() {
		final HorizontalContainer c = new HorizontalContainer();
		
		nameWidget = new TextBoxWidget();
		c.add(nameWidget);
		
		c.add(new LabelWidget("  "));
		
		valueWidget = new TextBoxWidget();
		c.add(valueWidget);
		
		deleteIcon = new ImageWidget();
		deleteIcon.setResource(imagesBundle.deleteIcon());
		c.add(deleteIcon);
		
		initWidget(c);
	}
	
	public void addDeleteIconClickHandler(ClickHandler handler) {
		handlerRegistrations.add(deleteIcon.addClickHandler(handler));
	}
	
	public void addKeyUpHandler(KeyUpHandler handler) {
		handlerRegistrations.add(nameWidget.addKeyUpHandler(handler));
		handlerRegistrations.add(valueWidget.addKeyUpHandler(handler));
	}
	
	public void setDeleteIconVisible(boolean visible) {
		if(deleteIcon != null)
			deleteIcon.setVisible(visible);
	}
	
	public boolean isBlank() {
		return isBlank(nameWidget.getText()) && isBlank(valueWidget.getText());
	}
	
	public String getName() {
		return nameWidget.getText().trim();
	}

	public String getValue() {
		return valueWidget.getText().trim();
	}

	private boolean isBlank(String text) {
		return text != null && text.trim().isEmpty();
	}
	
	@Override
	protected void onUnload() {
		super.onUnload();
		for(HandlerRegistration hr : handlerRegistrations) {
			hr.removeHandler();
		}
	}

}
